<?php
// Register Elementor Widgets through plugin core
if (!function_exists('fortis_elementor_register_widgets')) {
    add_filter('etc_register_widgets', 'fortis_elementor_register_widgets');
    function fortis_elementor_register_widgets($widgets)
    {
        $widgets = [
            [ // Cms Banner
                'name'       => 'cms_banner',
                'title'      => esc_html__('CMS Banner', 'fortis'),
                'icon'       => 'eicon-banner',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'banner', 'image'
                ]
            ],
            [ // Cms Heading
                'name'       => 'cms_heading',
                'title'      => esc_html__('CMS Heading', 'fortis'),
                'icon'       => 'eicon-heading',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'heading', 'custom heading'
                ]
            ],

            [ // Cms Fancy Box
                'name'       => 'cms_fancy_box',
                'title'      => esc_html__('CMS Fancy Box', 'fortis'),
                'icon'       => 'eicon-icon-box',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [],
                'styles'     => [],
                'keywords'   => [
                    'fortis', 'fancy-box', 'fancy', 'box'
                ]
            ],

            [ // Cms Button
                'name'       => 'cms_button',
                'title'      => esc_html__('CMS Button', 'fortis'),
                'icon'       => 'eicon-button',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords' => [
                    'fortis', 'cms button', 'button'
                ]
            ],
            [ // Cms Call to Action
                'name'       => 'cms_cta',
                'title'      => esc_html__('CMS Call To Action', 'fortis'),
                'icon'       => 'eicon-image-rollover',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms', 'call action', 'call', 'button'
                ]
            ],
            [ // Cms Slider
                'name'       => 'cms_slider',
                'title'      => esc_html__('CMS Slider', 'fortis'),
                'icon'       => 'eicon-slides',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-post-carousel-widget-js',
                ],
                'keywords' => [
                    'fortis', 'cms slider', 'slider'
                ]
            ],

            [ // Cms Page Title
                'name'       => 'cms_page_title',
                'title'      => esc_html__('CMS Page Title', 'fortis'),
                'icon'       => 'eicon-archive-title',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms page title', 'page title', 'title'
                ]
            ],

            [ // Cms Counter
                'name'       => 'cms_counter',
                'title'      => esc_html__('CMS Counter', 'fortis'),
                'icon'       => 'eicon-counter-circle',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => array(
                    'jquery-numerator',
                    'cms-counter-widget-js',
                    'cms-post-carousel-widget-js'
                ),
                'keywords' => [
                    'fortis', 'cms counter', 'counter'
                ]
            ],
            [ // Cms Counter Sticky
                'name'       => 'cms_counter_sticky',
                'title'      => esc_html__('CMS Counter Sticky', 'fortis'),
                'icon'       => 'eicon-counter-circle',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => array(
                    'jquery-numerator',
                    'cms-counter-sticky-widget-js',
                    'cms-counter-widget-js'
                ),
                'keywords' => [
                    'fortis', 'cms counter', 'counter', 'sticky'
                ]
            ],

            [ // Cms Countdown
                'name'       => 'cms_countdown',
                'title'      => esc_html__('CMS Countdown', 'fortis'),
                'icon'       => 'eicon-countdown',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms countdown', 'countdown'
                ]
            ],

            [ // Cms Video
                'name'       => 'cms_video_player',
                'title'      => esc_html__('CMS Video Player', 'fortis'),
                'icon'       => 'eicon-play',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms video player', 'video'
                ]
            ],

            [ // Cms Single Image
                'name'       => 'cms_single_image',
                'title'      => esc_html__('CMS Single Image', 'fortis'),
                'icon'       => 'eicon-info-box',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms single image', 'image'
                ]
            ],

            [ // Cms List
                'name'       => 'cms_list',
                'title'      => esc_html__('CMS List', 'fortis'),
                'icon'       => 'eicon-editor-list-ul',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                   'fortis', 'cms list', 'list'
                ]
            ],

            [ // Cms Icon
                'name'       => 'cms_icon',
                'title'      => esc_html__('CMS Icon', 'fortis'),
                'icon'       => 'eicon-alert',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms icon', 'icon'
                ]
            ],

            [ // Cms Blog
                'name'       => 'cms_blog',
                'title'      => esc_html__('CMS Blog', 'fortis'),
                'icon'       => 'eicon-posts-grid',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'imagesloaded',
                    'isotope',
                    'cms-post-grid-widget-js',
                ],
                'keywords' => [
                    'fortis', 'blog', 'post', 'grid'
                ]
            ],

            [ // Cms Blog Grid
                'name'       => 'cms_blog_grid',
                'title'      => esc_html__('CMS Blog Grid', 'fortis'),
                'icon'       => 'eicon-posts-grid',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'imagesloaded',
                    'isotope',
                    'cms-post-grid-widget-js',
                ],
                'keywords' => [
                    'fortis', 'blog', 'post', 'grid'
                ]
            ],

            [ // Cms Blog Carousel
                'name'       => 'cms_blog_carousel',
                'title'      => esc_html__('CMS Blog Carousel', 'fortis'),
                'icon'       => 'eicon-posts-carousel',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-post-carousel-widget-js',
                ],
                'keywords' => [
                    'fortis', 'blog', 'post', 'carousel'
                ]
            ],
            [ // Cms Navigation Menu
                'name'       => 'cms_navigation_menu',
                'title'      => esc_html__('CMS Menu', 'fortis'),
                'icon'       => 'eicon-menu-bar',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms navigation menu', 'menu'
                ]
            ],

            [ // Cms Accordion
                'name'       => 'cms_accordion',
                'title'      => esc_html__('CMS Accordion', 'fortis'),
                'icon'       => 'eicon-accordion',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => array(
                    'cms-accordion-widget-js',
                ),
                'keywords' => [
                    'fortis', 'cms accordion', 'accordion'
                ]
            ],

            [ // Cms Clients Carousel
                'name'       => 'cms_clients',
                'title'      => esc_html__('CMS Clients', 'fortis'),
                'icon'       => 'eicon-person',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-post-carousel-widget-js',
                ],
                'keywords' => [
                    'cms', 'fortis', 'client', 'clients', 'carousel'
                ]
            ],

            [ // Cms Teams (Grid + Carousel)
                'name'       => 'cms_teams',
                'title'      => esc_html__('CMS Teams', 'fortis'),
                'icon'       => 'eicon-user-circle-o',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-post-carousel-widget-js',
                ],
                'keywords' => [
                    'cms', 'fortis', 'team', 'teams', 'grid', 'carousel'
                ]
            ],

            [ // Cms Testimonial Carousel
                'name'       => 'cms_testimonials',
                'title'      => esc_html__('CMS Testimonials', 'fortis'),
                'icon'       => 'eicon-testimonial',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-post-carousel-widget-js',
                ],
                'keywords' => [
                    'cms', 'fortis', 'testimonial', 'testimonials', 'carousel'
                ]
            ],

            [ // Cms Progress Bar
                'name'       => 'cms_progressbar',
                'title'      => esc_html__('CMS Progress Bar', 'fortis'),
                'icon'       => 'eicon-skill-bar',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-progressbar-widget-js',
                ],
                'keywords' => [
                    'fortis', 'cms progressbar', 'progress bar'
                ]
            ],
            [ // Cms Process
                'name'       => 'cms_process',
                'title'      => esc_html__('CMS Process', 'fortis'),
                'icon'       => 'eicon-counter-circle',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-post-carousel-widget-js',
                ],
                'keywords' => [
                    'fortis', 'cms process', 'process'
                ]
            ],
            [ // Cms Pricing
                'name'       => 'cms_pricing',
                'title'      => esc_html__('CMS Pricing', 'fortis'),
                'icon'       => 'eicon-price-table',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-post-carousel-widget-js',
                ],
                'keywords' => [
                    'fortis', 'cms pricing', 'pricing', 'price'
                ]
            ],
            [ // Cms Breadcrumb
                'name'       => 'cms_breadcrumb',
                'title'      => esc_html__('CMS Breadcrumb', 'fortis'),
                'icon'       => 'eicon-ellipsis-h',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'breadcrumb'
                ]
            ],

            [ // Cms Copyright
                'name'       => 'cms_copyright',
                'title'      => esc_html__('CMS Copyright', 'fortis'),
                'icon'       => 'eicon-menu-bar',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms copyright', 'copyright'
                ]
            ],
            [ // Cms Anchor Link
                'name'       => 'cms_anchor',
                'title'      => esc_html__('CMS Anchor', 'fortis'),
                'icon'       => 'eicon-menu-bar',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms anchor', 'anchor'
                ]
            ],
            [ // CMS Quick Contact
                'name'       => 'cms_quickcontact',
                'title'      => esc_html__('CMS Quick Contact', 'fortis'),
                'icon'       => 'eicon-mail',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms quick contact', 'quick', 'contact',
                ]
            ],
            [ // CMS Socials Icons
                'name'       => 'cms_social_icons',
                'title'      => esc_html__('CMS Socials Icon', 'fortis'),
                'icon'       => 'eicon-social-icons',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms social', 'icon', 'social icon',
                ]
            ],
            [ // CMS Star Rating
                'name'       => 'cms_star_rating',
                'title'      => esc_html__('CMS Star Ratings', 'fortis'),
                'icon'       => 'eicon-rating',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms rating', 'rating', 'star',
                ]
            ],
            [ // CMS Find Location
                'name'       => 'cms_find_location',
                'title'      => esc_html__('CMS Find Location', 'fortis'),
                'icon'       => 'eicon-map',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms location', 'location', 'find',
                ]
            ],
            [ // CMS Gallery
                'name'       => 'cms_gallery',
                'title'      => esc_html__('CMS Gallery', 'fortis'),
                'icon'       => 'eicon-gallery-grid',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms gallery', 'gallery', 'image',
                ],
                'scripts' => [
                    'cms-galleries'
                ]
            ],
            [ // CMS Gallery Carousel
                'name'       => 'cms_gallery_carousel',
                'title'      => esc_html__('CMS Gallery Carousel', 'fortis'),
                'icon'       => 'eicon-posts-carousel',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms gallery', 'gallery', 'image', 'carousel'
                ],
                'scripts' => [
                    'cms-post-carousel-widget-js'
                ]
            ],
            [ // CMS Support
                'name'       => 'cms_support',
                'title'      => esc_html__('CMS Support', 'fortis'),
                'icon'       => 'eicon-person',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms support', 'support', 'hel', 'call center'
                ]
            ],
            [ // CMS Download
                'name'       => 'cms_download',
                'title'      => esc_html__('CMS Download', 'fortis'),
                'icon'       => 'eicon-anchor',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms download', 'download', 'document'
                ]
            ],
            [ // CMS Chart
                'name'       => 'cms_chart',
                'title'      => esc_html__('CMS Chart', 'fortis'),
                'icon'       => 'eicon-circle-o',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'fortis', 'cms chart', 'chart', 'chartjs'
                ],
                'scripts'    => array(
                    'chartjs',
                    'cms-chartjs'
                )
            ],
        ];
        if(apply_filters('fortis_enable_service', true)){
            $widgets[] = [ // Cms Service Grid
                'name'       => 'cms_service_grid',
                'title'      => esc_html__('CMS Service Grid', 'fortis'),
                'icon'       => 'eicon-posts-grid',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'imagesloaded',
                    'isotope',
                    'cms-post-grid-widget-js',
                ],
                'keywords' => [
                    'fortis', 'service', 'grid'
                ]
            ];
            $widgets[] = [ // Cms Service Carousel
                'name'       => 'cms_service_carousel',
                'title'      => esc_html__('CMS Service Carousel', 'fortis'),
                'icon'       => 'eicon-posts-carousel',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-post-carousel-widget-js',
                ],
                'keywords' => [
                    'fortis', 'service', 'carousel'
                ]
            ];
        }
        if(apply_filters('fortis_enable_industry', true)){
            $widgets[] = [ // Cms Industry Grid
                'name'       => 'cms_industry_grid',
                'title'      => esc_html__('CMS Industry Grid', 'fortis'),
                'icon'       => 'eicon-posts-grid',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'imagesloaded',
                    'isotope',
                    'cms-post-grid-widget-js',
                ],
                'keywords' => [
                    'fortis', 'industry', 'grid'
                ]
            ];
            $widgets[] = [ // Cms Industry Carousel
                'name'       => 'cms_industry_carousel',
                'title'      => esc_html__('CMS Industry Carousel', 'fortis'),
                'icon'       => 'eicon-posts-carousel',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-post-carousel-widget-js',
                ],
                'keywords' => [
                    'fortis', 'industry', 'carousel'
                ]
            ];
        }
        if(apply_filters('fortis_enable_case', true)){
            $widgets[] = [ // Cms Case
                'name'       => 'cms_case',
                'title'      => esc_html__('CMS Case', 'fortis'),
                'icon'       => 'eicon-posts-masonry',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords' => [
                    'fortis', 'case', 'grid'
                ]
            ];
            $widgets[] = [ // Cms Case Grid
                'name'       => 'cms_case_grid',
                'title'      => esc_html__('CMS Case Grid', 'fortis'),
                'icon'       => 'eicon-posts-grid',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'imagesloaded',
                    'isotope',
                    'cms-post-grid-widget-js',
                ],
                'keywords' => [
                    'fortis', 'case', 'grid'
                ]
            ];
            $widgets[] = [ // Cms Case Carousel
                'name'       => 'cms_case_carousel',
                'title'      => esc_html__('CMS Case Carousel', 'fortis'),
                'icon'       => 'eicon-posts-carousel',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-post-carousel-widget-js',
                ],
                'keywords' => [
                    'fortis', 'case', 'carousel'
                ]
            ];
        }
        if(apply_filters('fortis_enable_career', true)){
            $widgets[] = [ // Cms Career Grid
                'name'       => 'cms_career_grid',
                'title'      => esc_html__('CMS Career Grid', 'fortis'),
                'icon'       => 'eicon-posts-grid',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'imagesloaded',
                    'isotope',
                    'cms-post-grid-widget-js',
                ],
                'keywords' => [
                    'fortis', 'career', 'grid'
                ]
            ];
            $widgets[] = [ // Cms Career Carousel
                'name'       => 'cms_career_carousel',
                'title'      => esc_html__('CMS Career Carousel', 'fortis'),
                'icon'       => 'eicon-posts-carousel',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-post-carousel-widget-js',
                ],
                'keywords' => [
                    'fortis', 'career', 'carousel'
                ]
            ];
        }
        // Contact Form 7
        if (class_exists('WPCF7')) {
            $widgets[] = [
                'name'       => 'cms_contact_form',
                'title'      => esc_html__('CMS Contact Form 7', 'fortis'),
                'icon'       => 'eicon-form-horizontal',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [],
                'styles'     => [],
                'keywords'   => [
                    'cms', 'fortis', 'contact-form', 'form', 'contact'
                ]
            ];
        }
        // Newsletter
        if(class_exists('Newsletter')){
            $widgets[] = [
                'name'       => 'cms_newsletter',
                'title'      => esc_html__( 'CMS Newsletter', 'fortis' ),
                'icon'       => 'eicon-mail',
                'categories' => array( Elementor_Theme_Core::ETC_CATEGORY_NAME ),
                'keywords'   => [
                    'cms', 'fortis', 'newsletter'
                ]
            ];
        }
        // Language Swicther
        if(class_exists('TRP_Translate_Press')){
            $widgets[] = [
                'name'       => 'cms_language_switcher',
                'title'      => esc_html__( 'CMS Language Switcher', 'fortis' ),
                'icon'       => 'eicon-exchange',
                'categories' => array( Elementor_Theme_Core::ETC_CATEGORY_NAME ),
                'keywords'   => [
                    'cms', 'fortis', 'language', 'language switcher'
                ]
            ];
        }
        return $widgets;
    }
}
if(!function_exists('fortis_add_hidden_device_controls')){
    function fortis_add_hidden_device_controls($widget = [], $args = []) {
        $args = wp_parse_args($args, [
            'prefix'    => 'cms_',
            'condition' => []
        ]);
        // The 'Hide On X' controls are displayed from largest to smallest, while the method returns smallest to largest.
        $active_devices = \Elementor\Plugin::$instance->breakpoints->get_active_devices_list( [ 'reverse' => true ] );
        $active_breakpoints = \Elementor\Plugin::$instance->breakpoints->get_active_breakpoints();

        foreach ( $active_devices as $breakpoint_key ) {
            $label = 'desktop' === $breakpoint_key ? esc_html__( 'Desktop', 'fortis' ) : $active_breakpoints[ $breakpoint_key ]->get_label();

            $widget->add_control(
                $args['prefix'].'hide_' . $breakpoint_key,
                [
                    /* translators: %s: Device name. */
                    'label'        => sprintf( __( 'Hide On %s', 'fortis' ), $label ),
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'default'      => '',
                    //'prefix_class' => 'elementor-',
                    'label_on'     => esc_html__( 'Hide', 'fortis' ),
                    'label_off'    => esc_html__( 'Show', 'fortis' ),
                    //'return_value' => 'hidden-' . $breakpoint_key,
                    'condition' => $args['condition']
                ]
            );
        }
    }
}
if(!function_exists('fortis_add_hidden_device_controls_render')){
    function fortis_add_hidden_device_controls_render($settings = [], $prefix = ''){
        $active_devices     = \Elementor\Plugin::$instance->breakpoints->get_active_devices_list( [ 'reverse' => true ] );
        $active_breakpoints = \Elementor\Plugin::$instance->breakpoints->get_active_breakpoints();
        $hidden             = [];
        foreach ($active_devices as $device) {
            $hidden[] = ($settings[$prefix.'hide_'.$device] === 'yes') ? 'cms-hidden-'.$device : '';
        }
        return implode(' ',array_filter($hidden));
    }
}

// Scan files to register controls for each new custom widget
$files = scandir(get_template_directory() . '/elementor/core/widgets');
foreach ($files as $file) {
    $pos = strrpos($file, ".php");
    if ($pos !== false) {
        require_once get_template_directory() . '/elementor/core/widgets/' . $file;
    }
}
/**
 * Extra Elementor Icons
 */
if (!function_exists('fortis_register_custom_icon_library')) {
    add_filter('elementor/icons_manager/native', 'fortis_register_custom_icon_library');
    function fortis_register_custom_icon_library($tabs)
    {
        $custom_tabs = [
            'cmsi_icon' => [
                'name'          => 'cmsi-icon',
                'label'         => esc_html__('CMS Icons', 'fortis'),
                'url'           => get_template_directory_uri() . '/assets/fonts/font-cmsi/style.css',
                'enqueue'       => [],
                'prefix'        => 'cmsi-',
                'displayPrefix' => '',
                'labelIcon'     => 'cmsi-arrow-circle-right',
                'ver'           => '1.0.0',
                'fetchJson'     => get_template_directory_uri() . '/assets/fonts/font-cmsi.js',
                'native'        => true,
            ],
            'cmsi_fortis' => [
                'name'          => 'cmsi-fortis',
                'label'         => esc_html__('CMS Fortis', 'fortis'),
                'url'           => get_template_directory_uri() . '/assets/fonts/font-theme/style.css',
                'enqueue'       => [],
                'prefix'        => 'fortis-icon-',
                'displayPrefix' => '',
                'labelIcon'     => 'fortis-icon-default',
                'ver'           => '1.0.0',
                'fetchJson'     => get_template_directory_uri() . '/assets/fonts/font-theme.js',
                'native'        => true,
            ]
        ];
        $tabs = array_merge($custom_tabs, $tabs);
        return $tabs;
    }
}