<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if (!function_exists('fortis_widget_cms_accordion_register_controls')) {
    add_action('etc_widget_cms_accordion_register_controls', 'fortis_widget_cms_accordion_register_controls', 10, 1);
    function fortis_widget_cms_accordion_register_controls($widget)
    {
        // Content Tab Start

        // Layout Section Start
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
        
        $widget->add_control(
            'layout',
            [
                'label'   => esc_html__( 'Templates', 'fortis' ),
                'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                'options' => [
                    '1' => [
                        'label' => esc_html__( 'Layout 1', 'fortis' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_accordion/layout/1.jpg'
                    ]
                ],
                'default' => '1'
            ]
        );

        $widget->end_controls_section();
        // Layout Section End

        // accordion Section Start
        $widget->start_controls_section(
            'section_accordion',
            [
                'label' => esc_html__('Accordion', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'active_section',
            [
                'label'     => esc_html__( 'Active section', 'fortis' ),
                'type'      => \Elementor\Controls_Manager::NUMBER,
                'default'   => '1',
                'min'       => '0',
                'max'       => '50',
                'separator' => 'after',
            ]
        );
        $widget->add_control('cms_accordion', [
            'label' => esc_html__('Accordion Items', 'fortis'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => [
                [
                    'name'        => 'ac_title',
                    'label'       => esc_html__( 'Title', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'default'     => 'Title',
                    'placeholder' => esc_html__( 'Enter your title', 'fortis' ),
                    'label_block' => true,
                ],
                [
                    'name'        => 'ac_content',
                    'label'       => esc_html__( 'Content', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'default'     => 'Item content. Click the edit button to change this text.',
                    'placeholder' => esc_html__( 'Enter your content', 'fortis' ),
                    'label_block' => true,
                ],
            ],
            'default' => [
                [
                    'ac_title'   => 'Title',
                    'ac_content' => 'Item content. Click the edit button to change this text.',
                ],
                [
                    'ac_title'   => 'Title',
                    'ac_content' => 'Item content. Click the edit button to change this text.',
                ],
            ],
            'title_field' => '{{{ ac_title }}}',
        ]);
        $widget->end_controls_section(); // accordion Section End

        // Content Tab End

    }
}
