<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if (!function_exists('fortis_widget_cms_anchor_register_controls')) {
    add_action('etc_widget_cms_anchor_register_controls', 'fortis_widget_cms_anchor_register_controls', 10, 1);
    function fortis_widget_cms_anchor_register_controls($widget)
    {
        // Layout Tab Start
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );

        $widget->add_control(
            'layout',
            [
                'label'   => esc_html__( 'Templates', 'fortis' ),
                'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                'options' => [
                    '1' => [
                        'label' => esc_html__( 'Layout 1', 'fortis' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_anchor/layout/1.jpg'
                    ],
                    '2' => [
                        'label' => esc_html__( 'Layout 2', 'fortis' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_anchor/layout/2.jpg'
                    ],
                    '3' => [
                        'label' => esc_html__( 'Layout 3', 'fortis' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_anchor/layout/3.jpg'
                    ],
                    '4' => [
                        'label' => esc_html__( 'Layout 4', 'fortis' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_anchor/layout/4.jpg'
                    ],
                ],
                'default'      => '1',
                'prefix_class' => 'cms-anchor-',
                'style_transfer' => true
            ]
        );

        $widget->end_controls_section();
        // Layout Tab End

        // Content Tab Start

        // anchor Section Start
        $widget->start_controls_section(
            'section_anchor',
            [
                'label' => esc_html__('Anchor', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'title',
            [
                'label'   => esc_html__('Title', 'fortis'),
                'type'    => Controls_Manager::TEXT,
                'default' => esc_html__('Back To Top', 'fortis'),
            ]
        );
        $widget->add_control(
            'anchor_id',
            [
                'label'       => esc_html__( 'ID', 'fortis' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => 'cms-header-wrap',
                'description' => __('This ID will be the CSS ID you will have to use in your own page, Without #.', 'fortis'),
            ]
        );
        $widget->add_control(
            'anchor_note',
            [
                'type'            => \Elementor\Controls_Manager::RAW_HTML,
                'raw'             => sprintf( __( 'Note: The ID link ONLY accepts these chars: %s', 'fortis' ), '`A-Z, a-z, 0-9, _ , -`' ),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
            ]
        );
        $widget->add_control(
            'selected_icon',
            [
                'label'            => esc_html__( 'Icon', 'fortis' ),
                'type'             => \Elementor\Controls_Manager::ICONS,
                'default'          => [
                    'library' => 'cmsi',
                    'value'   => 'cmsi-long-arrow-up'
                ]
            ]
        );
        $widget->end_controls_section(); // anchor Section End

        // Content Tab End
        // Style
        $widget->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout' => ['3']
                ]
            ]
        );
            $widget->add_control(
                'size',
                [
                    'label'   => esc_html__('Size', 'fortis'),
                    'type'    => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 20,
                            'max' => 200,
                        ]
                    ],
                    'default' => [],
                    'selectors' => [
                        '{{WRAPPER}} .cms-anchor' => 'width:{{SIZE}}px; height:{{SIZE}}px;line-height:{{SIZE}}px;'
                    ]
                ]
            );
        $widget->end_controls_section();

    }
}
