<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;

if (!function_exists('fortis_widget_cms_banner_register_controls')) {
    add_action('etc_widget_cms_banner_register_controls', 'fortis_widget_cms_banner_register_controls', 10, 1);
    function fortis_widget_cms_banner_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/2.jpg'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/3.jpg'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/4.jpg'
                        ],
                        '5' => [
                            'label' => esc_html__( 'Layout 5', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/5.jpg'
                        ],
                        '6' => [
                            'label' => esc_html__( 'Layout 6', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/6.jpg'
                        ],
                        '7' => [
                            'label' => esc_html__( 'Layout 7', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/7.jpg'
                        ],
                        '8' => [
                            'label' => esc_html__( 'Layout 8', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/8.jpg'
                        ],
                        '9' => [
                            'label' => esc_html__( 'Layout 9', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/9.jpg'
                        ],
                        '10' => [
                            'label' => esc_html__( 'Layout 10', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/10.jpg'
                        ],
                        '11' => [
                            'label' => esc_html__( 'Layout 11', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/11.jpg'
                        ],
                        '12' => [
                            'label' => esc_html__( 'Layout 12', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/12.jpg'
                        ],
                        '13' => [
                            'label' => esc_html__( 'Layout 13', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/13.jpg'
                        ],
                        '14' => [
                            'label' => esc_html__( 'Layout 14', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/14.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class'   => 'cms-ebanner-'
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start

        // single_image Section Start
        $widget->start_controls_section(
            'section_single_image',
            [
                'label' => esc_html__('Banner Image', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'banner',
                [
                    'label'   => esc_html__( 'Banner', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ]
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'banner',
                    'label'   => esc_html__('Image Size','fortis'),
                    'default' => 'custom',
                    'condition' => [
                        'banner[url]!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'banner2',
                [
                    'label'   => esc_html__( 'Banner #2', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ],
                    'condition' => [
                        'layout' => ['14']
                    ]
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'banner2',
                    'label'   => esc_html__('Image Size','fortis'),
                    'default' => 'custom',
                    'condition' => [
                        'layout' => ['14'],
                        'banner2[url]!' => ''
                    ]
                ]
            );

            $widget->add_control(
                'icon',
                [
                    'label'            => esc_html__('Icon', 'fortis'),
                    'type'             => Controls_Manager::ICONS,
                    'skin'             => 'inline',
                    'label_block'      => false,
                    'default'          => [
                        'library' => 'fortis',
                        'value'   => 'fortis-icon-gear3'
                    ],
                    'condition' => [
                        'layout' => ['2','3','4','7','8','10','11','13'],
                        'banner[url]!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'title',
                [
                    'label'   => esc_html__( 'Title', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::TEXTAREA,
                    'default' => 'Building The Future, Restoring The Past',
                    'condition' => [
                        'layout' => ['2','3','4','7','8','10','11','13'],
                        'banner[url]!' => ''
                    ]
                ]
            );
        $widget->end_controls_section(); // single_image Section End

        $widget->start_controls_section(
            'section_banner_content',
            [
                'label' => esc_html__('Content', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            
            // Call To Action
            $widget->add_control(
                'cta_text',
                [
                    'label'       => esc_html__( 'CTA Content', 'fortis' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'We have established corporate mandate to maintain strong core values that truly reflect the philosophy.',
                    'placeholder' => esc_html__( 'Enter your text', 'fortis' ),
                    'label_block' => true,
                    'condition'   => [
                        'layout' => ['6']
                    ]
                ]
            ); 
            $widget->add_control(
                'cta_link_text',
                [
                    'label'       => esc_html__( 'CTA Link Settings', 'fortis' ),
                    'description' => esc_html__('Link Text', 'fortis'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => esc_html__( 'Click here', 'fortis' ),
                    'placeholder' => esc_html__( 'Click here', 'fortis' ),
                    'label_block' => true,
                    'condition'   => [
                        'layout'    => ['6'],
                        'cta_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'cta_link_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'layout'         => ['6'],
                        'cta_text!'      => '',
                        'cta_link_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'cta_page_link',
                [
                    'label'     => esc_html__('Select Page', 'fortis'),
                    'type'      => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'layout'         => ['6'],
                        'cta_text!'      => '',
                        'cta_link_text!' => '',
                        'cta_link_type'  => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'cta_custom_link',
                [
                    'label'       => esc_html__( 'Link', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'layout'         => ['6'],
                        'cta_text!'      => '',
                        'cta_link_text!' => '',
                        'cta_link_type'  => 'custom'
                    ]
                ]
            );
            $widget->add_control(
                'heading',
                [
                    'label'   => esc_html__( 'Heading', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::TEXTAREA,
                    'default' => 'We Maintain Strong Core Values That Truly Reflect Our Philosophy.',
                    'condition' => [
                        'layout' => ['8']
                    ]
                ]
            );
            $widget->add_control(
                'description',
                [
                    'label'   => esc_html__( 'Description', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::TEXTAREA,
                    'default' => 'We believe that partnerships are fundamental to our growth. We\'ll seek the highest quality global forwarding services.',
                    'condition' => [
                        'layout' => ['4','5','6','8', '10']
                    ]
                ]
            );
            // Features
            $repeater = new Repeater();
            $repeater->add_control(
                'icon',
                [
                    'label'       => esc_html__( 'Icon', 'fortis' ),
                    'default'     => [
                        'library'   => 'cmsi',
                        'value'     => 'cmsi-check-circle'
                    ],
                    'type'        => Controls_Manager::ICONS,
                    'skin'        => 'inline',
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'fortis' ),
                    'default'     => esc_html__( 'Title', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $widget->add_control(
                'cms_feature',
                [
                    'label'       => esc_html__('Features List', 'fortis'),
                    'type'        => Controls_Manager::REPEATER,
                    'label_block' => true,
                    'fields'      => $repeater->get_controls(),
                    'default'     => [
                        [
                            'icon'  => [
                                'library'   => 'cmsi',
                                'value'     => 'cmsi-check-circle'
                            ],
                            'title' => 'Quality Control System, Highly Professional Staff',
                        ],
                        [
                            'icon'  => [
                                'library'   => 'cmsi',
                                'value'     => 'cmsi-check-circle'
                            ],
                            'title' => 'Satisfaction Guarantee, and Accurate Testing',
                        ]
                    ],
                    'title_field' => '{{{ title }}}',
                    'condition' => [
                        'layout' => ['8']
                    ]
                ]
            );
            //Button
            $widget->add_control(
                'btn_icon',
                [
                    'label'            => esc_html__('Icon', 'fortis'),
                    'type'             => Controls_Manager::ICONS,
                    'skin'             => 'inline',
                    'label_block'      => false,
                    'default'          => [
                        'library' => 'cmsi',
                        'value'   => 'cmsi-arrow-circle-right'
                    ],
                    'condition' => [
                        'layout' => ['10']
                    ]
                ]
            );
            $widget->add_control(
                'btn_text',
                [
                    'label'       => esc_html__( 'Buttons', 'fortis' ),
                    'description' => esc_html__('Buttons Text','fortis'), 
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Click Here',
                    'placeholder' => esc_html__( 'Click here', 'fortis' ),
                    'condition' => [
                        'layout' => ['2','3','4','5','6','7','8','10']
                    ],
                    'label_block' => true
                ]
            );
            $widget->add_control(
                'btn_link_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default'   => 'custom',
                    'condition' => [
                        'layout'    => ['2','3','4','5','6','7','8','10'],
                        'btn_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'btn_page_link',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'layout' => ['2','3','4','5','6','7','8','10'],
                        'btn_text!' => '',
                        'btn_link_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'btn_link',
                [
                    'label'       => esc_html__( 'Link', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'layout' => ['2','3','4','5','6','7','8','10'],
                        'btn_text!' => '',
                        'btn_link_type' => 'custom'
                    ]
                ]
            );
            //Button #2
            $widget->add_control(
                'btn2_text',
                [
                    'label'       => esc_html__( 'Buttons #2', 'fortis' ),
                    'description' => esc_html__('Buttons #2 Text','fortis'), 
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Click Here #2',
                    'placeholder' => esc_html__( 'Click here #2', 'fortis' ),
                    'condition'   => [
                        'layout' => ['6','8']
                    ],
                    'label_block' => true
                ]
            );
            $widget->add_control(
                'btn2_link_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'layout' => ['6','8'],
                        'btn2_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'btn2_page_link',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'layout' => ['6','8'],
                        'btn2_text!' => '',
                        'btn2_link_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'btn2_link',
                [
                    'label'       => esc_html__( 'Link', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'layout' => ['6','8'],
                        'btn2_text!' => '',
                        'btn2_link_type' => 'custom'
                    ]
                ]
            );
        $widget->end_controls_section(); // single_image Section End
        // Content Tab End
        // Style Tab
        $widget->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style Settings','fortis'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
            $widget->add_responsive_control(
                'align',
                [
                    'label'        => esc_html__( 'Alignment', 'fortis' ),
                    'type'         => Controls_Manager::CHOOSE,
                    'responsive'   => true,
                    'options'      => [
                        'start'    => [
                            'title' => esc_html__( 'Left', 'fortis' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center'  => [
                            'title' => esc_html__( 'Center', 'fortis' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'end'   => [
                            'title' => esc_html__( 'Right', 'fortis' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__( 'Justified', 'fortis' ),
                            'icon' => 'eicon-text-align-justify',
                        ]
                    ],
                    'prefix_class' => 'text%s-'
                ]
            );
            $widget->add_responsive_control(
                'cta_color',
                [
                    'label'      => esc_html__( 'CTA Text Color', 'fortis' ),
                    'type'       => \Elementor\Controls_Manager::COLOR,
                    'selectors'  => [
                        '{{WRAPPER}} .cms-cta-text' => 'color: {{VALUE}};'
                    ],
                    'condition' => [
                        'layout' => ['6']
                    ]
                ]
            );
            $widget->add_responsive_control(
                'cta_link_color',
                [
                    'label'      => esc_html__( 'CTA Link Color', 'fortis' ),
                    'type'       => \Elementor\Controls_Manager::COLOR,
                    'selectors'  => [
                        '{{WRAPPER}} .cta-link' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'layout' => ['6']
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
