<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;

if (!function_exists('fortis_widget_cms_blog_register_controls')) {
    add_action('etc_widget_cms_blog_register_controls', 'fortis_widget_cms_blog_register_controls', 10, 1);
    function fortis_widget_cms_blog_register_controls($widget)
    {
        // Layout Settings
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis' ),
                'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__('Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_blog/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_blog/layout/2.jpg'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_blog/layout/3.jpg'
                        ]
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-eblog cms-eblog-recent-'
                ]
            );
        $widget->end_controls_section();

        // Post term options
        $post_term_options = etc_get_grid_term_options('post');

        // Content Tab Start

        // Source Section Start
        $widget->start_controls_section(
            'source_section',
            [
                'label' => esc_html__('Source', 'fortis'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'source',
            [
                'label' => esc_html__('Select Categories', 'fortis'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $post_term_options,
            ]
        );
        $widget->add_control(
            'orderby',
            [
                'label'   => esc_html__('Order By', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date'   => esc_html__('Date', 'fortis'),
                    'ID'     => esc_html__('ID', 'fortis'),
                    'author' => esc_html__('Author', 'fortis'),
                    'title'  => esc_html__('Title', 'fortis'),
                    'rand'   => esc_html__('Random', 'fortis'),
                ],
            ]
        );
        $widget->add_control(
            'order',
            [
                'label'   => esc_html__('Sort Order', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'desc' => esc_html__('Descending', 'fortis'),
                    'asc'  => esc_html__('Ascending', 'fortis'),
                ],
            ]
        );
        $widget->add_control(
            'limit',
            [
                'label'   => esc_html__('Total items', 'fortis'),
                'type'    => Controls_Manager::NUMBER,
                'default' => 5,
            ]
        );
        $widget->end_controls_section();
    }
}
