<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if (!function_exists('fortis_widget_cms_breadcrumb_register_controls')) {
    add_action('etc_widget_cms_breadcrumb_register_controls', 'fortis_widget_cms_breadcrumb_register_controls', 10, 1);
    function fortis_widget_cms_breadcrumb_register_controls($widget)
    {
        // Content Tab Start

        // Breadcrumb Start
        $widget->start_controls_section(
            'section_breadcrumb',
            [
                'label' => esc_html__('Breadcrumb', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'breadcrumb_color',
            [
                'label'     => esc_html__( 'Breadcrumb Color', 'fortis' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-breadcrumb' => 'color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_control(
            'align',
            [
                'label'        => esc_html__( 'Alignment', 'fortis' ),
                'type'         => \Elementor\Controls_Manager::CHOOSE,
                'control_type' => 'responsive',
                'options'      => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'fortis' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'fortis' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'fortis' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'selectors'    => [
                     '{{WRAPPER}} .cms-breadcrumb-wrap' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $widget->end_controls_section(); // Breadcrumb End

        // Content Tab End

    }
}
