<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if (!function_exists('fortis_widget_cms_button_register_controls')) {
    add_action('etc_widget_cms_button_register_controls', 'fortis_widget_cms_button_register_controls', 10, 1);
    function fortis_widget_cms_button_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_button/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_button/layout/2.jpg'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_button/layout/3.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true
                ]
            );
        $widget->end_controls_section();
        // Icon Section Start
        $widget->start_controls_section(
            'icon_section',
            [
                'label' => esc_html__('Content', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );         
            $widget->add_control(
                'text',
                [
                    'label'       => esc_html__( 'Text', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => esc_html__( 'Click here', 'fortis' ),
                    'placeholder' => esc_html__( 'Click here', 'fortis' )
                ]
            );
            $widget->add_control(
                'link_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom'
                ]
            );
            $widget->add_control(
                'page_link',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'link_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'link',
                [
                    'label'       => esc_html__( 'Link', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'link_type' => 'custom'
                    ]
                ]
            );
            $widget->add_responsive_control(
                'align',
                [
                    'label'        => esc_html__( 'Alignment', 'fortis' ),
                    'type'         => Controls_Manager::CHOOSE,
                    'responsive'   => true,
                    'options'      => [
                        'start'    => [
                            'title' => esc_html__( 'Left', 'fortis' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center'  => [
                            'title' => esc_html__( 'Center', 'fortis' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'end'   => [
                            'title' => esc_html__( 'Right', 'fortis' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__( 'Justified', 'fortis' ),
                            'icon' => 'eicon-text-align-justify',
                        ]
                    ],
                    'prefix_class' => 'text%s-'
                ]
            );
            $widget->add_control(
                'size',
                [
                    'label'        => esc_html__( 'Size', 'fortis' ),
                    'type'         => Controls_Manager::SELECT,
                    'options'      => [
                        //'btn-xs'    => esc_html__('Extra Small','fortis'),
                        'btn-sm'    => esc_html__('Small','fortis'),
                        ''  => esc_html__('Default','fortis'),
                        //'btn-md'    => esc_html__('Medium','fortis'),
                        'btn-lg'    => esc_html__('Large','fortis'),
                        //'btn-xl'    => esc_html__('Extra Large','fortis'),

                    ],
                    'style_transfer' => true,
                ]
            );

            $widget->add_control(
                'btn_icon',
                [
                    'label'       => esc_html__( 'Icon', 'fortis' ),
                    'type'        => Controls_Manager::ICONS,
                    'skin'        => 'inline',
                    'label_block' => false
                ]
            );
            $widget->add_control(
                'icon_align',
                [
                    'label'     => esc_html__( 'Icon Position', 'fortis' ),
                    'type'      => Controls_Manager::SELECT,
                    'default'   => '',
                    'options'   => [
                        ''      => esc_html__( 'Default', 'fortis' ),
                        'first' => esc_html__( 'Before', 'fortis' ),
                        'last'  => esc_html__( 'After', 'fortis' ),
                    ],
                ]
            );
            $widget->add_control(
                'icon_font_size',
                [
                    'label'        => esc_html__( 'Icon Font Size', 'fortis' ),
                    'type'         => Controls_Manager::SLIDER,
                    'control_type' => 'responsive',
                    'size_units'   => [ 'px' ],
                    'range'        => [
                        'px' => [
                            'min' => 5,
                            'max' => 35,
                        ],
                    ],
                    'selectors'    => [
                        '{{WRAPPER}} .cms-btn-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                    ]
                ]
            );
        $widget->end_controls_section();

        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $widget->add_control(
                'style',
                [
                    'label'   => esc_html__( 'Style', 'fortis' ),
                    'type'    => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        ''    => esc_html__( 'Default', 'fortis' )
                    ]
                ]
            );
            $widget->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'typography',
                    'selector' => '{{WRAPPER}} .btn',
                ]
            );
            $widget->add_control(
                'btn_padding',
                [
                    'label'        => esc_html__( 'Padding', 'fortis' ),
                    'type'         => Controls_Manager::DIMENSIONS,
                    'size_units'   => [ 'px' ],
                    'selectors'    => [
                        '{{WRAPPER}} .cms-button-wrap .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'control_type' => 'responsive',
                    'separator'    => 'before'
                ]
            );
            $widget->add_control(
                'btn_border_radius',
                [
                    'label'      => esc_html__( 'Border Radius', 'fortis' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px' ],
                    'selectors'  => [
                        '{{WRAPPER}} .cms-button-wrap .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        $widget->end_controls_section();
    }
}
