<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;

if (!function_exists('fortis_widget_cms_contact_form_register_controls')) {
    add_action('etc_widget_cms_contact_form_register_controls', 'fortis_widget_cms_contact_form_register_controls', 10, 1);
    function fortis_widget_cms_contact_form_register_controls($widget)
    {
        $cf7 = get_posts('post_type="wpcf7_contact_form"&numberposts=-1');
        $contact_forms = array();
        if ($cf7) {
            foreach ($cf7 as $cform) {
                $contact_forms[$cform->ID] = $cform->post_title;
            }
        } else {
            $contact_forms[esc_html__('No contact forms found', 'fortis')] = 0;
        }

        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_contact_form/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_contact_form/layout/2.jpg'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_contact_form/layout/3.jpg'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_contact_form/layout/4.jpg'
                        ],
                        '5' => [
                            'label' => esc_html__( 'Layout 5', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_contact_form/layout/5.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-ecf7-'
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start

        // Source Section Start
        $widget->start_controls_section(
            'source_section',
            [
                'label' => esc_html__('Source', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'ctf7_title',
            [
                'label'       => esc_html__('Title', 'fortis'),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $widget->add_control(
            'ctf7_description',
            [
                'label'   => esc_html__('Description', 'fortis'),
                'type'    => Controls_Manager::TEXTAREA,
                'show_label' => true,
            ]
        );
        $widget->add_control(
            'ctf7_slug',
            [
                'label'       => esc_html__('Select Form', 'fortis'),
                'type'        => Controls_Manager::SELECT,
                'options'     => $contact_forms,
                'label_block' => true,
                'separator'   => 'before'
            ]
        );
        $widget->end_controls_section();
        // Source Section End
        // single_image Section Start
        $widget->start_controls_section(
            'section_single_image',
            [
                'label' => esc_html__('Banner Image', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['4']
                ]
            ]
        );
            $widget->add_control(
                'banner',
                [
                    'label'   => esc_html__( 'Banner', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ]
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'banner',
                    'label'   => esc_html__('Image Size','fortis'),
                    'default' => 'custom',
                    'condition' => [
                        'banner[url]!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'banner_gradient',
                [
                    'label'        => esc_html__( 'Gradient Style', 'fortis' ),
                    'type'         => \Elementor\Controls_Manager::SELECT,
                    'options'      => array(
                        'none' => esc_html__( 'None', 'fortis' ),
                        ''     => esc_html__( 'Default', 'fortis' ),
                        '1'    => esc_html__( 'Primary - Top to Bottom', 'fortis' ),
                        '2'    => esc_html__( 'Secondary - Top to Bottom', 'fortis' ),
                        '3'    => esc_html__( 'Primary - Bottom to Top', 'fortis' ),
                        '4'    => esc_html__( 'Secondary - Bottom to Top', 'fortis' ),
                        '5'    => esc_html__( 'Secondary - Bottom to Top #2', 'fortis' ),
                        '6'    => esc_html__( 'Primary - Bottom to Top #2', 'fortis' ),
                        '7'    => esc_html__( 'Gray - Bottom to Top', 'fortis' ),
                        '8'    => esc_html__( 'Secondary - Bottom to Top #3', 'fortis' ),
                        '9'    => esc_html__( 'Secondary - Bottom to Top #4', 'fortis' ),
                        '10'   => esc_html__( 'Red - Top to Bottom', 'fortis' ),
                    ),
                    'default'   => '',
                    'separator' => 'before',
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                ]
            );
        $widget->end_controls_section(); // single_image Section End
        // Content Tab End
        // Title Section Start
        $widget->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style Settings', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $widget->add_control(
                'title_color',
                [
                    'label'     => esc_html__( 'Title', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-heading' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $widget->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'selector' => '{{WRAPPER}} .cms-heading',
                ]
            );
            $widget->add_control(
                'desc_color',
                [
                    'label'     => esc_html__( 'Description', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-desc' => 'color: {{VALUE}};',
                    ],
                    'separator' => 'before'
                ]
            );
            $widget->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'desc_typography',
                    'selector' => '{{WRAPPER}} .cms-desc',
                ]
            );
        $widget->end_controls_section(); // Title Section End
    }
}
