<?php
use Elementor\Controls_Manager;
use Elementor\Base_Data_Control;

if(!function_exists('fortis_widget_cms_copyright_register_controls')){
	add_action('etc_widget_cms_copyright_register_controls', 'fortis_widget_cms_copyright_register_controls', 10, 1);
	function fortis_widget_cms_copyright_register_controls($widget){
		// Layout Settings
		$widget->start_controls_section(
			'layout_section',
			[
				'label' => esc_html__( 'Copyright', 'fortis' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
			]
		);
			$widget->add_control(
				'layout',
	            [
	            	'label'   => esc_html__( 'Templates', 'fortis' ),
		            'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
		            'default' => '1',
		            'options' => [
		                '1' => [
		                    'label' => esc_html__( 'Layout 1', 'fortis' ),
		                    'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_copyright/layout/1.jpg'
		                ]
		            ],
		            'style_transfer' => true,
		            'prefix_class' => 'cms-ecopyright cms-ecopyright-1'
		        ]
			);
		$widget->end_controls_section();
		// Content Settings
		$widget->start_controls_section(
			'setting_section',
            [
            	'label'    => esc_html__('Settings', 'fortis'),
            	'tab'      => \Elementor\Controls_Manager::TAB_CONTENT
            ]
		);
		$widget->add_control(
			'copyright_text',
			[
				'label'       => esc_html__('Copyright Text', 'fortis'),
				'type'        => \Elementor\Controls_Manager::WYSIWYG,
				'description' => esc_html__('Use [[year]] variable to insert current year.', 'fortis'),
				'label_block' => true,
				'default' => '&copy;[[year]] Theme, All Rights Reserved. With Love by <a href="https://cmssuperheroes.com/" target="_blank" rel="nofollow">CMSSuperHeroes</a>',
			]
		);
		$widget->add_control(
            'link_color',
            [
                'label'     => esc_html__( 'Link Color', 'fortis' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}.cms-ecopyright a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_control(
            'link_color_hover',
            [
                'label'     => esc_html__( 'Link Color Hover & Active', 'fortis' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}.cms-ecopyright a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_responsive_control(
            'align',
            [
                'label'        => esc_html__( 'Alignment', 'fortis' ),
                'type'         => Controls_Manager::CHOOSE,
                'responsive'   => true,
                'options'      => [
                    'start'    => [
                        'title' => esc_html__( 'Left', 'fortis' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center'  => [
                        'title' => esc_html__( 'Center', 'fortis' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'end'   => [
                        'title' => esc_html__( 'Right', 'fortis' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'fortis' ),
                        'icon' => 'eicon-text-align-justify',
                    ]
                ],
                'prefix_class' => 'text%s-'
            ]
        );
		$widget->end_controls_section();
	}
}
?>