<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Repeater;

if (!function_exists('fortis_widget_cms_counter_register_controls')) {
    add_action('etc_widget_cms_counter_register_controls', 'fortis_widget_cms_counter_register_controls', 10, 1);
    function fortis_widget_cms_counter_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout_mode',
                [
                    'label'   => esc_html__('Layout Mode', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'grid'     => esc_html__('Grid', 'fortis'),
                        'carousel' => esc_html__('Carousel', 'fortis')
                    ],
                    'default'      => 'grid',
                    'prefix_class' => 'cms-counter-',
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true
                ]
            );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_counter/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_counter/layout/2.jpg'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_counter/layout/3.jpg'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_counter/layout/4.jpg'
                        ],
                        '5' => [
                            'label' => esc_html__( 'Layout 5', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_counter/layout/5.jpg'
                        ],
                        '6' => [
                            'label' => esc_html__( 'Layout 6', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_counter/layout/6.jpg'
                        ],
                        '7' => [
                            'label' => esc_html__( 'Layout 7', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_counter/layout/7.jpg'
                        ],
                        '8' => [
                            'label' => esc_html__( 'Layout 8', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_counter/layout/8.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class'   => 'cms-counter cms-counter-'
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start
        // Reapeater Counter
        $widget->start_controls_section(
            'section_counters',
            [
                'label' => esc_html__('Counters Settings', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );
            $repeater = new Repeater();

            $repeater->add_control(
                'starting_number',
                [
                    'label'   => esc_html__( 'Starting Number', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::NUMBER,
                    'default' => 1,
                ]
            );
            $repeater->add_control(
                'ending_number',
                [
                    'label'   => esc_html__( 'Ending Number', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::NUMBER,
                    'default' => 100,
                ]
            );
            $repeater->add_control(
                'prefix',
                [
                    'label'       => esc_html__( 'Number Prefix', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'default'     => '',
                    'placeholder' => '1',
                ]
            );
            $repeater->add_control(
                'suffix',
                [
                    'label'       => esc_html__( 'Number Suffix', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'default'     => '',
                    'placeholder' => '+',
                ]
            );
            $repeater->add_control(
                'duration',
                [
                    'label'   => esc_html__( 'Animation Duration', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::NUMBER,
                    'default' => 2000,
                    'min'     => 100,
                    'step'    => 100,
                ]
            );
            $repeater->add_control(
                'thousand_separator_char',
                [
                    'label'     => esc_html__( 'Separator', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'condition' => [
                        'thousand_separator' => 'yes',
                    ],
                    'options'   => [
                        ''  => 'Default',
                        '.' => 'Dot',
                        ' ' => 'Space',
                    ],
                    'default'   => '',
                ]
            );
            $repeater->add_control(
                'show_icon',
                [
                    'label'       => esc_html__( 'Show Icon', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::SWITCHER,
                    'default'     => 'yes',
                    'label_block' => true
                ]
            );
            $repeater->add_control(
                'icon_type',
                [
                    'label'     => esc_html__( 'Icon Type', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
                        'icon'  => esc_html__( 'Icon', 'fortis' ),
                        'image' => esc_html__( 'Image', 'fortis' ),
                    ],
                    'default'   => 'icon',
                    'condition' => [
                        'show_icon' => 'yes'
                    ]
                ]
            );
            $repeater->add_control(
                'counter_icon',
                [
                    'label'            => esc_html__( 'Icon', 'fortis' ),
                    'type'             => \Elementor\Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'default'          => [
                        'library' => 'cmsi-fortis',
                        'value'   => 'fortis-icon-default'       
                    ],
                    'condition'        => [
                        'show_icon' => 'yes',
                        'icon_type' => 'icon'
                    ],
                    'skin'        => 'inline',
                    'label_block' => false
                ]
            );
            $repeater->add_control(
                'icon_image',
                [
                    'label'     => esc_html__( 'Icon Image', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::MEDIA,
                    'default'   => [
                        'url' => Utils::get_placeholder_image_src()
                    ],
                    'condition' => [
                        'show_icon' => 'yes',
                        'icon_type' => 'image'
                    ],
                    'label_block' => false,
                    'skin'        => 'inline'
                ]
            );
            $repeater->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'default'     => 'Counter',
                    'placeholder' => esc_html__( 'Enter your Title', 'fortis' ),
                ]
            );
            $repeater->add_control(
                'description',
                [
                    'label'       => esc_html__( 'Description', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'default'     => 'Turpis massa tincidunt dui ut. Sit amet nisl purus in mollis nunc. Id neque aliquam vestibulum morbi blandit cursus risus',
                    'placeholder' => esc_html__( 'Enter your text', 'fortis' ),
                ]
            );
            // add counter item
            $widget->add_control(
                'counters',
                [
                    'label'  => esc_html__('Counters List', 'fortis'),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'title' => esc_html__('Title', 'fortis'),
                        ]
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $widget->end_controls_section();
        // Banner
        $widget->start_controls_section('banner_section',[
            'label'     => esc_html__('Banner', 'fortis'),
            'tab'       => Controls_Manager::TAB_CONTENT,
            'condition' => [
                'layout' => ['2','3']
            ]
        ]);
            $widget->add_control(
                'banner',
                [
                    'label'   => esc_html__( 'Banner', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ]
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'banner',
                    'label'   => esc_html__('Banner Size','fortis'),
                    'default' => 'custom',
                    'condition' => [
                        'banner[url]!' => ''
                    ]
                ]
            );
        $widget->end_controls_section();

        // Style Section Start
        $widget->start_controls_section(
            'section_number',
            [
                'label' => esc_html__('Number', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
            'number_color',
            [
                'label'     => esc_html__( 'Text Color', 'fortis' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-counter-number' => 'color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'number_typography',
                'selector' => '{{WRAPPER}} .cms-counter-numbers',
            ]
        );
        $widget->end_controls_section(); 
        // Number Section End
        // Icon Section Start
        $widget->start_controls_section('icon_style',[
            'label' =>  esc_html__('Icon', 'fortis'),
            'tab'   => Controls_Manager::TAB_STYLE
        ]);
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'icon_image',
                    'label'   => esc_html__('Image Size','fortis'),
                    'default' => 'custom'
                ]
            );
            $widget->add_control(
                'icon_color',
                [
                    'label'     => esc_html__( 'Icon Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-counter-icon i' => 'color: {{VALUE}};',
                    ]
                ]
            );
        $widget->end_controls_section();
        // Title Section Start
        $widget->start_controls_section(
            'section_title',
            [
                'label' => esc_html__('Title', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $widget->add_control(
                'title_color',
                [
                    'label'     => esc_html__( 'Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-counter-title' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $widget->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'title_typography',
                    'selector' => '{{WRAPPER}} .cms-counter-title',
                ]
            );
        $widget->end_controls_section(); // Title Section End

        // Item Section Start
        $widget->start_controls_section(
            'section_item',
            [
                'label' => esc_html__('Item', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout' => ['4']
                ]
            ]
        );
            $widget->add_control(
                'border_color',
                [
                    'label'     => esc_html__( 'Border Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .counter-item' => 'border-top-color: {{VALUE}};border-bottom-color: {{VALUE}};'
                    ]
                ]
            );
        $widget->end_controls_section(); // Title Section End

        // Content Tab End
        // Start Settings
        $widget->start_controls_section(
            'grid_settings_section',
            [
                'label' => esc_html__('Grid Settings','fortis'),
                'tab'   => Controls_Manager::TAB_SETTINGS,
                'condition' => [
                    'layout_mode' => ['grid']
                ]
            ]
        );
            $widget->add_responsive_control(
                'col',
                [
                    'label'        => esc_html__('Columns', 'fortis'),
                    'type'         => Controls_Manager::SELECT,
                    'default'      => '',
                    'default_args' => [
                        'tablet' => '',
                        'mobile' => ''
                    ],
                    'options' => [
                        '' => esc_html__('Default', 'fortis'),
                        '1' => '1',
                        '2' => '2',
                        '3' => '3',
                        '4' => '4',
                        '6' => '6',
                    ]
                ]
            );
        $widget->end_controls_section();
        // Carousel
        $widget->start_controls_section(
            'carousel_settings_section',
            [
                'label' => esc_html__('Carousel Settings','fortis'),
                'tab'   => Controls_Manager::TAB_SETTINGS,
                'condition' => [
                    'layout_mode' => ['carousel']
                ]
            ]
        );
            $slides_to_show = range(1, 10);
            $slides_to_show = array_combine($slides_to_show, $slides_to_show);
            $widget->add_responsive_control(
                'slides_to_show',
                [
                    'label' => esc_html__('Slides to Show', 'fortis'),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                            '' => esc_html__('Default', 'fortis'),
                        ] + $slides_to_show,
                    'frontend_available' => true,
                ]
            );

            $widget->add_responsive_control(
                'slides_to_scroll',
                [
                    'label' => esc_html__('Slides to Scroll', 'fortis'),
                    'type' => Controls_Manager::SELECT,
                    'description' => esc_html__('Set how many slides are scrolled per swipe.', 'fortis'),
                    'options' => [
                            '' => esc_html__('Default', 'fortis'),
                        ] + $slides_to_show,
                    'condition' => [
                        'slides_to_show!' => '1',
                    ],
                    'frontend_available' => true,
                ]
            );

            $widget->add_responsive_control(
                'space_between',
                [
                    'label' => esc_html__('Space Between', 'fortis'),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 40,
                    ],
                    'condition' => [
                        'slides_to_show!' => '1',
                    ],
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'arrows',
                [
                    'label' => esc_html__('Show Arrows', 'fortis'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'dots',
                [
                    'label' => esc_html__('Show Dots', 'fortis'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'arrow_prev_icon',
                [
                    'label'            => esc_html__('Previous Arrow Icon', 'fortis'),
                    'type'             => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'skin'             => 'inline',
                    'label_block'      => false,
                    'skin_settings'    => [
                        'inline' => [
                            'none' => [
                                'label' => 'Default',
                                'icon' => 'eicon-chevron-left',
                            ],
                            'icon' => [
                                'icon' => 'eicon-star',
                            ],
                        ],
                    ],
                    'condition' => [
                        'arrows' => 'yes'
                    ],
                ]
            );

            $widget->add_control(
                'arrow_next_icon',
                [
                    'label'            => esc_html__('Next Arrow Icon', 'fortis'),
                    'type'             => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'skin'             => 'inline',
                    'label_block'      => false,
                    'skin_settings'    => [
                        'inline' => [
                            'none' => [
                                'label' => 'Default',
                                'icon' => 'eicon-chevron-right',
                            ],
                            'icon' => [
                                'icon' => 'eicon-star',
                            ],
                        ],
                    ],
                    'condition' => [
                        'arrows' => 'yes'
                    ],
                ]
            );

            $widget->add_control(
                'lazyload',
                [
                    'label' => esc_html__('Lazyload', 'fortis'),
                    'type' => Controls_Manager::SWITCHER,
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'autoplay',
                [
                    'label' => esc_html__('Autoplay', 'fortis'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'pause_on_hover',
                [
                    'label' => esc_html__('Pause on Hover', 'fortis'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                    'condition' => [
                        'autoplay' => 'yes',
                    ],
                ]
            );

            $widget->add_control(
                'pause_on_interaction',
                [
                    'label' => esc_html__('Pause on Interaction', 'fortis'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                    'condition' => [
                        'autoplay' => 'yes',
                    ],
                ]
            );

            $widget->add_control(
                'autoplay_speed',
                [
                    'label' => esc_html__('Autoplay Speed', 'fortis'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 5000,
                    'condition' => [
                        'autoplay' => 'yes',
                    ],
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'infinite',
                [
                    'label' => esc_html__('Infinite Loop', 'fortis'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'effect',
                [
                    'label' => esc_html__('Effect', 'fortis'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'slide',
                    'options' => [
                        'slide' => esc_html__('Slide', 'fortis'),
                        'fade' => esc_html__('Fade', 'fortis'),
                    ],
                    'condition' => [
                        'slides_to_show' => '1',
                    ],
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'speed',
                [
                    'label' => esc_html__('Animation Speed', 'fortis'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 500,
                    'render_type' => 'none',
                    'frontend_available' => true,
                ]
            );
        $widget->end_controls_section();
    }
}
