<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Repeater;

if (!function_exists('fortis_widget_cms_counter_sticky_register_controls')) {
    add_action('etc_widget_cms_counter_sticky_register_controls', 'fortis_widget_cms_counter_sticky_register_controls', 10, 1);
    function fortis_widget_cms_counter_sticky_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_counter_sticky/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_counter_sticky/layout/2.jpg'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_counter_sticky/layout/3.jpg'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_counter_sticky/layout/4.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class'   => 'cms-counter-sticky cms-counter-sticky-'
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start
        // Reapeater Counter
        $widget->start_controls_section(
            'section_counters',
            [
                'label' => esc_html__('Counters Settings', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );
            $repeater = new Repeater();

            $repeater->add_control(
                'starting_number',
                [
                    'label'   => esc_html__( 'Starting Number', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::NUMBER,
                    'default' => 1,
                ]
            );
            $repeater->add_control(
                'ending_number',
                [
                    'label'   => esc_html__( 'Ending Number', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::NUMBER,
                    'default' => 100,
                ]
            );
            $repeater->add_control(
                'prefix',
                [
                    'label'       => esc_html__( 'Number Prefix', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'default'     => '',
                    'placeholder' => '1',
                ]
            );
            $repeater->add_control(
                'suffix',
                [
                    'label'       => esc_html__( 'Number Suffix', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'default'     => '',
                    'placeholder' => '+',
                ]
            );
            $repeater->add_control(
                'duration',
                [
                    'label'   => esc_html__( 'Animation Duration', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::NUMBER,
                    'default' => 2000,
                    'min'     => 100,
                    'step'    => 100,
                ]
            );
            $repeater->add_control(
                'thousand_separator_char',
                [
                    'label'     => esc_html__( 'Separator', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'condition' => [
                        'thousand_separator' => 'yes',
                    ],
                    'options'   => [
                        ''  => 'Default',
                        '.' => 'Dot',
                        ' ' => 'Space',
                    ],
                    'default'   => '',
                ]
            );
            $repeater->add_control(
                'banner',
                [
                    'label'     => esc_html__( 'Banner', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::MEDIA,
                    'default'   => [
                        'url' => Utils::get_placeholder_image_src()
                    ],
                    'label_block' => false
                ]
            );
            $repeater->add_control(
                'show_icon',
                [
                    'label'       => esc_html__( 'Show Icon', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::SWITCHER,
                    'default'     => 'yes',
                    'label_block' => true
                ]
            );
            $repeater->add_control(
                'icon_type',
                [
                    'label'     => esc_html__( 'Icon Type', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
                        'icon'  => esc_html__( 'Icon', 'fortis' ),
                        'image' => esc_html__( 'Image', 'fortis' ),
                    ],
                    'default'   => 'icon',
                    'condition' => [
                        'show_icon' => 'yes'
                    ]
                ]
            );
            $repeater->add_control(
                'counter_icon',
                [
                    'label'            => esc_html__( 'Icon', 'fortis' ),
                    'type'             => \Elementor\Controls_Manager::ICONS,
                    'default'          => [
                        'library' => 'cmsi-fortis',
                        'value'   => 'fortis-icon-default'       
                    ],
                    'condition'        => [
                        'show_icon' => 'yes',
                        'icon_type' => 'icon'
                    ],
                    'skin'        => 'inline',
                    'label_block' => false
                ]
            );
            $repeater->add_control(
                'icon_image',
                [
                    'label'     => esc_html__( 'Icon Image', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::MEDIA,
                    'default'   => [
                        'url' => Utils::get_placeholder_image_src()
                    ],
                    'condition' => [
                        'show_icon' => 'yes',
                        'icon_type' => 'image'
                    ],
                    'label_block' => false,
                    'skin'        => 'inline'
                ]
            );
            $repeater->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'default'     => 'Your title',
                    'placeholder' => esc_html__( 'Enter your Title', 'fortis' ),
                ]
            );
            $repeater->add_control(
                'description',
                [
                    'label'       => esc_html__( 'Description', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'default'     => 'Turpis massa tincidunt dui ut. Sit amet nisl purus in mollis nunc. Id neque aliquam vestibulum morbi blandit cursus risus',
                    'placeholder' => esc_html__( 'Enter your text', 'fortis' ),
                ]
            );
            // add counter item
            $widget->add_control(
                'counters',
                [
                    'label'  => esc_html__('Counters List', 'fortis'),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'ending_number' => 2318,
                            'counter_icon' => [
                                'library' => 'fortis-icon',
                                'value'   => 'fortis-icon-gear3'
                            ],
                            'title'       => 'Qualified Employees & Workers With Us',
                            'description' => 'Building The Future, Restoring The Past'
                        ],
                        [
                            'ending_number' => 6154,
                            'counter_icon' => [
                                'library' => 'fortis-icon',
                                'value'   => 'fortis-icon-factory'
                            ],
                            'title'       => 'Projects & Factories Finished in 2024',
                            'description' => '#2 Building The Future, Restoring The Past'
                        ],
                        [
                            'ending_number' => 9784,
                            'counter_icon' => [
                                'library' => 'fortis-icon',
                                'value'   => 'fortis-icon-worker'
                            ],
                            'title'       => 'Satisfied Clients We Served Globally',
                            'description' => '#3 Building The Future, Restoring The Past'
                        ],
                        [
                            'ending_number' => 0.63,
                            'counter_icon' => [
                                'library' => 'fortis-icon',
                                'value'   => 'fortis-icon-presentation'
                            ],
                            'title'       => 'Years Of Experience In The Industry',
                            'description' => '#4 Building The Future, Restoring The Past'
                        ]
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $widget->end_controls_section();
        // Banner style
        $widget->start_controls_section(
            'section_banner',
            [
                'label' => esc_html__('Banner', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'banner',
                    'label'   => esc_html__('Banner Size','fortis'),
                    'default' => 'custom'
                ]
            );
        $widget->end_controls_section(); 
        // Style Section Start
        $widget->start_controls_section(
            'section_number',
            [
                'label' => esc_html__('Number', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $widget->add_control(
                'number_color',
                [
                    'label'     => esc_html__( 'Text Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-counter-numbers' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $widget->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name'     => 'number_typography',
                    'selector' => '{{WRAPPER}} .cms-counter-numbers',
                ]
            );
        $widget->end_controls_section(); 
        // Number Section End
        // Icon Section Start
        $widget->start_controls_section('icon_style',[
            'label' =>  esc_html__('Icon', 'fortis'),
            'tab'   => Controls_Manager::TAB_STYLE
        ]);
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'icon_image',
                    'label'   => esc_html__('Image Size','fortis'),
                    'default' => 'custom'
                ]
            );
            $widget->add_control(
                'icon_color',
                [
                    'label'     => esc_html__( 'Icon Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-counter-icon i' => 'color: {{VALUE}};',
                    ]
                ]
            );
        $widget->end_controls_section();
        // Title Section Start
        $widget->start_controls_section(
            'section_title',
            [
                'label' => esc_html__('Title', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
            'title_color',
            [
                'label'     => esc_html__( 'Color', 'fortis' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-counter-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .cms-counter-title',
            ]
        );
        $widget->end_controls_section(); // Title Section End
        // Item Section Start
        $widget->start_controls_section(
            'section_item',
            [
                'label' => esc_html__('Item', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $widget->add_control(
                'border_color',
                [
                    'label'     => esc_html__( 'Border Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .counter-item' => 'border-bottom-color: {{VALUE}};',
                        '{{WRAPPER}} .counter-item.active' => 'border-top-color: {{VALUE}};',
                        '{{WRAPPER}} .counter-item:hover' => 'border-top-color: {{VALUE}};'
                    ]
                ]
            );
        $widget->end_controls_section(); // Title Section End
    }
}
