<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;

if (!function_exists('fortis_widget_cms_cta_register_controls')) {
    add_action('etc_widget_cms_cta_register_controls', 'fortis_widget_cms_cta_register_controls', 10, 1);
    function fortis_widget_cms_cta_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/2.jpg'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/3.jpg'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/4.jpg'
                        ],
                        '5' => [
                            'label' => esc_html__( 'Layout 5', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/5.jpg'
                        ],
                        '6' => [
                            'label' => esc_html__( 'Layout 6', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/6.jpg'
                        ],
                        '7' => [
                            'label' => esc_html__( 'Layout 7', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/7.jpg'
                        ],
                        '8' => [
                            'label' => esc_html__( 'Layout 8', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/8.jpg'
                        ],
                        '9' => [
                            'label' => esc_html__( 'Layout 9', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/9.jpg'
                        ],
                        '10' => [
                            'label' => esc_html__( 'Layout 10', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/10.jpg'
                        ],
                        '11' => [
                            'label' => esc_html__( 'Layout 11', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/11.jpg'
                        ],
                        '12' => [
                            'label' => esc_html__( 'Layout 12', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/12.jpg'
                        ]
                    ],
                    'style_transfer' => true,
                    'dynamic' => [
                        'active' => true
                    ],
                    'prefix_class' => 'cms-ecta cms-ecta-'
                ]
            );
        $widget->end_controls_section();
        // Content Section Start
        $widget->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );  
            $widget->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'fortis' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'We Have Official Expert Level Of Knowledge And Certification Equipments.',
                    'placeholder' => esc_html__( 'Enter your title', 'fortis' ),
                    'condition'   => [
                        'layout'  => ['4','8','9','10','11','12']
                    ]
                ]
            );      
            $widget->add_control(
                'text',
                [
                    'label'       => esc_html__( 'Content', 'fortis' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'We have established corporate mandate to maintain strong core values that truly reflect the philosophy.',
                    'placeholder' => esc_html__( 'Enter your text', 'fortis' )
                ]
            ); 
            $widget->add_control(
                'link_text',
                [
                    'label'       => esc_html__( 'Link Settings', 'fortis' ),
                    'description' => esc_html__('Link Text', 'fortis'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => esc_html__( 'Click here', 'fortis' ),
                    'placeholder' => esc_html__( 'Click here', 'fortis' ),
                    'label_block' => true
                ]
            );
            $widget->add_control(
                'link_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'link_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'page_link',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'link_text!' => '',
                        'link_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'custom_link',
                [
                    'label'       => esc_html__( 'Link', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'link_text!' => '',
                        'link_type' => 'custom'
                    ]
                ]
            );
            $widget->add_control(
                'link2_text',
                [
                    'label'       => esc_html__( 'Link #2 Settings', 'fortis' ),
                    'description' => esc_html__('Link Text', 'fortis'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Check All Services', 'fortis' ),
                    'separator' => 'before',
                    'condition' => [
                        'layout' => ['5']
                    ]
                ]
            );
            $widget->add_control(
                'link2_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'layout' => ['5'],
                        'link2_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'link2_page',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'layout' => ['5'],
                        'link2_text!' => '',
                        'link2_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'link2_custom',
                [
                    'label'       => esc_html__( 'Link Custom', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'layout' => ['5'],
                        'link2_text!' => '',
                        'link2_type' => 'custom'
                    ]
                ]
            );
        $widget->end_controls_section();
        // Style
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style Settings','fortis'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
            $widget->add_responsive_control(
                'align',
                [
                    'label'        => esc_html__( 'Alignment', 'fortis' ),
                    'type'         => Controls_Manager::CHOOSE,
                    'responsive'   => true,
                    'options'      => [
                        'start'    => [
                            'title' => esc_html__( 'Left', 'fortis' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center'  => [
                            'title' => esc_html__( 'Center', 'fortis' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'end'   => [
                            'title' => esc_html__( 'Right', 'fortis' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__( 'Justified', 'fortis' ),
                            'icon' => 'eicon-text-align-justify',
                        ]
                    ],
                    'prefix_class' => 'text%s-'
                ]
            );
            $widget->add_control(
                'link_color',
                [
                    'label'     => esc_html__( 'Link Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-heading, {{WRAPPER}} a:not(.btn)' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'layout' => ['1','2','3','4']
                    ]
                ]
            );
            $widget->add_control(
                'link_color_hover',
                [
                    'label'     => esc_html__( 'Link Color Hover', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-heading, {{WRAPPER}} a:not(.btn):hover' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'layout' => ['1','2','3','4']
                    ]
                ]
            );
            $widget->add_control(
                'content_container',
                [
                    'label' =>  esc_html__('Content Container','fortis'),
                    'type'  =>  Controls_Manager::SELECT,
                    'options' => [
                        ''  => esc_html__('Default','fortis'),
                        'container' => esc_html__('Container Grid','fortis')
                    ],
                    'condition' => [
                        'layout' => ['3']
                    ]
                ]
            );
            $widget->add_control(
                'content_width',
                [
                    'label' =>  esc_html__('Content Width','fortis'),
                    'type'  =>  Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 200,
                            'max' => 1600,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .cms-cta' => 'max-width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'layout'            => ['3'],
                        'content_container' => 'container'
                    ]
                ]
            );
            $widget->add_control(
                'banner',
                [
                    'label'   => esc_html__( 'Banner', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ],
                    'separator' => 'before',
                    'condition' => [
                        'layout' => ['4','12']
                    ]
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'      => 'banner',
                    'label'     => esc_html__('Banner Size','fortis'),
                    'default'   => 'custom',
                    'condition' => [
                        'layout'       => ['4','12'],
                        'banner[url]!' => ''
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
