<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;

if (!function_exists('fortis_widget_cms_fancy_box_register_controls')) {
    add_action('etc_widget_cms_fancy_box_register_controls', 'fortis_widget_cms_fancy_box_register_controls', 10, 1);
    function fortis_widget_cms_fancy_box_register_controls($widget)
    {
        // Layout Tab Start

        // Layout Section Start
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
        $widget->add_control(
            'layout',
            [
                'label'   => esc_html__('Templates', 'fortis'),
                'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                'default' => '1',
                'options' => [
                    '1' => [
                        'label' => esc_html__('Layout 1', 'fortis'),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_fancy_box/layout/1.jpg'
                    ],
                    '2' => [
                        'label' => esc_html__('Layout 2', 'fortis'),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_fancy_box/layout/2.jpg'
                    ],
                    '3' => [
                        'label' => esc_html__('Layout 3', 'fortis'),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_fancy_box/layout/3.jpg'
                    ],
                    '4' => [
                        'label' => esc_html__('Layout 4', 'fortis'),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_fancy_box/layout/4.jpg'
                    ],
                ],
                'dynamic' => [
                    'active' => true
                ],
                'style_transfer' => true,
                'prefix_class' => 'cms-anim-icon cms-fancy-'
            ]
        );
        $widget->end_controls_section();
        // Layout Section End

        // Layout Tab End

        // Content Tab Start

        // Icon Section Start
        $widget->start_controls_section(
            'fancy_box_section',
            [
                'label' => esc_html__('Fancy Box', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'icon_type',
            [
                'label'   => esc_html__('Icon Type', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'icon'  => esc_html__('Icon','fortis'),
                    'image' => esc_html__('Image','fortis'),
                    ''      => esc_html__('None','fortis'),
                ],
                'default' => 'icon',
                'condition' => [
                    'layout' => ['1','3']
                ]
            ]
        );
        $widget->add_control(
            'selected_icon',
            [
                'label'     => esc_html__('Icon', 'fortis'),
                'type'      => Controls_Manager::ICONS,
                'condition' => [
                    'layout' => ['1','3'],
                    'icon_type' => 'icon'
                ],
                'default' => [
                    'library' => 'cmsi',
                    'value'   => 'cmsi-star'  
                ]
            ]
        );
        $widget->add_control(
            'icon_image',
            [
                'label'       => esc_html__('Icon Image', 'fortis'),
                'type'        => Controls_Manager::MEDIA,
                'description' => esc_html__('Select image icon.', 'fortis'),
                'condition'   => [
                    'layout' => ['1','3'],
                    'icon_type' => 'image',
                ]
            ]
        );
        $widget->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'    => 'icon_image',
                'label'   => esc_html__('Image Size','fortis'),
                'default' => 'custom',
                'condition' => [
                    'layout'           => ['1','3'],
                    'icon_type'        => 'image',
                    'icon_image[url]!' => ''
                ]
            ]
        );
        $widget->add_control(
            'title',
            [
                'label'       => esc_html__('Title', 'fortis'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => esc_html__('This is the heading', 'fortis'),
                'placeholder' => esc_html__('Enter your title', 'fortis'),
                'label_block' => true,
                'condition'   => [
                    'layout' => ['1','2','4']
                ] 
            ]
        );
        $widget->add_control(
            'description',
            [
                'label'       => esc_html__('Description', 'fortis'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => esc_html__('Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'fortis'),
                'placeholder' => esc_html__('Enter your description', 'fortis'),
                'rows'        => 10,
                'show_label'  => true,
                'condition'   => [
                    'layout' => ['1','2','3','4']
                ] 
            ]
        );
        $widget->add_control(
            'btn_text',
            [
                'label'       => esc_html__('Button', 'fortis'),
                'description' => esc_html__('Button Text','fortis'),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true
            ]
        );
        $widget->add_control(
            'btn_link_type',
            [
                'label'   => esc_html__('Button Link Type', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'custom' => esc_html__('Custom', 'fortis'),
                    'page'   => esc_html__('Page', 'fortis'),
                ],
                'default' => 'custom',
                'condition' => [
                    'btn_text!' => ''
                ]
            ]
        );
        $widget->add_control(
            'btn_page_link',
            [
                'label'     => esc_html__('Select Page', 'fortis'),
                'type'      => Elementor_Theme_Core::POSTS_CONTROL,
                'post_type' => [
                    'page',
                    'post',
                ],
                'multiple'  => false,
                'condition' => [
                    'btn_text!'     => '',
                    'btn_link_type' => 'page'
                ],
            ]
        );
        $widget->add_control(
            'btn_link',
            [
                'label'     => esc_html__('Button Link', 'fortis'),
                'type'      => Controls_Manager::URL,
                'condition' => [
                    'btn_text!'     => '',
                    'btn_link_type' => 'custom'
                ],
            ]
        );
        $widget->end_controls_section();
        // Icon Section End

        // Style Section Start
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
            'icon_color',
            [
                'label'   => esc_html__('Icon Color', 'fortis'),
                'type'    => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-icon' => 'color: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );
        $widget->add_control(
            'title_color',
            [
                'label'   => esc_html__('Title Color', 'fortis'),
                'type'    => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-title' => 'color: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'   => esc_html__('Title Typography', 'fortis'),
                'name' => 'title_typography',
                'selector'     => '{{WRAPPER}} .cms-title',
            ]
        );
        $widget->add_control(
            'description_color',
            [
                'label'   => esc_html__('Description Color', 'fortis'),
                'type'    => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-desc' => 'color: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'   => esc_html__('Description Typography', 'fortis'),
                'name' => 'description_typography',
                'selector'     => '{{WRAPPER}} .cms-desc',
            ]
        );
        $widget->add_control(
            'btn_color',
            [
                'label'   => esc_html__('Button Text Color', 'fortis'),
                'type'    => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-fancy-btn' => 'color: {{VALUE}};border-color: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );
        $widget->end_controls_section();
        // Style Section End

        // Content Tab End

    }
}
