<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
if (!function_exists('fortis_widget_cms_find_location_register_controls')) {
    add_action('etc_widget_cms_find_location_register_controls', 'fortis_widget_cms_find_location_register_controls', 10, 1);
    function fortis_widget_cms_find_location_register_controls($widget)
    {
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__('Templates', 'fortis'),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__('Layout 1', 'fortis'),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_find_location/layout/1.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-find-location-'
                ]
            );
        $widget->end_controls_section();
        $widget->start_controls_section(
            'africa',
            [
                'label'    => esc_html__( 'Location #1', 'fortis' ),
                'tab'      => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'africa_title',
                [
                    'label'       => esc_html__( 'Title', 'fortis' ),
                    'default'     => esc_html__( 'Africa', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => false,
                ]
            );
            $repeater_list = new Repeater();
            $repeater_list->add_control(
                'location_title',
                [
                    'label'       => esc_html__( 'Location Title', 'fortis' ),
                    'default'     => '',
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => false,
                ]
            );
            $repeater_list->add_control(
                'location_url',
                [
                    'label'       => esc_html__( 'Location URL', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'label_block' => false,
                    'default'     => [
                        'url' => '#',
                        'is_external' => true
                    ]  
                ]
            );

            $widget->add_control(
                'africa_1',
                [
                    'label'       => esc_html__('Part 1', 'fortis'),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater_list->get_controls(),
                    'title_field' => '{{{ location_title }}}',
                    'label_block' => true,  
                    'default'     => [
                        [
                            'location_title' => 'Alexandria',
                            'location_url'   => 'https://www.google.com/maps/place/Alexandria'
                        ],
                        [
                            'location_title' => 'Cairo (Airport Office)',
                            'location_url'   => 'https://www.google.com/maps/place/Cairo (Airport Office)'
                        ],
                        [
                            'location_title' => 'Casablanca',
                            'location_url'   => 'https://www.google.com/maps/place/Casablanca'
                        ],
                        [
                            'location_title' => 'Port Said',
                            'location_url'   => 'https://www.google.com/maps/place/Port+Said'
                        ],
                        [
                            'location_title' => 'Nairobi',
                            'location_url'   => 'https://www.google.com/maps/place/Nairobi'
                        ]
                    ]
                ]
            );
            $widget->add_control(
                'africa_2',
                [
                    'label'       => esc_html__('Part 2', 'fortis'),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater_list->get_controls(),
                    'title_field' => '{{{ location_title }}}',
                    'label_block' => true,  
                    'default'     => [
                        [
                            'location_title' => 'Tanger',
                            'location_url'   => 'https://www.google.com/maps/place/Tanger'
                        ],
                        [
                            'location_title' => 'Antananarivo',
                            'location_url'   => 'https://www.google.com/maps/place/Antananarivo'
                        ],
                        [
                            'location_title' => 'Mauritius Airport Office',
                            'location_url'   => 'https://www.google.com/maps/place/Mauritius Airport Office'
                        ],
                        [
                            'location_title' => 'Port Louis',
                            'location_url'   => 'https://www.google.com/maps/place/Port Louis'
                        ],
                        [
                            'location_title' => 'Ghana',
                            'location_url'   => 'https://www.google.com/maps/place/Ghana'
                        ],
                    ]  
                ]
            );
            $widget->add_control(
                'africa_3',
                [
                    'label'       => esc_html__('Part 3', 'fortis'),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater_list->get_controls(),
                    'title_field' => '{{{ location_title }}}',
                    'label_block' => true,  
                    'default'     => [
                        [
                            'location_title' => 'East Africa',
                            'location_url'   => 'https://www.google.com/maps/place/East Africa'
                        ],
                        [
                            'location_title' => 'Matshapa',
                            'location_url'   => 'https://www.google.com/maps/place/Matshapa'
                        ],
                        [
                            'location_title' => 'Port Harcourt',
                            'location_url'   => 'https://www.google.com/maps/place/Port Harcourt'
                        ],
                        [
                            'location_title' => 'Mahe',
                            'location_url'   => 'https://www.google.com/maps/place/Mahe'
                        ],
                        [
                            'location_title' => 'Manica Malawi',
                            'location_url'   => 'https://www.google.com/maps/place/Manica Malawi'
                        ],
                    ]
                ]
            );
            $widget->add_control(
                'africa_4',
                [
                    'label'       => esc_html__('Part 4', 'fortis'),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater_list->get_controls(),
                    'title_field' => '{{{ location_title }}}',
                    'label_block' => true,  
                    'default'     => [
                        [
                            'location_title' => 'Togo',
                            'location_url'   => 'https://www.google.com/maps/place/Togo'
                        ],
                        [
                            'location_title' => 'Angola',
                            'location_url'   => 'https://www.google.com/maps/place/Angola'
                        ],
                        [
                            'location_title' => 'Luanda',
                            'location_url'   => 'https://www.google.com/maps/place/Luanda'
                        ],
                        [
                            'location_title' => 'Tanzania',
                            'location_url'   => 'https://www.google.com/maps/place/Tanzania'
                        ],
                    ]
                ]
            );
        $widget->end_controls_section();
        $widget->start_controls_section(
            'asia',
            [
                'label'    => esc_html__( 'Location #2', 'fortis' ),
                'tab'      => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'asia_title',
                [
                    'label'       => esc_html__( 'Title', 'fortis' ),
                    'default'     => esc_html__( 'Asia', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => false,
                ]
            );
            $widget->add_control(
                'asia_1',
                [
                    'label'       => esc_html__('Part 1', 'fortis'),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater_list->get_controls(),
                    'title_field' => '{{{ location_title }}}',
                    'label_block' => true,  
                    'default'     => [
                        [
                            'location_title' => 'Ahmedabad',
                            'location_url'   => 'https://www.google.com/maps/place/Ahmedabad'
                        ],
                        [
                            'location_title' => 'Bangalore',
                            'location_url'   => 'https://www.google.com/maps/place/Bangalore'
                        ],
                        [
                            'location_title' => 'Bangkok',
                            'location_url'   => 'https://www.google.com/maps/place/Bangkok'
                        ],
                        [
                            'location_title' => 'Baroda',
                            'location_url'   => 'https://www.google.com/maps/place/Baroda'
                        ],
                        [
                            'location_title' => 'Beijing',
                            'location_url'   => 'https://www.google.com/maps/place/Beijing'
                        ]
                    ]
                ]
            );
            $widget->add_control(
                'asia_2',
                [
                    'label'       => esc_html__('Part 2', 'fortis'),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater_list->get_controls(),
                    'title_field' => '{{{ location_title }}}',
                    'label_block' => true,  
                    'default'     => [
                        [
                            'location_title' => 'Chennai',
                            'location_url'   => 'https://www.google.com/maps/place/Chennai'
                        ],
                        [
                            'location_title' => 'Chongqing',
                            'location_url'   => 'https://www.google.com/maps/place/Chongqing'
                        ],
                        [
                            'location_title' => 'Danang',
                            'location_url'   => 'https://www.google.com/maps/place/Danang'
                        ],
                        [
                            'location_title' => 'Gandhidham',
                            'location_url'   => 'https://www.google.com/maps/place/Gandhidham'
                        ],
                        [
                            'location_title' => 'Ho Chi Minh',
                            'location_url'   => 'https://www.google.com/maps/place/Ho Chi Minh'
                        ],
                    ]  
                ]
            );
            $widget->add_control(
                'asia_3',
                [
                    'label'       => esc_html__('Part 3', 'fortis'),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater_list->get_controls(),
                    'title_field' => '{{{ location_title }}}',
                    'label_block' => true,  
                    'default'     => [
                        [
                            'location_title' => 'Kerteh',
                            'location_url'   => 'https://www.google.com/maps/place/Kerteh'
                        ],
                        [
                            'location_title' => 'Kolkata',
                            'location_url'   => 'https://www.google.com/maps/place/Kolkata'
                        ],
                        [
                            'location_title' => 'Kuala Lumpur',
                            'location_url'   => 'https://www.google.com/maps/place/Kuala Lumpur'
                        ],
                        [
                            'location_title' => 'Kuantan',
                            'location_url'   => 'https://www.google.com/maps/place/Kuantan'
                        ],
                        [
                            'location_title' => 'Medan',
                            'location_url'   => 'https://www.google.com/maps/place/Medan'
                        ],
                    ]
                ]
            );
            $widget->add_control(
                'asia_4',
                [
                    'label'       => esc_html__('Part 4', 'fortis'),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater_list->get_controls(),
                    'title_field' => '{{{ location_title }}}',
                    'label_block' => true,  
                    'default'     => [
                        [
                            'location_title' => 'Port Klang',
                            'location_url'   => 'https://www.google.com/maps/place/Port Klang'
                        ],
                        [
                            'location_title' => 'Qingdao',
                            'location_url'   => 'https://www.google.com/maps/place/Qingdao'
                        ],
                        [
                            'location_title' => 'Raigad Navi Mumbai',
                            'location_url'   => 'https://www.google.com/maps/place/Raigad Navi Mumbai'
                        ],
                        [
                            'location_title' => 'Semarang',
                            'location_url'   => 'https://www.google.com/maps/place/Semarang'
                        ],
                        [
                            'location_title' => 'Seoul',
                            'location_url'   => 'https://www.google.com/maps/place/Seoul'
                        ],
                    ]
                ]
            );
        $widget->end_controls_section();
        $widget->start_controls_section(
            'europe',
            [
                'label'    => esc_html__( 'Location #3', 'fortis' ),
                'tab'      => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'europe_title',
                [
                    'label'       => esc_html__( 'Title', 'fortis' ),
                    'default'     => esc_html__( 'Europe', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => false,
                ]
            );
            $widget->add_control(
                'europe_1',
                [
                    'label'       => esc_html__('Part 1', 'fortis'),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater_list->get_controls(),
                    'title_field' => '{{{ location_title }}}',
                    'label_block' => true,  
                    'default'     => [
                        [
                            'location_title' => 'Amsterdam',
                            'location_url'   => 'https://www.google.com/maps/place/Amsterdam'
                        ],
                        [
                            'location_title' => 'Ankara',
                            'location_url'   => 'https://www.google.com/maps/place/Ankara'
                        ],
                        [
                            'location_title' => 'Antwerp',
                            'location_url'   => 'https://www.google.com/maps/place/Antwerp'
                        ],
                        [
                            'location_title' => 'Barcelona',
                            'location_url'   => 'https://www.google.com/maps/place/Barcelona'
                        ],
                        [
                            'location_title' => 'Brussels',
                            'location_url'   => 'https://www.google.com/maps/place/Brussels'
                        ]
                    ]
                ]
            );
            $widget->add_control(
                'europe_2',
                [
                    'label'       => esc_html__('Part 2', 'fortis'),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater_list->get_controls(),
                    'title_field' => '{{{ location_title }}}',
                    'label_block' => true,  
                    'default'     => [
                        [
                            'location_title' => 'Frankfurt',
                            'location_url'   => 'https://www.google.com/maps/place/Frankfurt'
                        ],
                        [
                            'location_title' => 'Gaziemir',
                            'location_url'   => 'https://www.google.com/maps/place/Gaziemir'
                        ],
                        [
                            'location_title' => 'Hamburg',
                            'location_url'   => 'https://www.google.com/maps/place/Hamburg'
                        ],
                        [
                            'location_title' => 'Istanbul',
                            'location_url'   => 'https://www.google.com/maps/place/Istanbul'
                        ],
                        [
                            'location_title' => 'Izmir',
                            'location_url'   => 'https://www.google.com/maps/place/Izmir'
                        ],
                    ]  
                ]
            );
            $widget->add_control(
                'europe_3',
                [
                    'label'       => esc_html__('Part 3', 'fortis'),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater_list->get_controls(),
                    'title_field' => '{{{ location_title }}}',
                    'label_block' => true,  
                    'default'     => [
                        [
                            'location_title' => 'Madrid',
                            'location_url'   => 'https://www.google.com/maps/place/Madrid'
                        ],
                        [
                            'location_title' => 'Malpensa',
                            'location_url'   => 'https://www.google.com/maps/place/Malpensa'
                        ],
                        [
                            'location_title' => 'Manchester',
                            'location_url'   => 'https://www.google.com/maps/place/Manchester'
                        ],
                        [
                            'location_title' => 'Marseille',
                            'location_url'   => 'https://www.google.com/maps/place/Marseille'
                        ],
                        [
                            'location_title' => 'Mersin',
                            'location_url'   => 'https://www.google.com/maps/place/Mersin'
                        ],
                    ]
                ]
            );
            $widget->add_control(
                'europe_4',
                [
                    'label'       => esc_html__('Part 4', 'fortis'),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater_list->get_controls(),
                    'title_field' => '{{{ location_title }}}',
                    'label_block' => true,  
                    'default'     => [
                        [
                            'location_title' => 'Orey',
                            'location_url'   => 'https://www.google.com/maps/place/Orey'
                        ],
                        [
                            'location_title' => 'Belarus',
                            'location_url'   => 'https://www.google.com/maps/place/Belarus'
                        ],
                        [
                            'location_title' => 'Ukraine',
                            'location_url'   => 'https://www.google.com/maps/place/Ukraine'
                        ],
                        [
                            'location_title' => 'Portland',
                            'location_url'   => 'https://www.google.com/maps/place/Portland'
                        ],
                    ]
                ]
            );
        $widget->end_controls_section();
        // Style
        $widget->start_controls_section('style_section',[
            'label' => esc_html__('Style Settings', 'fortis'),
            'tab'   => Controls_Manager::TAB_STYLE
        ]);
            $widget->add_control(
                'selected_icon',
                [
                    'label'     => __( 'Icon', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::ICONS,
                    'default'   => [
                        'library' => 'cmsi',
                        'value'   => 'cmsi-map-marker'
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}