<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;

if (!function_exists('fortis_widget_cms_gallery_register_controls')) {
    add_action('etc_widget_cms_gallery_register_controls', 'fortis_widget_cms_gallery_register_controls', 10, 1);
    function fortis_widget_cms_gallery_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_gallery/layout/1.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-egallery-'
                ]
            );
        $widget->end_controls_section();
        // Gallery
        $widget->start_controls_section(
            'section_gallery',
            [
                'label' => esc_html__('Gallery Image', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'gallery',
                [
                    'label'   => esc_html__( 'Add Images', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::GALLERY
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'gallery',
                    'label'   => esc_html__('Image Size','fortis'),
                    'default' => 'custom'
                ]
            );
        $widget->end_controls_section();
        // Settings
        $widget->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__('Settings','fortis'),
                'tab'   => Controls_Manager::TAB_SETTINGS
            ]
        );
            $widget->add_control(
                'gallery_col',
                [
                    'label'        => esc_html__('Columns', 'fortis' ),
                    'type'         => \Elementor\Controls_Manager::SELECT,
                    'control_type' => 'responsive',
                    'options'      => [
                        ''     => esc_html__('Default','fortis'), 
                        '1'    => esc_html__('1', 'fortis' ),
                        '2'    => esc_html__('2', 'fortis' ),
                        '3'    => esc_html__('3', 'fortis' ),
                        '4'    => esc_html__('4', 'fortis' ),
                        '6'    => esc_html__('6', 'fortis' ),
                        'auto' => esc_html__('Auto', 'fortis' ),
                    ]
                ]
            );
            $widget->add_control(
                'gallery_rand',
                [
                    'label'   => esc_html__( 'Order By', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        ''     => esc_html__( 'Default', 'fortis' ),
                        'rand' => esc_html__( 'Random', 'fortis' ),
                    ],
                    'default' => '',
                ]
            );
            $widget->add_control(
                'gallery_show',
                [
                    'label'   => esc_html__( 'Number of item to show', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::NUMBER,
                    'default' => ''
                ]
            );
            $widget->add_control(
                'gallery_loadmore_show',
                [
                    'label'   => esc_html__( 'Number of item to show on load more', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::NUMBER,
                    'default' => ''
                ]
            );
            $widget->add_control(
                'load_more_text',
                [
                    'label'   => esc_html__( 'Load More Text', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::TEXT
                ]
            );
        $widget->end_controls_section();
    }
}
