<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;

if (!function_exists('fortis_widget_cms_gallery_carousel_register_controls')) {
    add_action('etc_widget_cms_gallery_carousel_register_controls', 'fortis_widget_cms_gallery_carousel_register_controls', 10, 1);
    function fortis_widget_cms_gallery_carousel_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_gallery/layout/1.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-egallery-carousel cms-egallery-'
                ]
            );
        $widget->end_controls_section();
        // Gallery
        $widget->start_controls_section(
            'section_gallery',
            [
                'label' => esc_html__('Gallery Image', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'gallery',
                [
                    'label'   => esc_html__( 'Add Images', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::GALLERY
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'gallery',
                    'label'   => esc_html__('Image Size','fortis'),
                    'default' => 'custom'
                ]
            );
        $widget->end_controls_section();
        // Settings
        $widget->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__('Settings','fortis'),
                'tab'   => Controls_Manager::TAB_SETTINGS
            ]
        );
            $slides_to_show = range(1, 10);
            $slides_to_show = array_combine($slides_to_show, $slides_to_show);
            $widget->add_responsive_control(
                'slides_to_show',
                [
                    'label'   => esc_html__('Slides to Show', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                            '' => esc_html__('Default', 'fortis'),
                        ] + $slides_to_show,
                    'frontend_available' => true,
                ]
            );

            $widget->add_responsive_control(
                'slides_to_scroll',
                [
                    'label'       => esc_html__('Slides to Scroll', 'fortis'),
                    'type'        => Controls_Manager::SELECT,
                    'description' => esc_html__('Set how many slides are scrolled per swipe.', 'fortis'),
                    'options'     => [
                            '' => esc_html__('Default', 'fortis'),
                        ] + $slides_to_show,
                    'condition' => [
                        'slides_to_show!' => '1',
                    ],
                    'frontend_available' => true,
                ]
            );
            $widget->add_responsive_control(
                'space_between',
                [
                    'label' => esc_html__('Space Between', 'fortis'),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 40,
                    ],
                    'condition' => [
                        'slides_to_show!' => '1',
                    ],
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'arrows',
                [
                    'label'              => esc_html__('Show Arrows', 'fortis'),
                    'type'               => \Elementor\Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'dots',
                [
                    'label'              => esc_html__('Show Dots', 'fortis'),
                    'type'               => \Elementor\Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'arrow_prev_icon',
                [
                    'label'            => esc_html__('Previous Arrow Icon', 'fortis'),
                    'type'             => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'skin'             => 'inline',
                    'label_block'      => false,
                    'skin_settings'    => [
                        'inline' => [
                            'none' => [
                                'label' => 'Default',
                                'icon' => 'cmsi-chevron-left',
                            ],
                            'icon' => [
                                'icon' => 'cmsi-chevron-left',
                            ],
                        ],
                    ],
                    'condition' => [
                        'arrows' => 'yes'
                    ],
                ]
            );
            $widget->add_control(
                'arrow_next_icon',
                [
                    'label'            => esc_html__('Next Arrow Icon', 'fortis'),
                    'type'             => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'skin'             => 'inline',
                    'label_block'      => false,
                    'skin_settings'    => [
                        'inline' => [
                            'none' => [
                                'label' => 'Default',
                                'icon' => 'cmsi-chevron-right',
                            ],
                            'icon' => [
                                'icon' => 'cmsi-chevron-right',
                            ],
                        ],
                    ],
                    'condition' => [
                        'arrows' => 'yes'
                    ],
                ]
            );

            $widget->add_control(
                'lazyload',
                [
                    'label'              => esc_html__('Lazyload', 'fortis'),
                    'type'               => Controls_Manager::SWITCHER,
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'autoplay',
                [
                    'label'              => esc_html__('Autoplay', 'fortis'),
                    'type'               => \Elementor\Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'pause_on_hover',
                [
                    'label'              => esc_html__('Pause on Hover', 'fortis'),
                    'type'               => \Elementor\Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                    'condition'          => [
                        'autoplay' => 'yes',
                    ],
                ]
            );

            $widget->add_control(
                'pause_on_interaction',
                [
                    'label'              => esc_html__('Pause on Interaction', 'fortis'),
                    'type'               => \Elementor\Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                    'condition'          => [
                        'autoplay' => 'yes',
                    ],
                ]
            );

            $widget->add_control(
                'autoplay_speed',
                [
                    'label'     => esc_html__('Autoplay Speed', 'fortis'),
                    'type'      => Controls_Manager::NUMBER,
                    'default'   => 5000,
                    'condition' => [
                        'autoplay' => 'yes',
                    ],
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'infinite',
                [
                    'label'              => esc_html__('Infinite Loop', 'fortis'),
                    'type'               => \Elementor\Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'effect',
                [
                    'label'   => esc_html__('Effect', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'slide',
                    'options' => [
                        'slide' => esc_html__('Slide', 'fortis'),
                        'fade' => esc_html__('Fade', 'fortis'),
                    ],
                    'condition' => [
                        'slides_to_show' => '1',
                    ],
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'speed',
                [
                    'label'              => esc_html__('Animation Speed', 'fortis'),
                    'type'               => Controls_Manager::NUMBER,
                    'default'            => 500,
                    'render_type'        => 'none',
                    'frontend_available' => true,
                ]
            );
        $widget->end_controls_section();
    }
}
