<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;

if (!function_exists('fortis_widget_cms_heading_register_controls')) {
    add_action('etc_widget_cms_heading_register_controls', 'fortis_widget_cms_heading_register_controls', 10, 1);
    function fortis_widget_cms_heading_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/2.jpg'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/3.jpg'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/4.jpg'
                        ],
                        '5' => [
                            'label' => esc_html__( 'Layout 5', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/5.jpg'
                        ],
                        '6' => [
                            'label' => esc_html__( 'Layout 6', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/6.jpg'
                        ],
                        '7' => [
                            'label' => esc_html__( 'Layout 7', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/7.jpg'
                        ],
                        '8' => [
                            'label' => esc_html__( 'Layout 8', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/8.jpg'
                        ],
                        '9' => [
                            'label' => esc_html__( 'Layout 9', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/9.jpg'
                        ],
                        '10' => [
                            'label' => esc_html__( 'Layout 10', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/10.jpg'
                        ],
                        '11' => [
                            'label' => esc_html__( 'Layout 11', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/11.jpg'
                        ],
                        '12' => [
                            'label' => esc_html__( 'Layout 12', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/12.jpg'
                        ],
                        '13' => [
                            'label' => esc_html__( 'Layout 13', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/13.jpg'
                        ],
                        '14' => [
                            'label' => esc_html__( 'Layout 14', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/14.jpg'
                        ],
                        '15' => [
                            'label' => esc_html__( 'Layout 15', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/15.jpg'
                        ],
                        '17' => [
                            'label' => esc_html__( 'Layout 17', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/17.jpg'
                        ],
                        '18' => [
                            'label' => esc_html__( 'Layout 18', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/18.jpg'
                        ],
                        '19' => [
                            'label' => esc_html__( 'Layout 19', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/19.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class'   => 'cms-e-heading-'
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start

        // Heading Section Start
        $widget->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('Heading Content', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'subheading_text',
                [
                    'label'       => esc_html__( 'Small Heading', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Enter your small title', 'fortis' ),
                    'label_block' => true,
                    'separator'   => 'after',
                    'dynamic' => [
                        'active' => true,
                    ]
                ]
            );
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'default'     => esc_html__( 'This is the heading', 'fortis' ),
                    'placeholder' => esc_html__( 'Enter your title', 'fortis' ),
                    'label_block' => true
                ]
            );
            $widget->add_control(
                'heading_size',
                [
                    'label'   => esc_html__( 'Heading HTML Tag', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        'h1'   => 'H1',
                        'h2'   => 'H2',
                        'h3'   => 'H3',
                        'h4'   => 'H4',
                        'h5'   => 'H5',
                        'h6'   => 'H6',
                        'div'  => 'div',
                        'span' => 'span',
                        'p'    => 'p',
                    ],
                    'default'     => 'h2',
                    'label_block' => false,
                    'condition'   => [
                        'layout!' => ['12']
                    ]
                ]
            );
            $widget->add_control(
                'description_bold_text',
                [
                    'label'       => esc_html__( 'Description (Bold)', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Enter your description', 'fortis' ),
                    'rows'        => 10,
                    'show_label'  => true,
                    'separator' => 'before',
                    'condition' => [
                        'layout' => ['2','3','4','8', '11','13','14','15','17','18','19']
                    ]
                ]
            );
            $widget->add_control(
                'description_text',
                [
                    'label'       => esc_html__( 'Description', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Enter your description', 'fortis' ),
                    'rows'        => 10,
                    'show_label'  => true,
                    'separator' => 'before',
                    'condition' => [
                        'layout' => ['1','3','7','8','9', '10', '12','13','14','15','17','19']
                    ]
                ]
            );
        $widget->end_controls_section();
        // Link 1
        $widget->start_controls_section('link1_section',[
            'label' => esc_html__('Link #1', 'fortis'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [
                'layout' => ['2','3','4','8','9', '10','11','13','14','15','17','18','19']
            ]
        ]);
            $widget->add_control(
                'link1_text',
                [
                    'label'       => esc_html__( 'Link Text', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Discover More', 'fortis' ),
                    'separator' => 'before'
                ]
            );
            $widget->add_control(
                'link1_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'link1_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'link1_page',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'link1_text!' => '',
                        'link1_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'link1_custom',
                [
                    'label'       => esc_html__( 'Link Custom', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'link1_text!' => '',
                        'link1_type' => 'custom'
                    ]
                ]
            );
            $widget->add_control(
                'link1_hover',
                [
                    'label'       => esc_html__( 'Link Hover Color', 'fortis' ),
                    'type'        => Controls_Manager::SELECT,
                    'options'     => [
                        'primary' => esc_html__('Primary Color','fortis'),
                        'secondary' => esc_html__('Secondary Color','fortis')
                    ],
                    'default' => 'secondary',
                    'condition' => [
                        'layout'      => ['11'],
                        'link1_text!' => ''
                    ]
                ]
            );
        $widget->end_controls_section();
        // Link 2
        $widget->start_controls_section('link2_section',[
            'label' => esc_html__('Link #2', 'fortis'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [
                'layout' => ['2','3','4','8','9','10','11','13','14','15','17','18','19']
            ]
        ]);
            $widget->add_control(
                'link2_text',
                [
                    'label'       => esc_html__( 'Link Text', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Contact Us', 'fortis' ),
                    'separator' => 'before'
                ]
            );
            $widget->add_control(
                'link2_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'link2_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'link2_page',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'link2_text!' => '',
                        'link2_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'link2_custom',
                [
                    'label'       => esc_html__( 'Link Custom', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'link2_text!' => '',
                        'link2_type' => 'custom'
                    ]
                ]
            );
        $widget->end_controls_section();
        // Features
        $widget->start_controls_section('features_section',[
            'label' => esc_html__('Features Settings', 'fortis'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [
                'layout' => ['3','8', '11','13','14','15']
            ]
        ]);
            $repeater = new Repeater();
            $repeater->add_control(
                'icon',
                [
                    'label'       => esc_html__( 'Icon', 'fortis' ),
                    'default'     => [
                        'library'   => 'cmsi',
                        'value'     => 'cmsi-check-circle'
                    ],
                    'type'        => Controls_Manager::ICONS,
                    'skin'        => 'inline',
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'fortis' ),
                    'default'     => esc_html__( 'Title', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $widget->add_control(
                'show_feature',
                [
                    'label'   => esc_html__('Show Feature', 'fortis'),
                    'type'    => \Elementor\Controls_Manager::SWITCHER,
                    'default' => 'yes',
                ]
            );
            $widget->add_control(
                'cms_feature',
                [
                    'label'   => esc_html__('Features List', 'fortis'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        [
                            'icon'  => [
                                'library'   => 'cmsi',
                                'value'     => 'cmsi-check-circle'
                            ],
                            'title' => 'Quality Control System, Highly Professional Staff',
                        ],
                        [
                            'icon'  => [
                                'library'   => 'cmsi',
                                'value'     => 'cmsi-check-circle'
                            ],
                            'title' => 'Satisfaction Guarantee, and Accurate Testing',
                        ]
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $widget->end_controls_section();
        // Banner
        $widget->start_controls_section('banner_section',[
            'label' => esc_html__('Banner', 'fortis'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [
                'layout' => ['3','15']
            ]
        ]);
            $widget->add_control(
                'banner_icon',
                [
                    'label'   => esc_html__( 'Icon', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::ICONS,
                    'skin'    => 'inline',  
                    'default' => [
                        'library' => 'cmsi',
                        'value'   => 'cmsi-star'
                    ],
                    'label_block' => false,
                    'condition' => [
                        'layout'       => ['3'],
                        'banner[url]!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'banner_title',
                [
                    'label'       => esc_html__( 'Title', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'default'     => 'Your Banner Title',
                    'label_block' => true,
                    'condition' => [
                        'layout'       => ['3'],
                        'banner[url]!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'banner',
                [
                    'label'   => esc_html__( 'Banner', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ]
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'banner',
                    'label'   => esc_html__('Banner Size','fortis'),
                    'default' => 'custom',
                    'condition' => [
                        'banner[url]!' => ''
                    ]
                ]
            );
        $widget->end_controls_section();

        // Style Content Alignment Start
        $widget->start_controls_section(
            'section_style_content',
            [
                'label' => esc_html__('Content Alignment', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_responsive_control(
            'align',
            [
                'label'        => esc_html__( 'Alignment', 'fortis' ),
                'type'         => Controls_Manager::CHOOSE,
                'responsive'   => true,
                'options'      => [
                    'start'    => [
                        'title' => esc_html__( 'Left', 'fortis' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center'  => [
                        'title' => esc_html__( 'Center', 'fortis' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'end'   => [
                        'title' => esc_html__( 'Right', 'fortis' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'fortis' ),
                        'icon' => 'eicon-text-align-justify',
                    ]
                ],
                'prefix_class' => 'text%s-'
            ]
        );
        $widget->end_controls_section(); // Style Content Alignment End

        // Style Heading Style Start
        $widget->start_controls_section(
            'section_style_heading',
            [
                'label' => esc_html__('Heading Style', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
            'heading_bottom_space',
            [
                'label'        => esc_html__( 'Bottom Spacing', 'fortis' ),
                'type'         => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units'   => [ 'px' ],
                'default'      => [
                    'size' => '',
                ],
                'range'        => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'    => [
                    '{{WRAPPER}} .cms-heading' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $widget->add_control(
            'heading_color',
            [
                'label'     => esc_html__( 'Heading Color', 'fortis' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-heading, {{WRAPPER}} .cms-heading a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'heading_typography',
                'selector' => '{{WRAPPER}} .cms-heading, {{WRAPPER}} .cms-heading a',
            ]
        );
        $widget->end_controls_section(); // Style Heading Style End

        // Style Sub Heading Style Start
        $widget->start_controls_section(
            'section_style_subheading',
            [
                'label' => esc_html__('Sub Heading Style', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
            'subheading_color',
            [
                'label'     => esc_html__( 'Sub Heading Color', 'fortis' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-subheading' => 'color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subheading_typography',
                'selector'     => '{{{WRAPPER}} .cms-subheading',
            ]
        );
        $widget->end_controls_section(); // Style Sub Heading Style End
        // Style Description Style Start
        $widget->start_controls_section(
            'section_style_description_bold',
            [
                'label' => esc_html__('Description Bold Style', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
            'description_bold_color',
            [
                'label'      => esc_html__( 'Color', 'fortis' ),
                'type'       => \Elementor\Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .cms-desc-bold' => 'color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_bold_typography',
                'selector'     => '{{WRAPPER}} .cms-desc-bold',
            ]
        );
        $widget->end_controls_section(); // Style Description Style End

        // Style Description Style Start
        $widget->start_controls_section(
            'section_style_description',
            [
                'label' => esc_html__('Description Style', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
            'description_color',
            [
                'label'      => esc_html__( 'Color', 'fortis' ),
                'type'       => \Elementor\Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .cms-heading-description' => 'color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'selector'     => '{{WRAPPER}} .cms-heading-description',
            ]
        );
        $widget->end_controls_section(); // Style Description Style End
        
        // Style Features Style Start
        $widget->start_controls_section(
            'section_style_feature',
            [
                'label' => esc_html__('Features Style', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
            'feature_color',
            [
                'label'      => esc_html__( 'Color', 'fortis' ),
                'type'       => \Elementor\Controls_Manager::COLOR,
                'selectors'  => [
                    '{{WRAPPER}} .cms-heading-features' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .cms-heading-features .cms-icon' => 'color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'feature_typography',
                'selector'     => '{{WRAPPER}} .cms-heading-features',
            ]
        );
        $widget->end_controls_section(); // Style Description Style End
        // Content Tab End

    }
}
