<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;

if (!function_exists('fortis_widget_cms_icon_register_controls')) {
    add_action('etc_widget_cms_icon_register_controls', 'fortis_widget_cms_icon_register_controls', 10, 1);
    function fortis_widget_cms_icon_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_responsive_control(
                'align',
                [
                    'label'        => esc_html__( 'Alignment', 'fortis' ),
                    'type'         => Controls_Manager::CHOOSE,
                    'responsive'   => true,
                    'options'      => [
                        'start'    => [
                            'title' => esc_html__( 'Left', 'fortis' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center'  => [
                            'title' => esc_html__( 'Center', 'fortis' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'end'   => [
                            'title' => esc_html__( 'Right', 'fortis' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                        'justify'   => [
                            'title' => esc_html__( 'Justified', 'fortis' ),
                            'icon'  => 'eicon-text-align-justify',
                        ]
                    ],
                    'style_transfer' => true
                ]
            );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_icon/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_icon/layout/2.jpg'
                        ]
                    ],
                    'style_transfer' => true,
                    //'prefix_class' => 'cms-eicons d-flex cms-eicons-'
                ]
            );
        $widget->end_controls_section();

        // icon Section Start
        $widget->start_controls_section(
            'section_icon',
            [
                'label' => esc_html__('Icons', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new Repeater();

        $repeater->add_control(
            'cms_icon',
            [
                'label'            => esc_html__( 'Icon', 'fortis' ),
                'type'             => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'cmsi-star',
                    'library' => 'cmsi',
                ],
            ]
        );
        $repeater->add_control(
            'icon_link',
            [
                'label'       => esc_html__( 'Icon Link', 'fortis' ),
                'type'        => \Elementor\Controls_Manager::URL,
                'label_block' => true,
            ]
        );
        $widget->add_control(
            'icons',
            [
                'label'   => esc_html__('Icons', 'fortis'),
                'type'    => \Elementor\Controls_Manager::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => [
                    [
                        'cms_icon' => [
                            'library' => 'cmsi',
                            'value'   => 'cmsi-facebook'  
                        ],
                        'icon_link' => 'https://www.facebook.com/cmssuperheroes',
                    ],
                    [
                        'cms_icon' => [
                            'library' => 'cmsi',
                            'value'   => 'cmsi-twitter-circle'  
                        ],
                        'icon_link' => 'https://twitter.com',
                    ],
                    [
                        'cms_icon' => [
                            'library' => 'cmsi',
                            'value'   => 'cmsi-linkedin-circle'  
                        ],
                        'icon_link' => 'https://linkedin.com',
                    ],
                ],
                'title_field' => '{{{ elementor.helpers.renderIcon( this, cms_icon, {}, "i", "panel" ) || \'<i class="{{ icon }}" aria-hidden="true"></i>\' }}}',
            ]
        );
        $widget->end_controls_section(); // icon Section End

        // Style Section Start
        $widget->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Icons Style', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
            'color',
            [
                'label'     => esc_html__( 'Color', 'fortis' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-icon' => 'color: {{VALUE}} !important;',
                ],
            ]
        );
        $widget->add_control(
            'color_hover',
            [
                'label'     => esc_html__( 'Color Hover', 'fortis' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-icon:hover' => 'color: {{VALUE}} !important;',
                ],
            ]
        );
        $widget->end_controls_section(); // Style Section End

        // Content Tab End

    }
}
