<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;

if (!function_exists('fortis_widget_cms_industry_carousel_register_controls')) {
    add_action('etc_widget_cms_industry_carousel_register_controls', 'fortis_widget_cms_industry_carousel_register_controls', 10, 1);
    function fortis_widget_cms_industry_carousel_register_controls($widget)
    {
        // Post term options
        $post_term_options = etc_get_grid_term_options('cms-industry');
        // Layout Settings
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis' ),
                'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__('Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '3',
                    'options' => [
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/layout/3.jpg'
                        ],
                        '5' => [
                            'label' => esc_html__( 'Layout 5', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/layout/5.jpg'
                        ],
                        '9' => [
                            'label' => esc_html__( 'Layout 9', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/layout/9.jpg'
                        ]
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-eblog cms-eblog-'
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start
        // Source Section Start
        $widget->start_controls_section(
            'source_section',
            [
                'label' => esc_html__('Source', 'fortis'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'source',
            [
                'label' => esc_html__('Select Categories', 'fortis'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $post_term_options,
            ]
        );
        $widget->add_control(
            'orderby',
            [
                'label'   => esc_html__('Order By', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date'   => esc_html__('Date', 'fortis'),
                    'ID'     => esc_html__('ID', 'fortis'),
                    'author' => esc_html__('Author', 'fortis'),
                    'title'  => esc_html__('Title', 'fortis'),
                    'rand'   => esc_html__('Random', 'fortis'),
                ],
            ]
        );
        $widget->add_control(
            'order',
            [
                'label'   => esc_html__('Sort Order', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'desc' => esc_html__('Descending', 'fortis'),
                    'asc'  => esc_html__('Ascending', 'fortis'),
                ],
            ]
        );
        $widget->add_control(
            'limit',
            [
                'label'   => esc_html__('Total items', 'fortis'),
                'type'    => Controls_Manager::NUMBER,
                'default' => '6',
            ]
        );
        $widget->end_controls_section();
        // Source Section End
        // Display Section Start
        $widget->start_controls_section(
            'display_section',
            [
                'label' => esc_html__('Display', 'fortis'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'thumbnail',
                    'default' => 'custom',
                ]
            );
            $widget->add_control(
                'num_words',
                [
                    'label'       => esc_html__('Excerpt Length', 'fortis'),
                    'type'        => Controls_Manager::NUMBER,
                    'default'     => '',
                    'placeholder' => '25',
                    'separator'   => 'after',
                ]
            );

            $widget->add_control(
                'readmore_text',
                [
                    'label'       => esc_html__('Readmore Text', 'fortis'),
                    'type'        => Controls_Manager::TEXT,
                    'placeholder' => esc_html__('Read More','fortis'),
                ]
            );
        $widget->end_controls_section();
        // Display Section End
        // Custom Content Start
        $widget->start_controls_section(
            'custom_content_section',
            [
                'label'     => esc_html__('Custom Content', 'fortis'),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['5']
                ]
            ]
        );
            $widget->add_control(
                'text',
                [
                    'label' => esc_html__('Custom Content','fortis'),
                    'type'  => Controls_Manager::TEXTAREA
                ]
            );
            // Button 1
            $widget->add_control(
                'link1_text',
                [
                    'label'       => esc_html__( 'Button #1', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Awards And Milestones', 'fortis' ),
                    'separator'   => 'before'
                ]
            );
            $widget->add_control(
                'link1_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default'   => 'custom',
                    'condition' => [
                        'link1_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'link1_page',
                [
                    'label'     => esc_html__('Select Page', 'fortis'),
                    'type'      => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'link1_text!' => '',
                        'link1_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'link1_custom',
                [
                    'label'       => esc_html__( 'Link Custom', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'link1_text!' => '',
                        'link1_type' => 'custom'
                    ]
                ]
            );
            // Button 2
            $widget->add_control(
                'link2_text',
                [
                    'label'       => esc_html__( 'Button #2', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Contact Us', 'fortis' ),
                    'separator' => 'before'
                ]
            );
            $widget->add_control(
                'link2_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'link2_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'link2_page',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'link2_text!' => '',
                        'link2_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'link2_custom',
                [
                    'label'       => esc_html__( 'Link Custom', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'link2_text!' => '',
                        'link2_type' => 'custom'
                    ]
                ]
            );
        $widget->end_controls_section();
        // Custom Content End
        // Carousel Section Start
        $widget->start_controls_section(
            'carousel_section',
            [
                'label' => esc_html__('Carousel Settings', 'fortis'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $slides_to_show = range(1, 10);
        $slides_to_show = array_combine($slides_to_show, $slides_to_show);
        $widget->add_responsive_control(
            'slides_to_show',
            [
                'label' => esc_html__('Slides to Show', 'fortis'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                        '' => esc_html__('Default', 'fortis'),
                    ] + $slides_to_show,
                'frontend_available' => true,
            ]
        );

        $widget->add_responsive_control(
            'slides_to_scroll',
            [
                'label' => esc_html__('Slides to Scroll', 'fortis'),
                'type' => Controls_Manager::SELECT,
                'description' => esc_html__('Set how many slides are scrolled per swipe.', 'fortis'),
                'options' => [
                        '' => esc_html__('Default', 'fortis'),
                    ] + $slides_to_show,
                'condition' => [
                    'slides_to_show!' => '1',
                ],
                'frontend_available' => true,
            ]
        );
        $widget->add_responsive_control(
            'space_between',
            [
                'label' => esc_html__('Space Between', 'fortis'),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 40,
                ],
                'condition' => [
                    'slides_to_show!' => '1',
                ],
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'arrows',
            [
                'label'   => esc_html__('Show Arrows', 'fortis'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );
        $widget->add_control(
            'arrow_prev_icon',
            [
                'label'            => esc_html__('Previous Arrow Icon', 'fortis'),
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => false,
                'skin'             => 'inline',
                'label_block'      => false,
                'skin_settings'    => [
                    'inline' => [
                        'none' => [
                            'label' => 'Default',
                            'icon' => 'cmsi-arrow-left'
                        ],
                        'icon' => [
                            'icon' => 'cmsi-arrow-left'
                        ]
                    ]
                ],
                'condition' => [
                    'arrows' => 'yes'
                ]
            ]
        );
        $widget->add_control(
            'arrow_next_icon',
            [
                'label'            => esc_html__('Next Arrow Icon', 'fortis'),
                'type'             => Controls_Manager::ICONS,
                'skin'             => 'inline',
                'label_block'      => false,
                'skin_settings'    => [
                    'inline' => [
                        'none' => [
                            'label' => 'Default',
                            'icon' => 'cmsi-arrow-right'
                        ],
                        'icon' => [
                            'icon' => 'cmsi-arrow-right'
                        ]
                    ]
                ],
                'condition' => [
                    'arrows' => 'yes'
                ]
            ]
        );

        $widget->add_control(
            'lazyload',
            [
                'label'              => esc_html__('Lazyload', 'fortis'),
                'type'               => Controls_Manager::SWITCHER,
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'fortis'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'pause_on_hover',
            [
                'label' => esc_html__('Pause on Hover', 'fortis'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $widget->add_control(
            'pause_on_interaction',
            [
                'label' => esc_html__('Pause on Interaction', 'fortis'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $widget->add_control(
            'autoplay_speed',
            [
                'label' => esc_html__('Autoplay Speed', 'fortis'),
                'type' => Controls_Manager::NUMBER,
                'default' => 5000,
                'condition' => [
                    'autoplay' => 'yes',
                ],
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'infinite',
            [
                'label' => esc_html__('Infinite Loop', 'fortis'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'effect',
            [
                'label' => esc_html__('Effect', 'fortis'),
                'type' => Controls_Manager::SELECT,
                'default' => 'slide',
                'options' => [
                    'slide' => esc_html__('Slide', 'fortis'),
                    'fade' => esc_html__('Fade', 'fortis'),
                ],
                'condition' => [
                    'slides_to_show' => '1',
                ],
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'speed',
            [
                'label' => esc_html__('Animation Speed', 'fortis'),
                'type' => Controls_Manager::NUMBER,
                'default' => 500,
                'render_type' => 'none',
                'frontend_available' => true,
            ]
        );

        $widget->end_controls_section();
        // Carousel Section End
        // Content Tab End

        // Style Tab Start
        // Custom layout
        $widget->start_controls_section(
            'content_width_section',
            [
                'label'      => esc_html__('Custom Styles', 'fortis'),
                'tab'        => Controls_Manager::TAB_STYLE,
            ]
        );
            $widget->add_control(
                'content_width',
                [
                    'label'     => esc_html__('Content Width', 'fortis'),
                    'type'      => Controls_Manager::SELECT,
                    'options'   => [
                        ''            => esc_html__('Default', 'fortis'),
                        'start'       => esc_html__('Full to Start', 'fortis'),
                        'end'         => esc_html__('Full to End', 'fortis'),
                        'start-large' => esc_html__('Full to Start (Large)', 'fortis'),
                        'end-large'   => esc_html__('Full to End (Large)', 'fortis')
                    ],
                    'prefix_class' => 'cms-swiper-full-'
                ]
            );
            $widget->add_control(
                'item_shadow',
                [
                    'label'     => esc_html__('Item Shadow?', 'fortis'),
                    'type'      => Controls_Manager::SELECT,
                    'options'   => [
                        'yes' => esc_html__('Yes', 'fortis'),
                        'no'   => esc_html__('No', 'fortis')
                    ],
                    'default' => 'no',
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-carousel-item-shadow-',

                ]
            );
        $widget->end_controls_section();
        // Naivgation Section Start
        $widget->start_controls_section(
            'navigation_section',
            [
                'label'      => esc_html__('Navigation', 'fortis'),
                'tab'        => Controls_Manager::TAB_STYLE,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'arrows',
                            'operator' => '==',
                            'value' => 'yes',
                        ]
                    ]
                ]
            ]
        );

        $widget->add_control(
            'heading_style_arrows',
            [
                'label'     => esc_html__('Arrows', 'fortis'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'arrows' => 'yes',
                ],
            ]
        );
        $widget->add_control(
            'arrows_size',
            [
                'label' => esc_html__('Size', 'fortis'),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 60,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .cms-carousel-button-prev, {{WRAPPER}} .cms-carousel-button-next' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'arrows' => 'yes',
                ],
            ]
        );
        $widget->add_control(
            'arrows_color',
            [
                'label' => esc_html__('Color', 'fortis'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-carousel-button-prev, {{WRAPPER}} .cms-carousel-button-next' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .cms-carousel-button-prev svg, {{WRAPPER}} .cms-carousel-button-next svg' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'arrows' => 'yes',
                ],
            ]
        );
        $widget->end_controls_section();
        // Naivgation Section End
        // Style Tab End
    }
}
