<?php
use Elementor\Controls_Manager;

if(!function_exists('fortis_widget_cms_language_switcher_register_controls')){
	add_action('etc_widget_cms_language_switcher_register_controls', 'fortis_widget_cms_language_switcher_register_controls', 10, 1);
	function fortis_widget_cms_language_switcher_register_controls($widget){
		// Layout Settings
		$widget->start_controls_section(
			'layout_section',
			[
				'label' => esc_html__('Layout', 'fortis' ),
                'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
			]
		);

			$widget->add_control(
				'layout',
                [
                	'label' => esc_html__('Templates', 'fortis' ),
	                'type' => Elementor_Theme_Core::LAYOUT_CONTROL,
	                'default' => '1',
	                'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_language_switcher/layout/1.jpg'
                        ]
                    ],
                    'prefix_class' => 'cms-ls-layout-'
	            ]
			);
		$widget->end_controls_section();
		// Settings
		$widget->start_controls_section(
			'setting_section',
            [
            	'label'    => esc_html__('Settings', 'fortis'),
                'tab'      => \Elementor\Controls_Manager::TAB_CONTENT
            ]
		);
			$widget->add_control(
				'show_flag',
                [
                 	'label'   => esc_html__('Show Flag','fortis'),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        ''    => esc_html__('Default','fortis'),
                        'yes' => esc_html__('Yes', 'fortis'),
                        'no'  => esc_html__('No', 'fortis')
                    ]
                ]
			);
			$widget->add_control(
				'show_name',
                [
                	'label'   => esc_html__('Show Name','fortis'),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        ''    => esc_html__('Default','fortis'),
                        'yes' => esc_html__('Yes', 'fortis'),
                        'no'  => esc_html__('No', 'fortis')
                    ]
                ]
			);
			$widget->add_control(
				'name_as',
                [
                	'label'   => esc_html__('Name As','fortis'),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        ''      => esc_html__('Default','fortis'),
                        'full'  => esc_html__('Full', 'fortis'),
                        'short' => esc_html__('Short', 'fortis')
                    ],
                    'condition' => [
                        'show_name' => ['yes']
                    ] 
                ]
			);
            $widget->add_control(
            	'dropdown_pos',
                [
                	'label'   => esc_html__('Dropdown Position','fortis'),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        ''       => esc_html__('Default','fortis'),
                        'top'    => esc_html__('Top', 'fortis'),
                        'bottom' => esc_html__('Bottom', 'fortis')
                    ]
                ]                
            );
		$widget->end_controls_section();
        // Style
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style Settings','fortis'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
             $widget->add_control(
                'color',
                [
                    'label'     => esc_html__( 'Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .current-language' => 'color: {{VALUE}} !important;',
                    ],
                ]
            );
            $widget->add_control(
                'color_hover',
                [
                    'label'     => esc_html__( 'Color Hover & Active', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .current-language:hover' => 'color: {{VALUE}} !important;',
                    ],
                ]
            );
        $widget->end_controls_section();
	}
}
?>