<?php

use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;

if (!function_exists('fortis_widget_cms_list_register_controls')) {
    add_action('etc_widget_cms_list_register_controls', 'fortis_widget_cms_list_register_controls', 10, 1);
    function fortis_widget_cms_list_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_list/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_list/layout/2.jpg'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_list/layout/3.jpg'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_list/layout/4.jpg'
                        ],
                        '5' => [
                            'label' => esc_html__( 'Layout 5', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_list/layout/5.jpg'
                        ],
                        '6' => [
                            'label' => esc_html__( 'Layout 6', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_list/layout/6.jpg'
                        ],
                        '9' => [
                            'label' => esc_html__( 'Layout 9', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_list/layout/9.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-lists-'
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start

        // list Section Start
        $widget->start_controls_section(
            'section_list',
            [
                'label' => esc_html__('List Content', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'icon',
            [
                'label'       => esc_html__( 'Icon', 'fortis' ),
                'default'     => [
                    'library' => 'cmsi',
                    'value'   => 'cmsi-check-circle'
                ],
                'type'        => Controls_Manager::ICONS,
                'skin'        => 'inline',
                'label_block' => false
            ]
        );
        $repeater->add_control(
            'title',
            [
                'label'       => esc_html__( 'Title', 'fortis' ),
                'default'     => esc_html__( 'Title', 'fortis' ),
                'type'        => Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );
        $widget->add_control(
            'cms_list',
            [
                'label' => esc_html__('List', 'fortis'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'icon'  => [
                            'library' => 'cmsi',
                            'value'   => 'cmsi-check-circle'
                        ],
                        'title' => esc_html__('Title', 'fortis')
                    ],
                    [
                        'icon'  => [
                            'library' => 'cmsi',
                            'value'   => 'cmsi-check-circle'
                        ],
                        'title' => esc_html__('Title', 'fortis'),
                    ],
                ],
                'title_field' => '{{{ title }}}',
                'condition' => [
                    'layout' => ['1','2','3','6','9']
                ]
            ]
        );
        
        $repeater45 = new Repeater();
            $repeater45->add_control(
                'banner',
                [
                    'label'       => esc_html__( 'Banner', 'fortis' ),
                    'default'     => [],
                    'type'        => Controls_Manager::MEDIA,
                    'label_block' => true
                ]
            );
            $repeater45->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'fortis' ),
                    'default'     => esc_html__( 'Title', 'fortis' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                ]
            );
            $repeater45->add_control(
                'desc',
                [
                    'label'       => esc_html__( 'Description', 'fortis' ),
                    'default'     => 'We are happy to take the time and attention to conduct an initial analysis of your project. Thanks to this, we will be able to advise you accordingly.',
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true
                ]
            );
        $widget->add_control(
            'cms_list45',
            [
                'label' => esc_html__('List', 'fortis'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater45->get_controls(),
                'default' => [
                    [
                        'title' => esc_html__('Title', 'fortis'),
                        'desc'  => 'We are happy to take the time and attention to conduct an initial analysis of your project. Thanks to this, we will be able to advise you accordingly.'
                    ],
                    [
                        'title' => esc_html__('Title #2', 'fortis'),
                        'desc'  => 'We are happy to take the time and attention to conduct an initial analysis of your project. Thanks to this, we will be able to advise you accordingly.'
                    ],
                ],
                'title_field' => '{{{ title }}}',
                'condition' => [
                    'layout' => ['4','5']
                ]
            ]
        );
        $widget->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'    => 'banner',
                'label'   => esc_html__('Banner Size','fortis'),
                'default' => 'custom',
                'condition' => [
                    'layout' => ['4','5']
                ]
            ]
        );
        $widget->end_controls_section(); // list Section End

        // Link 1
        $widget->start_controls_section('link1_section',[
            'label' => esc_html__('Link #1', 'fortis'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [
                'layout' => ['1','4','5']
            ]
        ]);
            $widget->add_control(
                'link1_text',
                [
                    'label'       => esc_html__( 'Link Text', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Meet Our Experts', 'fortis' ),
                    'separator' => 'before'
                ]
            );
            $widget->add_control(
                'link1_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'link1_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'link1_page',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'link1_text!' => '',
                        'link1_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'link1_custom',
                [
                    'label'       => esc_html__( 'Link Custom', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'link1_text!' => '',
                        'link1_type' => 'custom'
                    ]
                ]
            );
        $widget->end_controls_section();
        // Link 2
        $widget->start_controls_section('link2_section',[
            'label' => esc_html__('Link #2', 'fortis'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [
                'layout' => ['1','4','5']
            ]
        ]);
            $widget->add_control(
                'link2_text',
                [
                    'label'       => esc_html__( 'Link Text', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Get A Free Quote', 'fortis' ),
                    'separator' => 'before'
                ]
            );
            $widget->add_control(
                'link2_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'link2_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'link2_page',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'link2_text!' => '',
                        'link2_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'link2_custom',
                [
                    'label'       => esc_html__( 'Link Custom', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'link2_text!' => '',
                        'link2_type' => 'custom'
                    ]
                ]
            );
        $widget->end_controls_section();

         // Style Section Start
         $widget->start_controls_section(
            'general_style_section',
            [
                'label' => esc_html__('Style', 'fortis'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
            'icon_color',
            [
                'label'     => esc_html__( 'Icon Color', 'fortis' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-icon' => 'color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_control(
            'content_color',
            [
                'label'     => esc_html__( 'Content Color', 'fortis' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-list' => 'color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'list_typography',
                'selector' => '{{WRAPPER}} .cms-list',
            ]
        );
        $widget->end_controls_section();// Style Section End

        // Content Tab End

    }
}
