<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if (!function_exists('fortis_widget_cms_navigation_menu_register_controls')) {
    add_action('etc_widget_cms_navigation_menu_register_controls', 'fortis_widget_cms_navigation_menu_register_controls', 10, 1);
    function fortis_widget_cms_navigation_menu_register_controls($widget)
    {
        $menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
        if ( is_array( $menus ) && ! empty( $menus ) ) {
            foreach ( $menus as $single_menu ) {
                if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->slug ) ) {
                    $custom_menus[ $single_menu->slug ] = $single_menu->name;
                }
            }
        } else {
            $custom_menus = '';
        }
        // Layout Settings
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__( 'Layout', 'fortis' ),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_navigation_menu/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_navigation_menu/layout/2.jpg'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_navigation_menu/layout/3.jpg'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_navigation_menu/layout/4.jpg'
                        ],
                        '5' => [
                            'label' => esc_html__( 'Layout 5', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_navigation_menu/layout/5.jpg'
                        ],
                        '6' => [
                            'label' => esc_html__( 'Mega Menu', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_navigation_menu/layout/6.jpg'
                        ]
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-e-menu cms-e-menu-'
                ]
            );
        $widget->end_controls_section();

        // Menu Section Start
        $widget->start_controls_section(
            'navigation_menu_section',
            [
                'label' => esc_html__('Navigation Menu', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'menu',
            [
                'label'   => esc_html__( 'Select Menu', 'fortis' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'options' => $custom_menus,
            ]
        );
        $widget->add_control(
            'title',
            [
                'label'       => esc_html__('Title', 'fortis'),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Enter your title', 'fortis'),
                'label_block' => true,
                'condition'   => [
                    'layout' => ['1','2','5','6']
                ]
            ]
        );
            $widget->add_control(
                'link_type',
                [
                    'label'   => esc_html__('Title Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'page',
                    'condition' => [
                        'layout' => ['6'],
                        'title!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'page_link',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'layout' => ['6'],
                        'title!' => '',
                        'link_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'custom_link',
                [
                    'label'       => esc_html__( 'Custom Link', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'layout' => ['6'],
                        'title!' => '',
                        'link_type' => 'custom'
                    ]
                ]
            );
        $widget->add_control(
            'title_color',
            [
                'label' => esc_html__('Title Color', 'fortis'),
                'type'  => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-title' => 'color: {{VALUE}};',
                ],
                'separator' => 'before',
                'condition'   => [
                    'layout' => ['1','2','5','6']
                ]
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Title Typography', 'fortis'),
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .cms-title',
                'condition'   => [
                    'layout' => ['1','2','5','6']
                ]
            ]
        );
        $widget->add_control(
            'link_color',
            [
                'label'     => esc_html__( 'Link Color', 'fortis' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-menu a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .cms-menu-horz li:after' => 'background-color: {{VALUE}};',
                ]
            ]
        );
        $widget->add_control(
            'link_color_hover',
            [
                'label'     => esc_html__( 'Link Color Hover & Active', 'fortis' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-menu a:hover, {{WRAPPER}} .cms-menu li.current-menu-item > a' => 'color: {{VALUE}};'
                ]
            ]
        );
        $widget->add_control(
            'align',
            [
                'label'        => esc_html__( 'Alignment', 'fortis' ),
                'type'         => Controls_Manager::CHOOSE,
                'control_type' => 'responsive',
                'options'      => [
                    'start'    => [
                        'title' => esc_html__( 'Left', 'fortis' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center'  => [
                        'title' => esc_html__( 'Center', 'fortis' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'end'   => [
                        'title' => esc_html__( 'Right', 'fortis' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'fortis' ),
                        'icon'  => 'eicon-text-align-justify',
                    ],
                ],
                'style_transfer' => true,
                'prefix_class' => 'text-'
            ]
        );
        $widget->end_controls_section(); 
    }
}
