<?php
if(!class_exists('Newsletter')) return;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if(!function_exists('fortis_widget_cms_newsletter_register_controls')){
	add_action('etc_widget_cms_newsletter_register_controls', 'fortis_widget_cms_newsletter_register_controls', 10, 1);
	function fortis_widget_cms_newsletter_register_controls($widget){
		// Layout Settings
		$widget->start_controls_section(
			'layout_section',
			[
				'label' => esc_html__('Layout', 'fortis' ),
                'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
			]
		);
			$widget->add_control(
				'layout',
                [
					'label'   => esc_html__('Templates', 'fortis' ),
					'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
					'default' => '1',
					'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_newsletter/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_newsletter/layout/2.jpg'
                        ]
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-newsletter cms-newsletter-'
	            ]
			);
		$widget->end_controls_section();
        // Form Settings
        $widget->start_controls_section(
        	'form_section',
            [
            	'label'    => esc_html__( 'Form Settings', 'fortis' ),
                'tab'      => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );
        	$widget->add_control(
        		'show_name',
                [
                	'label'       => esc_html__( 'Show Field Name', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::SELECT,
                    'options'     => [
                        ''    =>  esc_html__('Default','fortis'),
                        'yes' =>  esc_html__('Yes','fortis'),
                        'no'  =>  esc_html__('No','fortis'),
                    ]
                ]
        	);
        	$widget->add_control(
        		'name_text',
                [
                	'label'       => esc_html__( 'Name Text', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'placeholder' => esc_html__( 'Enter placeholder text', 'fortis' ),
                    'label_block' => true,
                    'condition'   => [
                        'show_name' => ['','yes']
                    ]
                ]
        	);
        	$widget->add_control(
        		'email_text',
                [
                	'label'       => esc_html__( 'Email Text', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'placeholder' => esc_html__( 'Enter placeholder text', 'fortis' ),
                    'label_block' => true
                ]
        	);
        	$widget->add_control(
        		'button_text',
                [
                	'label'       => esc_html__( 'Button Text', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'placeholder' => esc_html__( 'Enter button text', 'fortis' ),
                    'label_block' => true
                ]
        	);
        $widget->end_controls_section();
        // Content Settings
        $widget->start_controls_section(
        	'content_section',
			[
				'label'    => esc_html__( 'Content Settings', 'fortis' ),
				'tab'      => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['2']
                ]
			]
        );
            $widget->add_control(
                'form_title',
                [
                    'label'       => esc_html__( 'Form Title', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Form Title', 'fortis' ),
                    'label_block' => true,
                    'default'     => 'Sign up for industry alerts, deals, news and insights from us.'  
                ]
            );
        $widget->end_controls_section();
	}
}
?>