<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if (!function_exists('fortis_widget_cms_page_title_register_controls')) {
    add_action('etc_widget_cms_page_title_register_controls', 'fortis_widget_cms_page_title_register_controls', 10, 1);
    function fortis_widget_cms_page_title_register_controls($widget)
    {
        // Layout Tab Start

        // Layout Section Start
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
        $widget->add_control(
            'layout',
            [
                'label'   => esc_html__('Templates', 'fortis'),
                'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                'default' => '1',
                'options' => [
                    '1' => [
                        'label' => esc_html__('Layout 1', 'fortis'),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_page_title/layout/1.jpg'
                    ],
                    '2' => [
                        'label' => esc_html__('Layout 2', 'fortis'),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_page_title/layout/2.jpg'
                    ],
                    '3' => [
                        'label' => esc_html__('Layout 3', 'fortis'),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_page_title/layout/3.jpg'
                    ],
                    '4' => [
                        'label' => esc_html__('Layout 4', 'fortis'),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_page_title/layout/4.jpg'
                    ]
                ],
                'dynamic' => [
                    'active' => true
                ],
                'style_transfer' => true,
                'prefix_class' => 'cms-eptitle-'
            ]
        );
        $widget->end_controls_section();
        // Layout Section End

        // Layout Tab End

        // Content Tab Start

        // Icon Section Start
        $widget->start_controls_section(
            'page_title_section',
            [
                'label' => esc_html__('Content Setting', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'title',
            [
                'label'       => esc_html__('Title', 'fortis'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => '',
                'placeholder' => esc_html__('Enter your title', 'fortis'),
                'label_block' => true,
            ]
        );
        $widget->add_control(
            'description',
            [
                'label'       => esc_html__('Description', 'fortis'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => esc_html__('This is the page description.', 'fortis'),
                'placeholder' => esc_html__('Enter your description', 'fortis'),
                'rows'        => 10,
                'show_label'  => true,
            ]
        );
        $widget->end_controls_section();
        // Button
        $widget->start_controls_section(
            'section_btn',
            [
                'label' => esc_html__('Button Settings','fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );
            $widget->add_control(
                'link_text',
                [
                    'label'       => esc_html__('Button #1', 'fortis'),
                    'description' => esc_html__('Button Text', 'fortis'),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true
                ]
            );
            $widget->add_control(
                'link_type',
                [
                    'label'   => esc_html__('Button Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'link_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'page_link',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple' => false,
                    'condition' => [
                        'link_text!'     => '',
                        'link_type' => 'page'
                    ],
                ]
            );
            $widget->add_control(
                'custom_link',
                [
                    'label'   => esc_html__('Button Link', 'fortis'),
                    'type'    => Controls_Manager::URL,
                    'condition' => [
                        'link_text!'     => '',
                        'link_type' => 'custom'
                    ]
                ]
            );
            // Button #2
            $widget->add_control(
                'link2_text',
                [
                    'label'       => esc_html__('Button #2', 'fortis'),
                    'description' => esc_html__('Button Text', 'fortis'),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true
                ]
            );
            $widget->add_control(
                'link2_type',
                [
                    'label'   => esc_html__('Button Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'link2_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'page2_link',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple' => false,
                    'condition' => [
                        'link2_text!'     => '',
                        'link2_type' => 'page'
                    ],
                ]
            );
            $widget->add_control(
                'custom2_link',
                [
                    'label'   => esc_html__('Button Link', 'fortis'),
                    'type'    => Controls_Manager::URL,
                    'condition' => [
                        'link2_text!'     => '',
                        'link2_type' => 'custom'
                    ]
                ]
            );
        $widget->end_controls_section();
        // Video
        $widget->start_controls_section(
            'section_video',
            [
                'label' => esc_html__('Video Settings','fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );
            $widget->add_control(
                'video_link',
                [
                    'label'    => esc_html__( 'Video URL', 'fortis' ),
                    'subtitle' => esc_html__('Video url from  YouTube/Vimeo/Dailymotion','fortis'),
                    'type'     => \Elementor\Controls_Manager::TEXT,
                    'default'  => 'https://www.youtube.com/watch?v=iYf3OgEdGmo',
                    'dynamic' => [
                        'active' => true
                    ],
                    'label_block' => true
                ]
            );
            $widget->add_control(
                'video_icon',
                [
                    'label'   => esc_html__( 'Video Icon', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::ICONS,
                    'skin'    => 'inline',
                    'default' => [
                        'library' => 'cmsi',
                        'value'   => 'cmsi-play'
                    ],
                    'condition' => [
                        'video_link!' => ''
                    ],
                    'label_block' => false
                ]
            );
            $widget->add_control(
                'video_text',
                [
                    'label'    => esc_html__( 'Video Text', 'fortis' ),
                    'type'     => \Elementor\Controls_Manager::TEXTAREA,
                    'default'  => '',
                    'condition' => [
                        'video_link!' => ''
                    ],
                    'label_block' => false
                ]
            );
        $widget->end_controls_section();
        // Background 
        $widget->start_controls_section(
            'section_background',
            [
                'label' => esc_html__('Background Settings','fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );
            $widget->add_control(
                'bg_image',
                [
                    'label'       => esc_html__('Background Image', 'fortis'),
                    'type'        => Controls_Manager::MEDIA,
                    'description' => esc_html__('Select image icon.', 'fortis'),
                    'default'     => [
                        'url' => Utils::get_placeholder_image_src()
                    ]
                ]
            );
            $widget->add_control(
            'bg_overlay',
                [
                    'label'   => esc_html__('Overlay', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        ''  => esc_html__('None','fortis'),
                        '1' => esc_html__('Gradient #1','fortis'),
                    ],
                    'default'      => '1',
                    'prefix_class' => 'cms-eptitle-overlay-'
                ]
            );
        $widget->end_controls_section();
        // Style Section Start
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style Settings', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
            'title_color',
            [
                'label'   => esc_html__('Title Color', 'fortis'),
                'type'    => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-title' => 'color: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Title Typography', 'fortis'),
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .cms-title',
            ]
        );
        $widget->add_control(
            'description_color',
            [
                'label'     => esc_html__('Description Color', 'fortis'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-desc' => 'color: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Description Typography', 'fortis'),
                'name'     => 'description_typography',
                'selector' => '{{WRAPPER}} .cms-desc',
            ]
        );
        $widget->end_controls_section();
        // Style Section End

        // Content Tab End

    }
}
