<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;

if (!function_exists('fortis_widget_cms_pricing_register_controls')) {
    add_action('etc_widget_cms_pricing_register_controls', 'fortis_widget_cms_pricing_register_controls', 10, 1);
    function fortis_widget_cms_pricing_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_pricing/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_pricing/layout/2.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class'   => 'cms-epricing-'
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start

        // Heading Section Start
        $widget->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('Heading Content', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'badge_text',
                [
                    'label'       => esc_html__( 'Badge Text', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'default'     => 'BEST VALUE',
                    'label_block' => false,
                    'separator'   => 'after',
                    'dynamic'     => [
                        'active' => true,
                    ],
                    'condition' => [
                        'layout' => ['2']
                    ]
                ]
            );
            $widget->add_control(
                'price',
                [
                    'label'       => esc_html__( 'Price', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'default'     => '$150',
                    'label_block' => true,
                    'separator'   => false,
                    'dynamic'     => [
                        'active' => true,
                    ]
                ]
            );
            $widget->add_control(
                'price_pack',
                [
                    'label'       => esc_html__( 'Price Pack', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'default'     => '/Mo',
                    'label_block' => false,
                    'separator'   => 'after',
                    'dynamic'     => [
                        'active' => true,
                    ],
                    'condition' => [
                        'price!' => ''
                    ]
                ]
            );

            $widget->add_control(
                'subheading_text',
                [
                    'label'       => esc_html__( 'Small Heading', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Enter your small title', 'fortis' ),
                    'label_block' => true,
                    'dynamic' => [
                        'active' => true,
                    ]
                ]
            );
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'default'     => esc_html__( 'Starter Plan', 'fortis' ),
                    'placeholder' => esc_html__( 'Enter your title', 'fortis' ),
                    'label_block' => true
                ]
            );
            $widget->add_control(
                'description_text',
                [
                    'label'       => esc_html__( 'Description', 'fortis' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Enter your description', 'fortis' ),
                    'rows'        => 10,
                    'show_label'  => true,
                    'separator' => 'before'
                ]
            );
        $widget->end_controls_section();
        // Link 1
        $widget->start_controls_section('link1_section',[
            'label' => esc_html__('Link #1', 'fortis'),
            'tab'   => Controls_Manager::TAB_CONTENT
        ]);
            $widget->add_control(
                'link1_text',
                [
                    'label'       => esc_html__( 'Link Text', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Get Started Now',
                    'placeholder' => esc_html__( 'Get Started Now', 'fortis' ),
                    'separator'   => 'before'
                ]
            );
            $widget->add_control(
                'link1_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'link1_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'link1_page',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'link1_text!' => '',
                        'link1_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'link1_custom',
                [
                    'label'       => esc_html__( 'Link Custom', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'link1_text!' => '',
                        'link1_type' => 'custom'
                    ]
                ]
            );
            $widget->add_control(
                'link1_hover',
                [
                    'label'       => esc_html__( 'Link Hover Color', 'fortis' ),
                    'type'        => Controls_Manager::SELECT,
                    'options'     => [
                        'primary' => esc_html__('Primary Color','fortis'),
                        'secondary' => esc_html__('Secondary Color','fortis')
                    ],
                    'default' => 'primary',
                    'condition' => [
                        'link1_text!' => ''
                    ]
                ]
            );
        $widget->end_controls_section();
        // Link 2
        $widget->start_controls_section('link2_section',[
            'label' => esc_html__('Link #2', 'fortis'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [
                'layout' => ['2']
            ]
        ]);
            $widget->add_control(
                'link2_text',
                [
                    'label'       => esc_html__( 'Link Text', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Contact Us', 'fortis' ),
                    'separator' => 'before'
                ]
            );
            $widget->add_control(
                'link2_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'link2_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'link2_page',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'link2_text!' => '',
                        'link2_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'link2_custom',
                [
                    'label'       => esc_html__( 'Link Custom', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'link2_text!' => '',
                        'link2_type' => 'custom'
                    ]
                ]
            );
        $widget->end_controls_section();
        // Features
        $widget->start_controls_section('features_section',[
            'label' => esc_html__('Features Settings', 'fortis'),
            'tab'   => Controls_Manager::TAB_CONTENT
        ]);
            $repeater = new Repeater();
            $repeater->add_control(
                'icon',
                [
                    'label'       => esc_html__( 'Icon', 'fortis' ),
                    'default'     => [
                        'library'   => 'cmsi',
                        'value'     => 'cmsi-check-circle'
                    ],
                    'type'        => Controls_Manager::ICONS,
                    'skin'        => 'inline',
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'fortis' ),
                    'default'     => esc_html__( 'Title', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
                ]
            );
            $widget->add_control(
                'cms_feature',
                [
                    'label'   => esc_html__('Features List', 'fortis'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        [
                            'icon'  => [
                                'library'   => 'cmsi',
                                'value'     => 'cmsi-check-circle'
                            ],
                            'title' => 'Enterprise Network Video Recorders',
                        ],
                        [
                            'icon'  => [
                                'library'   => 'cmsi',
                                'value'     => 'cmsi-check-circle'
                            ],
                            'title' => 'Intelligent video technology storage',
                        ],
                        [
                            'icon'  => [
                                'library'   => 'cmsi',
                                'value'     => 'cmsi-check-circle'
                            ],
                            'title' => 'Streaming over network or Internet',
                        ]
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $widget->end_controls_section();
        // Banner
        $widget->start_controls_section('banner_section',[
            'label' => esc_html__('Banner', 'fortis'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [
                'layout' => ['2']
            ]
        ]);
            $widget->add_control(
                'banner',
                [
                    'label'   => esc_html__( 'Banner', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ]
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'banner',
                    'label'   => esc_html__('Banner Size','fortis'),
                    'default' => 'custom',
                    'condition' => [
                        'banner[url]!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'banner_gradient',
                [
                    'label'        => esc_html__( 'Gradient Style', 'fortis' ),
                    'type'         => \Elementor\Controls_Manager::SELECT,
                    'options'      => array(
                        'none' => esc_html__( 'None', 'fortis' ),
                        ''     => esc_html__( 'Default', 'fortis' ),
                        '1'    => esc_html__( 'Primary - Top to Bottom', 'fortis' ),
                        '2'    => esc_html__( 'Secondary - Top to Bottom', 'fortis' ),
                        '3'    => esc_html__( 'Primary - Bottom to Top', 'fortis' ),
                        '4'    => esc_html__( 'Secondary - Bottom to Top', 'fortis' ),
                        '5'    => esc_html__( 'Secondary - Bottom to Top #2', 'fortis' ),
                        '6'    => esc_html__( 'Primary - Bottom to Top #2', 'fortis' ),
                        '7'    => esc_html__( 'Gray - Bottom to Top', 'fortis' ),
                        '8'    => esc_html__( 'Secondary - Bottom to Top #3', 'fortis' ),
                        '9'    => esc_html__( 'Secondary - Bottom to Top #4', 'fortis' ),
                        '10'   => esc_html__( 'Red - Top to Bottom', 'fortis' ),
                    ),
                    'default'   => '',
                    'separator' => 'before',
                    'condition' => [
                        'banner[url]!' => ''
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
