<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Repeater;

if (!function_exists('fortis_widget_cms_process_register_controls')) {
    add_action('etc_widget_cms_process_register_controls', 'fortis_widget_cms_process_register_controls', 10, 1);
    function fortis_widget_cms_process_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_process/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_process/layout/2.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-process-'
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start
        // List Section Start
        $widget->start_controls_section(
            'list_section',
            [
                'label' => esc_html__('List', 'fortis'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__('Image', 'fortis'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label'   => esc_html__('Title', 'fortis'),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => 'Your title here',
            ]
        );

        $repeater->add_control(
            'desc',
            [
                'label'   => esc_html__( 'Description', 'fortis' ),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => 'Your description here. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry',
            ]
        );

        $widget->add_control(
            'process',
            [
                'label' => esc_html__('Process', 'fortis'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'title' => esc_html__('Your title here', 'fortis'),
                        'desc'  => 'Your description here. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry',
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'title' => esc_html__('Your title here #2', 'fortis'),
                        'desc'  => 'Your description here. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry',
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'title' => esc_html__('Your title here #3', 'fortis'),
                        'desc'  => 'Your description here. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry',
                    ]
                ],
                'title_field' => '{{{ title }}}',
            ]
        );
        $widget->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'    => 'image',
                'default' => 'custom',
            ]
        );
        $widget->end_controls_section();
        // List Section End
        // Style section
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style Settings','fortis'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
            $widget->add_control(
                'count_color',
                [
                    'label'     => esc_html__( 'Count Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-count' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $widget->add_control(
                'title_color',
                [
                    'label'     => esc_html__( 'Title Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-heading' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $widget->add_control(
                'desc_color',
                [
                    'label'     => esc_html__( 'Description Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-desc' => 'color: {{VALUE}};',
                    ],
                ]
            );
        $widget->end_controls_section();
        // Style Section End
        // Carousel Section Start
        $widget->start_controls_section(
            'carousel_section',
            [
                'label' => esc_html__('Carousel Settings', 'fortis'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );
            $widget->add_control(
                'content_width',
                [
                    'label'     => esc_html__('Content Width', 'fortis'),
                    'type'      => Controls_Manager::SELECT,
                    'options'   => [
                        ''            => esc_html__('Default', 'fortis'),
                        'start'       => esc_html__('Full to Start', 'fortis'),
                        'end'         => esc_html__('Full to End', 'fortis'),
                        'start-large' => esc_html__('Full to Start (Large)', 'fortis'),
                        'end-large'   => esc_html__('Full to End (Large)', 'fortis'),
                        'start-xlarge' => esc_html__('Full to Start (Extra Large)', 'fortis'),
                        'end-xlarge'   => esc_html__('Full to End (Extra Large)', 'fortis')
                    ],
                    'prefix_class' => 'cms-swiper-full-'
                ]
            );
            $widget->add_control(
                'item_shadow',
                [
                    'label'     => esc_html__('Item Shadow?', 'fortis'),
                    'type'      => Controls_Manager::SELECT,
                    'options'   => [
                        'yes' => esc_html__('Yes', 'fortis'),
                        'no'   => esc_html__('No', 'fortis')
                    ],
                    'default' => 'no',
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class'   => 'cms-carousel-item-shadow-',
                    'separator'      => 'after'
                ]
            );

            $slides_to_show = range(1, 10);
            $slides_to_show = array_combine($slides_to_show, $slides_to_show);
            $widget->add_responsive_control(
                'slides_to_show',
                [
                    'label' => esc_html__('Slides to Show', 'fortis'),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                            '' => esc_html__('Default', 'fortis'),
                        ] + $slides_to_show,
                    'frontend_available' => true,
                ]
            );

            $widget->add_responsive_control(
                'slides_to_scroll',
                [
                    'label' => esc_html__('Slides to Scroll', 'fortis'),
                    'type' => Controls_Manager::SELECT,
                    'description' => esc_html__('Set how many slides are scrolled per swipe.', 'fortis'),
                    'options' => [
                            '' => esc_html__('Default', 'fortis'),
                        ] + $slides_to_show,
                    'condition' => [
                        'slides_to_show!' => '1',
                    ],
                    'frontend_available' => true,
                ]
            );

            $widget->add_responsive_control(
                'space_between',
                [
                    'label' => esc_html__('Space Between', 'fortis'),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 40,
                    ],
                    'condition' => [
                        'slides_to_show!' => '1',
                    ],
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'arrows',
                [
                    'label' => esc_html__('Show Arrows', 'fortis'),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'dots',
                [
                    'label' => esc_html__('Show Dots', 'fortis'),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'lazyload',
                [
                    'label' => esc_html__('Lazyload', 'fortis'),
                    'type' => Controls_Manager::SWITCHER,
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'autoplay',
                [
                    'label' => esc_html__('Autoplay', 'fortis'),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'pause_on_hover',
                [
                    'label' => esc_html__('Pause on Hover', 'fortis'),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                    'condition' => [
                        'autoplay' => 'yes',
                    ],
                ]
            );

            $widget->add_control(
                'pause_on_interaction',
                [
                    'label' => esc_html__('Pause on Interaction', 'fortis'),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                    'condition' => [
                        'autoplay' => 'yes',
                    ],
                ]
            );

            $widget->add_control(
                'autoplay_speed',
                [
                    'label' => esc_html__('Autoplay Speed', 'fortis'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 5000,
                    'condition' => [
                        'autoplay' => 'yes',
                    ],
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'infinite',
                [
                    'label' => esc_html__('Infinite Loop', 'fortis'),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'effect',
                [
                    'label' => esc_html__('Effect', 'fortis'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'slide',
                    'options' => [
                        'slide' => esc_html__('Slide', 'fortis'),
                        'fade' => esc_html__('Fade', 'fortis'),
                    ],
                    'condition' => [
                        'slides_to_show' => '1',
                    ],
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'speed',
                [
                    'label' => esc_html__('Animation Speed', 'fortis'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 500,
                    'render_type' => 'none',
                    'frontend_available' => true,
                ]
            );

        $widget->end_controls_section();
        // Carousel Section End
        // Content Tab End
    }
}
