<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;

if (!function_exists('fortis_widget_cms_progressbar_register_controls')) {
    add_action('etc_widget_cms_progressbar_register_controls', 'fortis_widget_cms_progressbar_register_controls', 10, 1);
    function fortis_widget_cms_progressbar_register_controls($widget)
    {
        // Content Tab Start

        // Progressbar Section Start
        $widget->start_controls_section(
            'section_progressbar',
            [
                'label' => esc_html__('Progressbar Content', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label'       => esc_html__( 'Title', 'fortis' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your title', 'fortis' ),
                'default'     => esc_html__( 'My Skill', 'fortis' ),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'percent',
            [
                'label'       => esc_html__( 'Percentage', 'fortis' ),
                'type'        => \Elementor\Controls_Manager::SLIDER,
                'default'     => [
                    'size' => 80,
                    'unit' => '%',
                ],
                'label_block' => true,
            ]
        );

        $widget->add_control(
            'progressbar_list',
            [
                'label' => esc_html__('List', 'fortis'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => esc_html__('My Skill', 'fortis'),
                        'percent' => [
                            'size' => 80,
                            'unit' => '%',
                        ],
                    ],
                    [
                        'title' => esc_html__('My Skill', 'fortis'),
                        'percent' => [
                            'size' => 80,
                            'unit' => '%',
                        ],
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );
        $widget->end_controls_section(); // Progressbar Section End

        // Style Section Start
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
            'title_color',
            [
                'label'   => esc_html__('Title Color', 'fortis'),
                'type'    => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-progress-bar-title' => 'color: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'   => esc_html__('Title Typography', 'fortis'),
                'name' => 'title_typography',
                'selector'     => '{{WRAPPER}} .cms-progress-bar-title',
            ]
        );
        $widget->add_control(
            'progressbar_color',
            [
                'label'   => esc_html__('Progress Bar Color', 'fortis'),
                'type'    => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-progress-wrap' => 'background-color: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );
        $widget->add_control(
            'progress_color',
            [
                'label'   => esc_html__('Progress Color', 'fortis'),
                'type'    => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-progress-bar' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $widget->end_controls_section();
        // Style Section End
        
        // Content Tab End

    }
}
