<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if (!function_exists('fortis_widget_cms_quickcontact_register_controls')) {
    add_action('etc_widget_cms_quickcontact_register_controls', 'fortis_widget_cms_quickcontact_register_controls', 10, 1);
    function fortis_widget_cms_quickcontact_register_controls($widget)
    {
        // Layout Settings
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__( 'Layout', 'fortis' ),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_responsive_control(
                'align',
                [
                    'label'        => esc_html__( 'Alignment', 'fortis' ),
                    'type'         => Controls_Manager::CHOOSE,
                    'control_type' => 'responsive',
                    'options'      => [
                        'start'    => [
                            'title' => esc_html__( 'Left', 'fortis' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center'  => [
                            'title' => esc_html__( 'Center', 'fortis' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'end'   => [
                            'title' => esc_html__( 'Right', 'fortis' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__( 'Justified', 'fortis' ),
                            'icon'  => 'eicon-text-align-justify',
                        ],
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'text%s-'
                ]
            );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_quickcontact/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_quickcontact/layout/2.jpg'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_quickcontact/layout/3.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-eqc cms-eqc-'
                ]
            );
        $widget->end_controls_section();

        // Title Section Start
        $widget->start_controls_section(
            'title_section',
            [
                'label'     => esc_html__('Title', 'fortis'),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['1','2']
                ]
            ]
        );
        $widget->add_control(
            'title',
            [
				'label'       => '',
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Enter your title', 'fortis')
            ]
        );
        $widget->add_control(
            'title_color',
            [
                'label' => esc_html__('Title Color', 'fortis'),
                'type'  => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cms-title' => 'color: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );
        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__('Title Typography', 'fortis'),
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .cms-title',
            ]
        );
        $widget->end_controls_section(); 
        // Address Section Start
        $widget->start_controls_section(
            'address_section',
            [
                'label' => esc_html__('Address', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'address',
            [
				'label'       => '',
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Enter your address', 'fortis')
            ]
        );

            $widget->add_control(
                'icon_add_color',
                [
                    'label' => esc_html__('Icon Address Color', 'fortis'),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-address .cms-icon' => 'color: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $widget->add_control(
                'address_color',
                [
                    'label' => esc_html__('Address Color', 'fortis'),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-address' => 'color: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $widget->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Address Typography', 'fortis'),
                    'name'     => 'address_typography',
                    'selector' => '{{WRAPPER}} .cms-address',
                ]
        );
        $widget->end_controls_section();
        // Email Section Start
        $widget->start_controls_section(
            'email_section',
            [
                'label' => esc_html__('Email', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'email_title',
                [
                    'label'       => esc_html__('Email Title','fortis'),
                    'type'        => Controls_Manager::TEXT,
                    'placeholder' => esc_html__('Enter title', 'fortis')
                ]
            );
            $widget->add_control(
                'email',
                [
    				'label'       => '',
    				'type'        => Controls_Manager::TEXTAREA,
    				'placeholder' => esc_html__('Enter your email', 'fortis')
                ]
            );

            $widget->add_control(
                'icon_email_color',
                [
                    'label' => esc_html__('Icon Email Color', 'fortis'),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-email .cms-icon' => 'color: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $widget->add_control(
                'email_color',
                [
                    'label' => esc_html__('Email Color', 'fortis'),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-email' => 'color: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $widget->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Email Typography', 'fortis'),
                    'name'     => 'email_typography',
                    'selector' => '{{WRAPPER}} .cms-email',
                ]
            );
        $widget->end_controls_section();
        // Phone Section Start
        $widget->start_controls_section(
            'phone_section',
            [
                'label' => esc_html__('Phone Settings', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'phone_title',
                [
                    'label'       => esc_html__('Phone Title','fortis'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__('Enter title', 'fortis'),
                    'default'     => 'Customer Service',  
                    'condition'   => [
                        'layout'  => ['3']
                    ]
                ]
            );
            $widget->add_control(
                'phone',
                [
    				'label'       => esc_html__('Phone Number','fortis'),
    				'type'        => Controls_Manager::TEXT,
    				'placeholder' => esc_html__('Enter number', 'fortis')
                ]
            );
            $widget->add_control(
                'icon_phone_color',
                [
                    'label' => esc_html__('Icon Phone Color', 'fortis'),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-phone .cms-icon' => 'color: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $widget->add_control(
                'phone_color',
                [
                    'label' => esc_html__('Phone Color', 'fortis'),
                    'type'  => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-phone' => 'color: {{VALUE}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $widget->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'label'    => esc_html__('Phone Typography', 'fortis'),
                    'name'     => 'phone_typography',
                    'selector' => '{{WRAPPER}} .cms-phone',
                ]
            );
        $widget->end_controls_section();
        // Style Section
        $widget->start_controls_section(
            'show_hide_title_section',
            [
                'label' => esc_html__('Title Settings', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout' => ['3']
                ]
            ]
        );
	        fortis_add_hidden_device_controls($widget, [
                'prefix' => 'title_',
            ]);
        $widget->end_controls_section(); 
    }
}
