<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;

if (!function_exists('fortis_widget_cms_service_grid_register_controls')) {
    add_action('etc_widget_cms_service_grid_register_controls', 'fortis_widget_cms_service_grid_register_controls', 10, 1);
    function fortis_widget_cms_service_grid_register_controls($widget)
    {
        // Layout Settings
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis' ),
                'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__('Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '2',
                    'options' => [
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/layout/2.jpg'
                        ],
                        '6' => [
                            'label' => esc_html__( 'Layout 6', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/layout/6.jpg'
                        ],
                        '8' => [
                            'label' => esc_html__( 'Layout 8', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/layout/8.jpg'
                        ],
                        '12' => [
                            'label' => esc_html__( 'Layout 12', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/layout/12.jpg'
                        ],
                        '16' => [
                            'label' => esc_html__( 'Layout 16', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/layout/16.jpg'
                        ],
                        '18' => [
                            'label' => esc_html__( 'Layout 18', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/layout/18.jpg'
                        ],
                        '19' => [
                            'label' => esc_html__( 'Layout 19', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/layout/19.jpg'
                        ],
                        '22' => [
                            'label' => esc_html__( 'Layout 22', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/layout/22.jpg'
                        ],
                        '24' => [
                            'label' => esc_html__( 'Layout 24', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/layout/24.jpg'
                        ],
                        '27' => [
                            'label' => esc_html__( 'Layout 27', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/layout/27.jpg'
                        ]
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-eblog cms-eblog-'
                ]
            );
        $widget->end_controls_section();

        // Post term options
        $post_term_options = etc_get_grid_term_options('cms-service');

        // Content Tab Start

        // Source Section Start
        $widget->start_controls_section(
            'source_section',
            [
                'label' => esc_html__('Source', 'fortis'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'source',
            [
                'label' => esc_html__('Select Categories', 'fortis'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $post_term_options,
            ]
        );
        $widget->add_control(
            'orderby',
            [
                'label'   => esc_html__('Order By', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date'   => esc_html__('Date', 'fortis'),
                    'ID'     => esc_html__('ID', 'fortis'),
                    'author' => esc_html__('Author', 'fortis'),
                    'title'  => esc_html__('Title', 'fortis'),
                    'rand'   => esc_html__('Random', 'fortis'),
                ],
            ]
        );
        $widget->add_control(
            'order',
            [
                'label'   => esc_html__('Sort Order', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'desc' => esc_html__('Descending', 'fortis'),
                    'asc'  => esc_html__('Ascending', 'fortis'),
                ],
            ]
        );
        $widget->add_control(
            'limit',
            [
                'label'   => esc_html__('Total items', 'fortis'),
                'type'    => Controls_Manager::NUMBER,
                'default' => '6',
            ]
        );
        $widget->end_controls_section();
        // Source Section End

        // Grid Section Start
        $widget->start_controls_section(
            'grid_section',
            [
                'label' => esc_html__('Grid', 'fortis'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $widget->add_control(
            'filter',
            [
                'label'   => esc_html__('Filter on Masonry', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'true'  => esc_html__('Enable', 'fortis'),
                    'false' => esc_html__('Disable', 'fortis'),
                ],
                'default' => 'false',
            ]
        );
        $widget->add_control(
            'filter_default_title',
            [
                'label'     => esc_html__('Filter Default Title', 'fortis'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('All', 'fortis'),
                'condition' => [
                    'filter' => 'yes',
                ],
            ]
        );
        $widget->add_control(
            'filter_alignment',
            [
                'label'   => esc_html__('Filter Alignment', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'center' => esc_html__('Center', 'fortis'),
                    'left'   => esc_html__('Left', 'fortis'),
                    'right'  => esc_html__('Right', 'fortis'),
                ],
                'default'   => 'center',
                'condition' => [
                    'filter' => 'yes',
                ],
            ]
        );
        $widget->add_control(
            'pagination_type',
            [
                'label'   => esc_html__('Pagination Type', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'pagination' => esc_html__('Pagination', 'fortis'),
                    'loadmore'   => esc_html__('Loadmore', 'fortis'),
                    'false'      => esc_html__('Disable', 'fortis'),
                ],
                'default' => 'false',
            ]
        );
        $widget->add_responsive_control(
            'col',
            [
                'label'        => esc_html__('Columns', 'fortis'),
                'type'         => Controls_Manager::SELECT,
                'default'      => '',
                'default_args' => [
                    'tablet' => '',
                    'mobile' => ''
                ],
                'options' => [
                    '' => esc_html__('Default', 'fortis'),
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ]
            ]
        );
        $widget->end_controls_section();
        // Grid Section End

        // Display Section Start
        $widget->start_controls_section(
            'display_section',
            [
                'label' => esc_html__('Display', 'fortis'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'    => 'thumbnail',
                'default' => 'custom',
            ]
        );
        $widget->add_control(
            'num_words',
            [
                'label'       => esc_html__('Excerpt Length', 'fortis'),
                'type'        => Controls_Manager::NUMBER,
                'default'     => '',
                'placeholder' => '25',
                'separator'   => 'after',
            ]
        );

        $widget->add_control(
            'readmore_text',
            [
                'label'       => esc_html__('Readmore Text', 'fortis'),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Read More','fortis'),
            ]
        );
        
        $widget->end_controls_section();
        // Display Section End

        // Content Tab End
    }
}
