<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if (!function_exists('fortis_widget_cms_single_image_register_controls')) {
    add_action('etc_widget_cms_single_image_register_controls', 'fortis_widget_cms_single_image_register_controls', 10, 1);
    function fortis_widget_cms_single_image_register_controls($widget)
    {
        // Content Tab Start

        // single_image Section Start
        $widget->start_controls_section(
            'section_single_image',
            [
                'label' => esc_html__('Single Image', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'image',
            [
                'label' => esc_html__( 'Image', 'fortis' ),
                'type'  => \Elementor\Controls_Manager::MEDIA,
            ]
        );
        $widget->add_control(
            'img_link',
            [
                'label' => esc_html__( 'Link', 'fortis' ),
                'type'  => \Elementor\Controls_Manager::URL,
            ]
        );
        $widget->add_control(
            'img_max_height',
            [
                'label'        => esc_html__( 'Max Height', 'fortis' ),
                'type'         => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units'   => [ 'px' ],
                'range'        => [
                    'px' => [
                        'min' => 50,
                        'max' => 2000,
                    ],
                ],
                'selectors'    => [
                    '{{WRAPPER}} .cms-single-image img' => 'max-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $widget->add_control(
            'align',
            [
                'label'        => esc_html__( 'Alignment', 'fortis' ),
                'type'         => \Elementor\Controls_Manager::CHOOSE,
                'control_type' => 'responsive',
                'options'      => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'fortis' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'fortis' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'fortis' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                ],
                'selectors'    => [
                    '{{WRAPPER}} .cms-single-image' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $widget->end_controls_section(); // single_image Section End

        // Content Tab End

    }
}
