<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;

if (!function_exists('fortis_widget_cms_slider_register_controls')) {
    add_action('etc_widget_cms_slider_register_controls', 'fortis_widget_cms_slider_register_controls', 10, 1);
    function fortis_widget_cms_slider_register_controls($widget)
    {
        // Layout Tab Start

        // Layout Section Start
        $widget->start_controls_section('layout_section', [
            'label' => esc_html__('Layout', 'fortis'),
            'tab' => Controls_Manager::TAB_LAYOUT,
        ]);
        $widget->add_control('header_transparent', [
            'label'              => esc_html__('Header Transparent', 'fortis'),
            'type'               => Controls_Manager::SWITCHER,
            'default'            => '',
            'prefix_class'       => 'cms-eslider-header-transparent-',
            'description'        => esc_html__('Make arrows alignment middle when have Header Transparent','fortis')   
        ]);
        $widget->add_control('layout', [
            'label'   => esc_html__('Templates', 'fortis'),
            'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
            'default' => '1',
            'options' => [
                '1' => [
                    'label' => esc_html__('Layout 1', 'fortis'),
                    'image' =>
                        get_template_directory_uri().'/elementor/templates/widgets/cms_slider/layout/1.jpg',
                ],
                '2' => [
                    'label' => esc_html__('Layout 2', 'fortis'),
                    'image' =>
                        get_template_directory_uri().'/elementor/templates/widgets/cms_slider/layout/2.jpg',
                ],
                '3' => [
                    'label' => esc_html__('Layout 3', 'fortis'),
                    'image' =>
                        get_template_directory_uri().'/elementor/templates/widgets/cms_slider/layout/3.jpg',
                ],
                '4' => [
                    'label' => esc_html__('Layout 4', 'fortis'),
                    'image' =>
                        get_template_directory_uri().'/elementor/templates/widgets/cms_slider/layout/4.jpg',
                ],
                '5' => [
                    'label' => esc_html__('Layout 5', 'fortis'),
                    'image' =>
                        get_template_directory_uri().'/elementor/templates/widgets/cms_slider/layout/5.jpg',
                ]
            ],
            'dynamic' => [
                'active' => true
            ],
            'style_transfer' => true,
            'prefix_class' => 'cms-eslider cms-eslider-'
        ]);
        $widget->end_controls_section();
        // Layout Section End

        // Layout Tab End

        // Content Tab Start

        // Slider List Section Start
        $widget->start_controls_section('slider_list_section', [
            'label' => esc_html__('Slider List', 'fortis'),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);

        $repeater = new Repeater();

        $repeater->add_control(
            'image',
            [
                'label'       => esc_html__('Slide Image', 'fortis'),
                'type'        => Controls_Manager::MEDIA,
                'label_block' => true,
                'default'     => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label'       => esc_html__('Title', 'fortis'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => esc_html__('This is the title', 'fortis'),
                'placeholder' => esc_html__('Enter your title', 'fortis'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'subtitle',
            [
                'label'       => esc_html__('Subtitle', 'fortis'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => esc_html__('This is the subtitle', 'fortis'),
                'placeholder' => esc_html__('Enter your subtitle', 'fortis'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label'       => esc_html__('Description', 'fortis'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => esc_html__('This is the description', 'fortis'),
                'placeholder' => esc_html__('Enter your description', 'fortis'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'button_primary',
            [
                'label'       => esc_html__('Button Primary', 'fortis'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('Button Primary', 'fortis'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'button_primary_type',
            [
                'label'   => esc_html__('Link Type', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'custom' => esc_html__('Custom', 'fortis'),
                    'page'   => esc_html__('Page', 'fortis'),
                ],
                'default' => 'custom',
                'condition' => [
                    'button_primary!' => ''
                ]
            ]
        );
        $repeater->add_control(
            'button_primary_page_link',
            [
                'label'   => esc_html__('Select Page', 'fortis'),
                'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                'post_type' => [
                    'page'
                ],
                'multiple'    => false,
                'label_block' => true,
                'condition'   => [
                    'button_primary!'     => '',
                    'button_primary_type' => 'page'
                ]
            ]
        );
        $repeater->add_control(
            'button_primary_link',
            [
                'label'       => esc_html__( 'Custom Link', 'fortis' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                'default'     => [
                    'url' => '#',
                ],
                'condition' => [
                    'button_primary!'     => '',
                    'button_primary_type' => 'custom'
                ]
            ]
        );
        // Button Secondary 
        $repeater->add_control(
            'button_secondary',
            [
                'label'       => esc_html__('Button Secondary', 'fortis'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('Button Secondary', 'fortis'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'button_secondary_type',
            [
                'label'   => esc_html__('Link Type', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'custom' => esc_html__('Custom', 'fortis'),
                    'page'   => esc_html__('Page', 'fortis'),
                ],
                'default' => 'custom',
                'condition' => [
                    'button_secondary!' => ''
                ]
            ]
        );
        $repeater->add_control(
            'button_secondary_page_link',
            [
                'label'   => esc_html__('Select Page', 'fortis'),
                'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                'post_type' => [
                    'page'
                ],
                'multiple'    => false,
                'label_block' => true,
                'condition'   => [
                    'button_secondary!'     => '',
                    'button_secondary_type' => 'page'
                ]
            ]
        );
        $repeater->add_control(
            'button_secondary_link',
            [
                'label'       => esc_html__( 'Custom Link', 'fortis' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                'default'     => [
                    'url' => '#',
                ],
                'condition' => [
                    'button_secondary!'     => '',
                    'button_secondary_type' => 'custom'
                ]
            ]
        );
        // Video  Button
        $repeater->add_control(
            'video_link',
            [
                'label'       => esc_html__( 'Button Video', 'fortis' ),
                'description' => esc_html__('Video url from  YouTube/Vimeo/Dailymotion.','fortis').' EX: https://www.youtube.com/watch?v=iYf3OgEdGmo',
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => '',
                'dynamic'     => [
                    'active' => true
                ],
                'label_block' => true
            ]
        );
        $repeater->add_control(
            'video_text',
            [
                'label'       => '',
                'description' => esc_html__('Text beside play icon','fortis'),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => 'How it works',
                'condition'   => [
                    'video_link!' => ''
                ],
                'label_block' => true
            ]
        );
        // Start List
        $widget->add_control(
            'cms_slides',
            [
                'label' => esc_html__('Slides', 'fortis'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'title'    => esc_html__('Providing Future Smart Solutions & High Technology', 'fortis'),
                        'subtitle' => esc_html__(
                            'Individually Assess Each Plan And Offer Optimal Solutions!', 'fortis'
                        ),
                        'description' => 'Our Group is recognized as one of the World\'s leading Industry Corporation serving an impressive list of long-term clients with experience and expertise.',
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'title'    => esc_html__('Global Standards In Manufacturing', 'fortis'),
                        'subtitle' => esc_html__(
                            'Utilising Latest Processing Solutions With Decades Of Work Experience.', 'fortis'
                        ),
                        'description' => 'Our worldwide presence ensures timeliness, cost efficiency and compliance adherence required to ensure your serving you with great expertise as one of the World\'s leading Corporation diversified construction management.',
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );
        $widget->end_controls_section();
        // Slider List Section End

        // Carousel Section Start
        $widget->start_controls_section(
            'carousel_section',
            [
                'label' => esc_html__('Carousel', 'fortis'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $widget->add_responsive_control(
            'slides_height',
            [
                'label'   => esc_html__( 'Slide Height', 'fortis' ),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 900,
                'min'     => 100,
                'max'     => 2000,
                'selectors' => [
                    '{{WRAPPER}} .cms-carousel' => 'height: {{VALUE}}px;',
                ],
            ]
        );

        $slides_to_show = range(1, 3);
        $slides_to_show = array_combine($slides_to_show, $slides_to_show);
        $widget->add_responsive_control(
            'slides_to_show',
            [
                'label'   => esc_html__('Slides to Show', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                        '' => esc_html__('Default', 'fortis'),
                    ] + $slides_to_show,
                'default'        => '1',
                'tablet_default' => '1',
                'mobile_default' => '1',
                'frontend_available' => true
            ]
        );

        $widget->add_responsive_control(
            'slides_to_scroll',
            [
                'label' => esc_html__('Slides to Scroll', 'fortis'),
                'type' => Controls_Manager::SELECT,
                'description' => esc_html__('Set how many slides are scrolled per swipe.', 'fortis'),
                'options' => [
                        '' => esc_html__('Default', 'fortis'),
                    ] + $slides_to_show,
                'condition' => [
                    'slides_to_show!' => '1',
                ],
                'frontend_available' => true
            ]
        );

        $widget->add_responsive_control(
            'space_between',
            [
                'label' => esc_html__('Space Between', 'fortis'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 30,
                ],
                'condition' => [
                    'slides_to_show!' => '1',
                ],
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'arrows',
            [
                'label'              => esc_html__('Show Arrows', 'fortis'),
                'type'               => Controls_Manager::SWITCHER,
                'default'            => 'yes',
                'frontend_available' => true,
            ]
        );
        $widget->add_control(
            'dots',
            [
                'label'              => esc_html__('Show Dots', 'fortis'),
                'type'               => Controls_Manager::SWITCHER,
                'default'            => 'yes',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'lazyload',
            [
                'label' => esc_html__('Lazyload', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'pause_on_hover',
            [
                'label' => esc_html__('Pause on Hover', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $widget->add_control(
            'pause_on_interaction',
            [
                'label' => esc_html__('Pause on Interaction', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $widget->add_control(
            'autoplay_speed',
            [
                'label' => esc_html__('Autoplay Speed', 'fortis'),
                'type' => Controls_Manager::NUMBER,
                'default' => 5000,
                'condition' => [
                    'autoplay' => 'yes',
                ],
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'infinite',
            [
                'label' => esc_html__('Infinite Loop', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'effect',
            [
                'label' => esc_html__('Effect', 'fortis'),
                'type' => Controls_Manager::SELECT,
                'default' => 'slide',
                'options' => [
                    'slide' => esc_html__('Slide', 'fortis'),
                    'fade' => esc_html__('Fade', 'fortis'),
                ],
                'condition' => [
                    'slides_to_show' => '1',
                ],
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'speed',
            [
                'label' => esc_html__('Animation Speed', 'fortis'),
                'type' => Controls_Manager::NUMBER,
                'default' => 500,
                'render_type' => 'none',
                'frontend_available' => true,
            ]
        );

        $widget->end_controls_section();
        // Carousel Section End
        // Content Tab End

        // Style Tab Start
        // General Style Section Start
        $widget->start_controls_section(
            'general_style_section',
            [
                'label' => esc_html__('General', 'fortis'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control('overlay_style', [
            'label' => esc_html__('Overlay Style', 'fortis'),
            'type' => Controls_Manager::SELECT,
            'options' => [
                '1' => 'Style 1',
                '2' => 'Style 2',
            ],
            'default' => '1',
            'dynamic' => [
                'active' => true
            ],
            'style_transfer' => true,
            'prefix_class'   => 'cms-eslider-overlay-'
        ]);

        $widget->end_controls_section();
        // General Style Section End
        // Subtitle Style Section Start
        $widget->start_controls_section(
            'subtitle_style_section',
            [
                'label' => esc_html__('Subtitle', 'fortis'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'subtitle_animation',
            [
                'label'              => esc_html__('Animation', 'fortis'),
                'type'               => \Elementor\Controls_Manager::ANIMATION,
                'default'            => 'fadeInLeft',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'subtitle_animation_delay',
            [
                'label'              => esc_html__('Animation Delay', 'fortis'),
                'type'               => Controls_Manager::NUMBER,
                'min'                => 50,
                'step'               => 50,
                'default'            => 500,
                'frontend_available' => true,
            ]
        );
        fortis_add_hidden_device_controls($widget, ['prefix' => 'subtitle_']);
        $widget->end_controls_section();
        // Subtitle Style Section End

        // Title Style Section Start
        $widget->start_controls_section(
            'title_style_section',
            [
                'label' => esc_html__('Title', 'fortis'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'title_animation',
            [
                'label'              => esc_html__('Animation', 'fortis'),
                'type'               => \Elementor\Controls_Manager::ANIMATION,
                'default'            => 'fadeInLeft',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'title_animation_delay',
            [
                'label'              => esc_html__('Animation Delay', 'fortis'),
                'type'               => Controls_Manager::NUMBER,
                'min'                => 50,
                'step'               => 50,
                'default'            => 600,
                'frontend_available' => true,
            ]
        );
        fortis_add_hidden_device_controls($widget, ['prefix' => 'title_']);
        $widget->end_controls_section();
        // Title Style Section End

        // Description Style Section Start
        $widget->start_controls_section(
            'description_style_section',
            [
                'label' => esc_html__('Description', 'fortis'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'description_animation',
            [
                'label'              => esc_html__('Animation', 'fortis'),
                'type'               => \Elementor\Controls_Manager::ANIMATION,
                'default'            => 'fadeInLeft',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'description_animation_delay',
            [
                'label'              => esc_html__('Animation Delay', 'fortis'),
                'type'               => Controls_Manager::NUMBER,
                'min'                => 50,
                'step'               => 50,
                'default'            => 700,
                'frontend_available' => true,
            ]
        );
        fortis_add_hidden_device_controls($widget, ['prefix' => 'desc_']);
        $widget->end_controls_section();
        // Description Style Section End

        // Button Primary Style Section Start
        $widget->start_controls_section(
            'button_primary_style_section',
            [
                'label' => esc_html__('Button Primary', 'fortis'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'button_primary_animation',
            [
                'label'              => esc_html__('Animation', 'fortis'),
                'type'               => \Elementor\Controls_Manager::ANIMATION,
                'default'            => 'fadeInLeft',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'button_primary_animation_delay',
            [
                'label'              => esc_html__('Animation Delay', 'fortis'),
                'type'               => Controls_Manager::NUMBER,
                'min'                => 50,
                'step'               => 50,
                'default'            => 800,
                'frontend_available' => true,
            ]
        );
        fortis_add_hidden_device_controls($widget, ['prefix' => 'btn1_']);
        $widget->end_controls_section();
        // Button Primary Style Section End

        // Button Secondary Style Section Start
        $widget->start_controls_section(
            'button_secondary_style_section',
            [
                'label' => esc_html__('Button Secondary', 'fortis'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'button_secondary_animation',
            [
                'label'              => esc_html__('Animation', 'fortis'),
                'type'               => \Elementor\Controls_Manager::ANIMATION,
                'default'            => 'fadeInLeft',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'button_secondary_animation_delay',
            [
                'label'              => esc_html__('Animation Delay', 'fortis'),
                'type'               => Controls_Manager::NUMBER,
                'min'                => 50,
                'step'               => 50,
                'default'            => 900,
                'frontend_available' => true,
            ]
        );
        fortis_add_hidden_device_controls($widget, ['prefix' => 'btn2_']);
        $widget->end_controls_section();
        // Button Secondary Style Section End

        // Button Video Style Section Start
        $widget->start_controls_section(
            'button_video_style_section',
            [
                'label' => esc_html__('Button Video', 'fortis'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'button_video_animation',
            [
                'label'              => esc_html__('Animation', 'fortis'),
                'type'               => \Elementor\Controls_Manager::ANIMATION,
                'default'            => 'fadeInLeft',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'button_video_animation_delay',
            [
                'label'              => esc_html__('Animation Delay', 'fortis'),
                'type'               => Controls_Manager::NUMBER,
                'min'                => 50,
                'step'               => 50,
                'default'            => 1000,
                'frontend_available' => true,
            ]
        );
        fortis_add_hidden_device_controls($widget, ['prefix' => 'btn_video_']);
        $widget->end_controls_section();
        // Button Video Style Section End

        // Style Tab End
    }
}
