<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;

if (!function_exists('fortis_widget_cms_social_icons_register_controls')) {
    add_action('etc_widget_cms_social_icons_register_controls', 'fortis_widget_cms_social_icons_register_controls', 10, 1);
    function fortis_widget_cms_social_icons_register_controls($widget)
    {
        // Content Tab Start

        // icon Section Start
        $widget->start_controls_section(
            'section_icon',
            [
                'label' => esc_html__('Icons', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'social_icon',
            [
                'label'   => esc_html__( 'Icon', 'fortis' ),
                'type'    => Controls_Manager::ICONS,
                'default' => [
                    'value'   => 'cmsi-star',
                    'library' => 'cmsi',
                ]
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label'   => esc_html__( 'Title', 'fortis' ),
                'type'    => Controls_Manager::TEXT,
                'default' => 'Social Title',
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label'   => esc_html__( 'Link', 'fortis' ),
                'type'    => Controls_Manager::URL,
                'default' => [
                    'is_external' => 'true'
                ],
                'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
            ]
        );

        $repeater->add_control(
            'item_icon_color',
            [
                'label'   => esc_html__( 'Color', 'fortis' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default' => esc_html__( 'Official Color', 'fortis' ),
                    'custom'  => esc_html__( 'Custom', 'fortis' ),
                ],
            ]
        );

        $repeater->add_control(
            'item_icon_primary_color',
            [
                'label' => esc_html__( 'Background Color', 'fortis' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_icon_color' => 'custom',
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.cms-social-icon i' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $repeater->add_control(
            'item_icon_secondary_color',
            [
                'label' => esc_html__( 'Icon Color', 'fortis' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'item_icon_color' => 'custom',
                ],
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.cms-social-icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} {{CURRENT_ITEM}}.cms-social-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'icons',
            [
                'label' => esc_html__('Icons', 'fortis'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'social_icon' => [
                            'value'   => 'cmsi-facebook',
                            'library' => 'cmsi',
                        ],
                        'title' => 'Facebook',
                        'link' => [
                            'is_external' => true,
                            'url' => 'https://facebook.com'
                        ]
                    ],
                    [
                        'social_icon' => [
                            'value'   => 'cmsi-twitter-circle',
                            'library' => 'cmsi',
                        ],
                        'title' => 'Twitter',
                        'link' => [
                            'is_external' => true,
                            'url' => 'https://twitter.com'
                        ]
                    ],
                    [
                        'social_icon' => [
                            'value'   => 'cmsi-linkedin-circle',
                            'library' => 'cmsi',
                        ],
                        'title' => 'LinkedIn',
                            'link' => [
                                'is_external' => true,
                                'url' => 'https://linkedin.com'
                            ]
                    ],
                ],
                'title_field' => '{{{ "<i class=\"" + social_icon.value + "\"></i>" + " " + title }}}',
            ]
        );
        $widget->end_controls_section();
        // icon Section End
        // Content Tab End

        // Style Tab Start
        // Icons Style Section Start
        $widget->start_controls_section(
            'icons_style_section',
            [
                'label' => esc_html__('Icons', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
            'icon_gap',
            [
                'label'        => esc_html__( 'Icons Gap', 'fortis' ),
                'type'         => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units'   => [ 'px' ],
                'range'        => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors'    => [
                    '{{WRAPPER}} .cms-social-icons-wrap' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $widget->add_control(
            'icon_padding',
            [
                'label'        => esc_html__( 'Icon Padding', 'fortis' ),
                'type'         => \Elementor\Controls_Manager::SLIDER,
                'control_type' => 'responsive',
                'size_units'   => [ 'px' ],
                'range'        => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors'    => [
                    '{{WRAPPER}} .cms-social-icon i' => 'padding: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $widget->add_control(
            'icon_color',
            [
                'label' => esc_html__( 'Color', 'fortis' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default' => esc_html__( 'Official Color', 'fortis' ),
                    'custom' => esc_html__( 'Custom', 'fortis' ),
                ],
            ]
        );
        $widget->add_control(
            'icon_primary_color',
            [
                'label' => esc_html__( 'Background Color', 'fortis' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'icon_color' => 'custom',
                ],
                'selectors' => [
                    '{{WRAPPER}} .cms-social-icon i' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_control(
            'icon_secondary_color',
            [
                'label' => esc_html__( 'Icon Color', 'fortis' ),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'icon_color' => 'custom',
                ],
                'selectors' => [
                    '{{WRAPPER}} .cms-social-icon i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .cms-social-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $widget->end_controls_section();
        // Icons Style Section End

        // Icons Hover Style Section Start
        $widget->start_controls_section(
            'icons_hover_style_section',
            [
                'label' => esc_html__('Icons Hover', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
            'hover_primary_color',
            [
                'label' => esc_html__( 'Background Color', 'fortis' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'condition' => [
                    'icon_color' => 'custom',
                ],
                'selectors' => [
                    '{{WRAPPER}} .cms-social-icon:hover i' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_control(
            'hover_secondary_color',
            [
                'label' => esc_html__( 'Icon Color', 'fortis' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'condition' => [
                    'icon_color' => 'custom',
                ],
                'selectors' => [
                    '{{WRAPPER}} .cms-social-icon:hover i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .cms-social-icon:hover svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'hover_animation',
            [
                'label' => esc_html__( 'Hover Animation', 'fortis' ),
                'type' => Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $widget->end_controls_section();
        // Icons Hover Style Section End

        // Icons Hover Style Section Start
        $widget->start_controls_section(
            'title_section',
            [
                'label' => esc_html__('Title', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $widget->add_control(
			'show_title',
			[
                'label'        => esc_html__( 'Show Title', 'fortis' ),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'fortis' ),
                'label_off'    => esc_html__( 'Hide', 'fortis' ),
                'return_value' => 'yes',
                'default'      => 'no',
			]
		);
        $widget->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'fortis' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'condition' => [
                    'show_title' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .cms-social-icon span' => 'color: {{VALUE}};',
                ],
            ]
        );
        $widget->add_control(
            'title_hover_color',
            [
                'label' => esc_html__( 'Title Hover Color', 'fortis' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'condition' => [
                    'show_title' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .cms-social-icon:hover span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->end_controls_section();
        // Icons Hover Style Section End
        // Style Tab End

    }
}