<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if (!function_exists('fortis_widget_cms_star_rating_register_controls')) {
    add_action('etc_widget_cms_star_rating_register_controls', 'fortis_widget_cms_star_rating_register_controls', 10, 1);
    function fortis_widget_cms_star_rating_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_star_rating/layout/1.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true
                ]
            );
        $widget->end_controls_section();
        // Content Section Start
        $widget->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );  
            $widget->add_control(
                'star_rated',
                [
                    'label'       => esc_html__( 'Star', 'fortis' ),
                    'type'        => Controls_Manager::SELECT,
                    'options'     => [
                        '0'   => '0',
                        '20'  => '1',
                        '40'  => '2',
                        '60'  => '3',
                        '80'  => '4',
                        '100' => '5',
                    ],
                    'default' => '100'
                ]
            );    
            $widget->add_control(
                'percent',
                [
                    'label'       => esc_html__( 'Percentage', 'fortis' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '99.9%',
                    'placeholder' => '99.9%'
                ]
            );
            $widget->add_control(
                'percent_text',
                [
                    'label'       => esc_html__('Percentage Text', 'fortis'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Customer Satisfaction',
                    'placeholder' => 'Customer Satisfaction'
                ]
            );
            $widget->add_control(
                'percent_text2',
                [
                    'label'   => esc_html__('Other Text', 'fortis'),
                    'type'    => Controls_Manager::TEXTAREA,
                    'default' => 'based on 750+ reviews of 6,154 Completed Projects, and 2,194 Happy Customers trust us.'
                ]
            );
        $widget->end_controls_section();

        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style', 'fortis'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $widget->add_control(
                'star_color',
                [
                    'label'     => esc_html__( 'Star Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-star-rate' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $widget->add_control(
                'star_rated_color',
                [
                    'label'     => esc_html__( 'Star Rated Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-star-rated' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $widget->add_control(
                'text_color',
                [
                    'label'     => esc_html__( 'Text Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .cms-text' => 'color: {{VALUE}};',
                    ],
                ]
            );
        $widget->end_controls_section();
    }
}
