<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;

if (!function_exists('fortis_widget_cms_support_register_controls')) {
    add_action('etc_widget_cms_support_register_controls', 'fortis_widget_cms_support_register_controls', 10, 1);
    function fortis_widget_cms_support_register_controls($widget)
    {
        // Layout Settings
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__( 'Layout', 'fortis' ),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_support/layout/1.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-support cms-support-'
                ]
            );
        $widget->end_controls_section();

        // Title Section Start
        $widget->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__('Content', 'fortis'),
                'tab'       => Controls_Manager::TAB_CONTENT
            ]
        );
        $widget->add_control(
            'title',
            [
				'label'       => esc_html__('Title','fortis'),
				'type'        => Controls_Manager::TEXTAREA,
                'default'     => 'Enter your title',
				'placeholder' => esc_html__('Enter your title', 'fortis'),
            ]
        );
        $widget->add_control(
            'description',
            [
                'label'       =>  esc_html__('Description','fortis'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => 'Enter your description',  
                'placeholder' => esc_html__('Enter your description', 'fortis')
            ]
        );
            $widget->add_control(
                'phone',
                [
                    'label'       =>  esc_html__('Phone','fortis'),
                    'type'        => Controls_Manager::URL,
                    'default'     => [
                        'url'         => '02 01061245741',
                        'is_external' => true
                    ]
                ]
            );
        $widget->add_control(
            'btn_text',
            [
                'label'       => esc_html__( 'Button', 'fortis' ),
                'description' => esc_html__( 'Button Text', 'fortis' ),  
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('Talk To An Expert', 'fortis' ),
                'placeholder' => esc_html__('Talk To An Expert', 'fortis' ),
                'label_block' => true  
            ]
        );
            $widget->add_control(
                'btn_type',
                [
                    'label'   => esc_html__('Link Type', 'fortis'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'fortis'),
                        'page'   => esc_html__('Page', 'fortis'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'btn_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'page_link',
                [
                    'label'   => esc_html__('Select Page', 'fortis'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'btn_text!' => '',
                        'btn_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'custom_link',
                [
                    'label'       => esc_html__( 'Link', 'fortis' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'btn_text!' => '',
                        'btn_type' => 'custom'
                    ]
                ]
            );
            $widget->add_control(
                'btn_hover',
                [
                    'label'       => esc_html__( 'Hover Color', 'fortis' ),
                    'type'        => Controls_Manager::SELECT,
                    'options'     => [
                        'primary' => esc_html__('Primary Color','fortis'),
                        'secondary' => esc_html__('Secondary Color','fortis')
                    ],
                    'default' => 'secondary',
                    'condition' => [
                        'btn_text!' => ''
                    ]
                ]
            );
        $widget->end_controls_section();
        $widget->start_controls_section(
            'banner_section',
            [
                'label' => esc_html__('Banner Settings','fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );
            $widget->add_control(
                'banner_gradient',
                [
                    'label'        => esc_html__( 'Gradient Style', 'fortis' ),
                    'type'         => \Elementor\Controls_Manager::SELECT,
                    'options'      => array(
                        ''  => esc_html__( 'None', 'fortis' ),
                        '1' => esc_html__( 'Primary - Top to Bottom', 'fortis' ),
                        '2' => esc_html__( 'Secondary - Top to Bottom', 'fortis' ),
                        '3' => esc_html__( 'Primary - Bottom to Top', 'fortis' ),
                        '4' => esc_html__( 'Secondary - Bottom to Top', 'fortis' ),
                        '5' => esc_html__( 'Secondary - Bottom to Top #2', 'fortis' ),
                        '6' => esc_html__( 'Primary - Bottom to Top #2', 'fortis' ),
                        '7' => esc_html__( 'Gray - Bottom to Top', 'fortis' ),
                        '8' => esc_html__( 'Secondary - Bottom to Top #3', 'fortis' ),
                        '9' => esc_html__( 'Secondary - Bottom to Top #4', 'fortis' ),
                    ),
                    'default'   => '1',
                    'separator' => 'before',
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                ]
            );
            $widget->add_control(
                'banner',
                [
                    'label'   => esc_html__( 'Banner', 'fortis' ),
                    'type'    => \Elementor\Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ]
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'banner',
                    'label'   => esc_html__('Image Size','fortis'),
                    'default' => 'custom',
                    'condition' => [
                        'banner[url]!' => ''
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
