<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Group_Control_Image_Size;

if (!function_exists('fortis_widget_cms_teams_register_controls')) {
    add_action('etc_widget_cms_teams_register_controls', 'fortis_widget_cms_teams_register_controls', 10, 1);
    function fortis_widget_cms_teams_register_controls($widget)
    {
        // Layout Tab Start
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
        $widget->add_control(
            'layout_mode',
            [
                'label' => esc_html__( 'Layout Mode', 'fortis' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'carousel' => esc_html__( 'Carousel', 'fortis' ),
                    'grid' => esc_html__( 'Grid', 'fortis' ),
                ],
                'default' => 'carousel',
            ]
        );
        $widget->add_control(
            'layout',
            [
                'label'   => esc_html__( 'Templates', 'fortis' ),
                'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                'options' => [
                    '1' => [
                        'label' => esc_html__( 'Layout 1', 'fortis' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_teams/layout/1.jpg'
                    ],
                    '2' => [
                        'label' => esc_html__( 'Layout 2', 'fortis' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_teams/layout/2.jpg'
                    ],
                ],
                'default' => '1',
                'dynamic' => [
                    'active' => true
                ],
                'style_transfer' => true,
                'prefix_class' => 'cms-eteam-'
            ]
        );

        $widget->end_controls_section();
        // Layout Tab End

        // Content Tab Start
        // List Section Start
        $widget->start_controls_section(
            'list_section',
            [
                'label' => esc_html__('List', 'fortis'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'image',
            [
                'label'   => esc_html__('Image', 'fortis'),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label'   => esc_html__('Name', 'fortis'),
                'type'    => Controls_Manager::TEXT,
                'default' => esc_html__('Name', 'fortis'),
            ]
        );

        $repeater->add_control(
            'position',
            [
                'label'   => esc_html__('Position', 'fortis'),
                'type'    => Controls_Manager::TEXT,
                'default' => esc_html__('Position', 'fortis'),
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label'       => esc_html__('Description', 'fortis'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => '',
                'label_block' => true,
                'class'       => 'fuckc cccc',  
                'label_class'       => 'fuckc cccc'  
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label'       => esc_html__( 'Link', 'fortis' ),
                'type'        => Controls_Manager::URL,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'separator' => 'after',
            ]
        );

        for ($i = 1; $i <= 4; $i++) {
            $args = [
                'label'       => esc_html__( "Social Icon", 'fortis' ), //{$i}
                'type'        => Controls_Manager::ICONS,
                'skin'        => 'inline',
                'label_block' => false,
            ];
            if($i == 1){
                $args['default'] = [
                    'value'   => 'cmsi-facebook',
                    'library' => 'cmsi',
                ];
            }
            elseif($i == 2){
                $args['default'] = [
                    'value'   => 'cmsi-twitter',
                    'library' => 'cmsi',
                ];
            }
            elseif($i == 3){
                $args['default'] = [
                    'value'   => 'cmsi-instagram',
                    'library' => 'cmsi',
                ];
            }
            elseif($i == 4){
                $args['default'] = [
                    'value'   => 'cmsi-linkedin',
                    'library' => 'cmsi',
                ];
            }
            $repeater->add_control(
                "social_icon_{$i}",
                $args
            );

            $repeater->add_control(
                "social_link_{$i}",
                [
                    'label'       => esc_html__( "Social Link", 'fortis' ), //{$i}
                    'type'        => \Elementor\Controls_Manager::URL,
                    'placeholder' => 'https://your-link.com',
                    'options'     => [ 'url', 'is_external', 'nofollow' ],
                    'default'     => [
                        'url'         => '',
                        'is_external' => true,
                        'nofollow'    => true,
                    ],
                    'separator' => 'after',
                ]
            );
        }

        $widget->add_control(
            'teams',
            [
                'label' => esc_html__('Teams', 'fortis'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'name' => esc_html__('Name', 'fortis'),
                        'position' => esc_html__('Position', 'fortis'),
                        'link' => [
                            'url' => '#',
                            'is_external' => true,
                            'nofollow' => true,
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'name' => esc_html__('Name', 'fortis'),
                        'position' => esc_html__('Position', 'fortis'),
                        'link' => [
                            'url' => '#',
                            'is_external' => true,
                            'nofollow' => true,
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'name' => esc_html__('Name', 'fortis'),
                        'position' => esc_html__('Position', 'fortis'),
                        'link' => [
                            'url' => '#',
                            'is_external' => true,
                            'nofollow' => true,
                        ],
                    ],
                ],
                'title_field' => '{{{ name }}}',
            ]
        );
        $widget->end_controls_section();
        // List Section End
        // Image
        $widget->start_controls_section(
            'image_section',
            [
                'label' => esc_html__('Image Settings', 'fortis'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'image',
                    'label'   => esc_html__('Image Size','fortis'),
                    'default' => 'custom'
                ]
            );
        $widget->end_controls_section();
        // Carousel Section Start
        $widget->start_controls_section(
            'carousel_section',
            [
                'label' => esc_html__('Carousel Settings', 'fortis'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $slides_to_show = range(1, 10);
        $slides_to_show = array_combine($slides_to_show, $slides_to_show);
        $widget->add_responsive_control(
            'slides_to_show',
            [
                'label' => esc_html__('Slides to Show', 'fortis'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                        '' => esc_html__('Default', 'fortis'),
                    ] + $slides_to_show,
                'frontend_available' => true,
            ]
        );

        $widget->add_responsive_control(
            'slides_to_scroll',
            [
                'label' => esc_html__('Slides to Scroll', 'fortis'),
                'type' => Controls_Manager::SELECT,
                'description' => esc_html__('Set how many slides are scrolled per swipe.', 'fortis'),
                'options' => [
                        '' => esc_html__('Default', 'fortis'),
                    ] + $slides_to_show,
                'condition' => [
                    'slides_to_show!' => '1',
                ],
                'frontend_available' => true,
            ]
        );

        $widget->add_responsive_control(
            'space_between',
            [
                'label' => esc_html__('Space Between', 'fortis'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 40,
                ],
                'condition' => [
                    'slides_to_show!' => '1',
                ],
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'arrows',
            [
                'label' => esc_html__('Show Arrows', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );
        $widget->add_control(
            'dots',
            [
                'label' => esc_html__('Show Dots', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'lazyload',
            [
                'label' => esc_html__('Lazyload', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'pause_on_hover',
            [
                'label' => esc_html__('Pause on Hover', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $widget->add_control(
            'pause_on_interaction',
            [
                'label' => esc_html__('Pause on Interaction', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $widget->add_control(
            'autoplay_speed',
            [
                'label' => esc_html__('Autoplay Speed', 'fortis'),
                'type' => Controls_Manager::NUMBER,
                'default' => 5000,
                'condition' => [
                    'autoplay' => 'yes',
                ],
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'infinite',
            [
                'label' => esc_html__('Infinite Loop', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'effect',
            [
                'label' => esc_html__('Effect', 'fortis'),
                'type' => Controls_Manager::SELECT,
                'default' => 'slide',
                'options' => [
                    'slide' => esc_html__('Slide', 'fortis'),
                    'fade' => esc_html__('Fade', 'fortis'),
                ],
                'condition' => [
                    'slides_to_show' => '1',
                ],
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'speed',
            [
                'label' => esc_html__('Animation Speed', 'fortis'),
                'type' => Controls_Manager::NUMBER,
                'default' => 500,
                'render_type' => 'none',
                'frontend_available' => true,
            ]
        );

        $widget->end_controls_section();
        // Carousel Section End
        // Custom layout
        $widget->start_controls_section(
            'content_width_section',
            [
                'label'      => esc_html__('Custom Styles', 'fortis'),
                'tab'        => Controls_Manager::TAB_SETTINGS,
            ]
        );
            $widget->add_control(
                'content_width',
                [
                    'label'     => esc_html__('Content Width', 'fortis'),
                    'type'      => Controls_Manager::SELECT,
                    'options'   => [
                        ''            => esc_html__('Default', 'fortis'),
                        'start'       => esc_html__('Full to Start', 'fortis'),
                        'end'         => esc_html__('Full to End', 'fortis'),
                        'start-large' => esc_html__('Full to Start (Large)', 'fortis'),
                        'end-large'   => esc_html__('Full to End (Large)', 'fortis')
                    ],
                    'prefix_class' => 'cms-swiper-full-'
                ]
            );
            $widget->add_control(
                'item_shadow',
                [
                    'label'     => esc_html__('Item Shadow?', 'fortis'),
                    'type'      => Controls_Manager::SELECT,
                    'options'   => [
                        'yes' => esc_html__('Yes', 'fortis'),
                        'no'   => esc_html__('No', 'fortis')
                    ],
                    'default' => 'no',
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-carousel-item-shadow-',

                ]
            );
        $widget->end_controls_section();
        // Content Tab End
    }
}