<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Repeater;

if (!function_exists('fortis_widget_cms_testimonials_register_controls')) {
    add_action('etc_widget_cms_testimonials_register_controls', 'fortis_widget_cms_testimonials_register_controls', 10, 1);
    function fortis_widget_cms_testimonials_register_controls($widget)
    {
        // Layout Tab Start
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );

        $widget->add_control(
            'layout',
            [
                'label'   => esc_html__( 'Templates', 'fortis' ),
                'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                'options' => [
                    '1' => [
                        'label' => esc_html__( 'Layout 1', 'fortis' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_testimonials/layout/1.jpg'
                    ],
                    '2' => [
                        'label' => esc_html__( 'Layout 2', 'fortis' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_testimonials/layout/2.jpg'
                    ],
                    '3' => [
                        'label' => esc_html__( 'Layout 3', 'fortis' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_testimonials/layout/3.jpg'
                    ],
                    '4' => [
                        'label' => esc_html__( 'Layout 4', 'fortis' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_testimonials/layout/4.jpg'
                    ],
                    '5' => [
                        'label' => esc_html__( 'Layout 5', 'fortis' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_testimonials/layout/5.jpg'
                    ],
                    '6' => [
                        'label' => esc_html__( 'Layout 6', 'fortis' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_testimonials/layout/6.jpg'
                    ]
                ],
                'default' => '1',
                'dynamic' => [
                    'active' => true
                ],
                'style_transfer' => true,
                'prefix_class' => 'cms-ettmn cms-ettmn-'
            ]
        );

        $widget->end_controls_section();
        // Layout Tab End

        // Content Tab Start
        // Title 
        $widget->start_controls_section(
            'heading_section',
            [
                'label'     => esc_html__('Heading', 'fortis'),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['1','3']
                ]
            ]
        );  
            $widget->add_control(
                'small_title',
                [
                    'label'   => esc_html__('Small Title', 'fortis'),
                    'type'    => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Small Title', 'fortis'),
                ]
            );
            $widget->add_control(
                'title',
                [
                    'label'   => esc_html__('Title', 'fortis'),
                    'type'    => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Large Title', 'fortis')
                ]
            );
        $widget->end_controls_section();
        // List Section Start
        $widget->start_controls_section(
            'list_section',
            [
                'label' => esc_html__('List', 'fortis'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

            $repeater = new Repeater();

            $repeater->add_control(
                'image',
                [
                    'label' => esc_html__('Avatar', 'fortis'),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                ]
            );

            $repeater->add_control(
                'name',
                [
                    'label' => esc_html__('Name', 'fortis'),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('Testimonial Name', 'fortis'),
                ]
            );

            $repeater->add_control(
                'position',
                [
                    'label' => esc_html__('Position', 'fortis'),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('Testimonial Position', 'fortis'),
                ]
            );

            $repeater->add_control(
                'description',
                [
                    'label' => esc_html__('Description', 'fortis'),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Testimonial Description', 'fortis'),
                ]
            );

            $widget->add_control(
                'testimonials',
                [
                    'label' => esc_html__('Testimonials', 'fortis'),
                    'type' => \Elementor\Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'image' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'name' => esc_html__('Testimonial Name', 'fortis'),
                            'position' => esc_html__('Testimonial Position', 'fortis'),
                            'description' => esc_html__('Testimonial Description', 'fortis'),
                        ],
                        [
                            'image' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'name' => esc_html__('Testimonial Name', 'fortis'),
                            'position' => esc_html__('Testimonial Position', 'fortis'),
                            'description' => esc_html__('Testimonial Description', 'fortis'),
                        ],
                        [
                            'image' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'name' => esc_html__('Testimonial Name', 'fortis'),
                            'position' => esc_html__('Testimonial Position', 'fortis'),
                            'description' => esc_html__('Testimonial Description', 'fortis'),
                        ],
                    ],
                    'title_field' => '{{{ name }}}',
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'image',
                    'default' => 'custom',
                ]
            );
        $widget->end_controls_section();
        // List Section End
        // Content Tab End
        // Style

        $widget->start_controls_section(
            'style_section',
            [
                'label'     => esc_html__('Background', 'fortis'),
                'tab'       => Controls_Manager::TAB_SETTINGS,
                'condition' => [
                    'layout' => ['1']
                ]
            ]
        );
            $widget->add_control(
                'bg_image',
                [
                    'label' => esc_html__('Background Image', 'fortis'),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'bg_image',
                    'default' => 'custom',
                ]
            );
            $widget->add_control(
                'bg_gradient',
                [
                    'label' =>  esc_html__('Background Gradient','fortis'),
                    'type'  => Controls_Manager::SELECT,
                    'options' => array(
                        ''  => esc_html__( 'Default', 'fortis' ),
                        '1' => esc_html__( 'Primary - Top to Bottom', 'fortis' ),
                        '2' => esc_html__( 'Secondary - Top to Bottom', 'fortis' ),
                        '3' => esc_html__( 'Primary - Bottom to Top', 'fortis' ),
                        '4' => esc_html__( 'Secondary - Bottom to Top', 'fortis' ),
                        '5' => esc_html__( 'Secondary - Bottom to Top #2', 'fortis' ),
                        '6' => esc_html__( 'Primary - Bottom to Top #2', 'fortis' ),
                        '7' => esc_html__( 'Gray - Bottom to Top', 'fortis' ),
                        '8' => esc_html__( 'Secondary - Bottom to Top #3', 'fortis' ),
                        '9' => esc_html__( 'Secondary - Bottom to Top #4', 'fortis' ),
                    )
                ]
            );
        $widget->end_controls_section();
        // Carousel Section Start
        $widget->start_controls_section(
            'carousel_section',
            [
                'label' => esc_html__('Carousel', 'fortis'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $widget->add_control(
            'content_width',
            [
                'label'     => esc_html__('Content Width', 'fortis'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    ''            => esc_html__('Default', 'fortis'),
                    'start'       => esc_html__('Full to Start', 'fortis'),
                    'end'         => esc_html__('Full to End', 'fortis'),
                    'start-large' => esc_html__('Full to Start (Large)', 'fortis'),
                    'end-large'   => esc_html__('Full to End (Large)', 'fortis')
                ],
                'prefix_class' => 'cms-swiper-full-'
            ]
        );
        $widget->add_control(
            'item_shadow',
            [
                'label'     => esc_html__('Item Shadow?', 'fortis'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'yes' => esc_html__('Yes', 'fortis'),
                    'no'   => esc_html__('No', 'fortis')
                ],
                'default' => 'no',
                'dynamic' => [
                    'active' => true
                ],
                'style_transfer' => true,
                'prefix_class' => 'cms-carousel-item-shadow-',
                'separator' => 'after'
            ]
        );

        $slides_to_show = range(1, 10);
        $slides_to_show = array_combine($slides_to_show, $slides_to_show);
        $widget->add_responsive_control(
            'slides_to_show',
            [
                'label' => esc_html__('Slides to Show', 'fortis'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                        '' => esc_html__('Default', 'fortis'),
                    ] + $slides_to_show,
                'frontend_available' => true,
            ]
        );

        $widget->add_responsive_control(
            'slides_to_scroll',
            [
                'label' => esc_html__('Slides to Scroll', 'fortis'),
                'type' => Controls_Manager::SELECT,
                'description' => esc_html__('Set how many slides are scrolled per swipe.', 'fortis'),
                'options' => [
                        '' => esc_html__('Default', 'fortis'),
                    ] + $slides_to_show,
                'condition' => [
                    'slides_to_show!' => '1',
                ],
                'frontend_available' => true,
            ]
        );

        $widget->add_responsive_control(
            'space_between',
            [
                'label' => esc_html__('Space Between', 'fortis'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 30,
                ],
                'condition' => [
                    'slides_to_show!' => '1',
                ],
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'arrows',
            [
                'label' => esc_html__('Show Arrows', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );
        $widget->add_control(
            'dots',
            [
                'label' => esc_html__('Show Dots', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'lazyload',
            [
                'label' => esc_html__('Lazyload', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'pause_on_hover',
            [
                'label' => esc_html__('Pause on Hover', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $widget->add_control(
            'pause_on_interaction',
            [
                'label' => esc_html__('Pause on Interaction', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $widget->add_control(
            'autoplay_speed',
            [
                'label' => esc_html__('Autoplay Speed', 'fortis'),
                'type' => Controls_Manager::NUMBER,
                'default' => 5000,
                'condition' => [
                    'autoplay' => 'yes',
                ],
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'infinite',
            [
                'label' => esc_html__('Infinite Loop', 'fortis'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'effect',
            [
                'label' => esc_html__('Effect', 'fortis'),
                'type' => Controls_Manager::SELECT,
                'default' => 'slide',
                'options' => [
                    'slide' => esc_html__('Slide', 'fortis'),
                    'fade' => esc_html__('Fade', 'fortis'),
                ],
                'condition' => [
                    'slides_to_show' => '1',
                ],
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'speed',
            [
                'label' => esc_html__('Animation Speed', 'fortis'),
                'type' => Controls_Manager::NUMBER,
                'default' => 500,
                'render_type' => 'none',
                'frontend_available' => true,
            ]
        );

        $widget->end_controls_section();
        // Carousel Section End
    }
}
