<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\TagsModule;
use Elementor\Repeater;

if (!function_exists('fortis_widget_cms_video_player_register_controls')) {
    add_action('etc_widget_cms_video_player_register_controls', 'fortis_widget_cms_video_player_register_controls', 10, 1);
    function fortis_widget_cms_video_player_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'fortis'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'fortis' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_video_player/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_video_player/layout/2.jpg'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_video_player/layout/3.jpg'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_video_player/layout/4.jpg'
                        ],
                        '5' => [
                            'label' => esc_html__( 'Layout 5', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_video_player/layout/5.jpg'
                        ],
                        '6' => [
                            'label' => esc_html__( 'Layout 6', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_video_player/layout/6.jpg'
                        ],
                        '7' => [
                            'label' => esc_html__( 'Layout 7', 'fortis' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_video_player/layout/7.jpg'
                        ]
                    ],
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-evideo cms-evideo-'
                ]
            );
        $widget->end_controls_section();
        // video_player Section Start
        $widget->start_controls_section(
            'section_video_player',
            [
                'label' => esc_html__('Video Settings', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'video_link',
            [
                'label'    => esc_html__( 'Video URL', 'fortis' ),
                'subtitle' => esc_html__('Video url from  YouTube/Vimeo/Dailymotion','fortis'),
                'type'     => \Elementor\Controls_Manager::TEXT,
                'default'  => 'https://www.youtube.com/watch?v=iYf3OgEdGmo',
                'dynamic' => [
                    'active' => true
                ]
            ]
        );
        $widget->add_control(
            'video_icon',
            [
                'label'   => esc_html__( 'Video Icon', 'fortis' ),
                'type'    => \Elementor\Controls_Manager::ICONS,
                'skin'    => 'inline',
                'default' => [
                    'library' => 'cmsi',
                    'value'   => 'cmsi-play'
                ],
                'condition' => [
                    'video_link!' => ''
                ],
                'label_block' => false
            ]
        );
        $widget->add_control(
            'video_text',
            [
                'label'    => esc_html__( 'Video Text', 'fortis' ),
                'type'     => \Elementor\Controls_Manager::TEXTAREA,
                'default'  => '',
                'condition' => [
                    'video_link!' => ''
                ],
                'label_block' => false
            ]
        );

        $widget->add_control(
            'image',
            [
                'label'   => esc_html__( 'Video Banner', 'fortis' ),
                'type'    => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src()
                ],
                'condition' => [
                    'video_link!' => ''
                ]
            ]
        );
        $widget->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'    => 'image',
                'label'   => esc_html__('Banner Size','fortis'),
                'default' => 'custom',
                'condition' => [
                    'video_link!' => '',
                    'image[url]!' => ''
                ]
            ]
        );
        $widget->add_control(
            'image2',
            [
                'label'   => esc_html__( 'Video Banner #2', 'fortis' ),
                'type'    => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src()
                ],
                'condition' => [
                    'layout'      => ['6','7'],
                    'video_link!' => '',
                ]
            ]
        );
        $widget->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'    => 'image2',
                'label'   => esc_html__('Banner #2 Size','fortis'),
                'default' => 'custom',
                'condition' => [
                    'layout'       => ['6','7'],
                    'video_link!'  => '',
                    'image2[url]!' => ''
                ]
            ]
        );
        $widget->add_control(
            'play_style',
            [
                'type'            => \Elementor\Controls_Manager::RAW_HTML,
                'raw'             => esc_html__( 'Button Video Layout', 'fortis' ),
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
                'condition'       => [
                    'video_link!' => ''
                ]
            ]
        );
        $widget->add_control('btn-layout', [
            'label'   => esc_html__('Choose a layout', 'fortis'),
            'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
            'options' => [
                '1' => [
                    'label' => esc_html__('Layout 1', 'fortis'),
                    'image' =>
                        get_template_directory_uri().'/elementor/templates/widgets/cms_video_player/layout/btn-1.jpg',
                ],
                '2' => [
                    'label' => esc_html__('Layout 2', 'fortis'),
                    'image' =>
                        get_template_directory_uri().'/elementor/templates/widgets/cms_video_player/layout/btn-2.jpg',
                ],
                '3' => [
                    'label' => esc_html__('Layout 3', 'fortis'),
                    'image' =>
                        get_template_directory_uri().'/elementor/templates/widgets/cms_video_player/layout/btn-3.jpg',
                ],
                '4' => [
                    'label' => esc_html__('Layout 4', 'fortis'),
                    'image' =>
                        get_template_directory_uri().'/elementor/templates/widgets/cms_video_player/layout/btn-3.jpg',
                ],
                '5' => [
                    'label' => esc_html__('Layout 5', 'fortis'),
                    'image' =>
                        get_template_directory_uri().'/elementor/templates/widgets/cms_video_player/layout/btn-5.jpg',
                ]
            ],
            'condition'       => [
                'video_link!' => ''
            ]
        ]);
        $widget->end_controls_section(); // video_player Section End
        // video_player Section End
        // Content Tab Start
        $widget->start_controls_section(
            'section_video_content',
            [
                'label' => esc_html__('Content Setting', 'fortis'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout!' => ['5']
                ]
            ]
        );
        $widget->add_control(
            'title',
            [
                'label'    => esc_html__( 'Title', 'fortis' ),
                'type'     => \Elementor\Controls_Manager::TEXTAREA,
                'default'  => 'Video Titlte Here',
                'condition' => [
                    'layout' => ['1', '4']
                ]
            ]
        );
        $widget->add_control(
            'description',
            [
                'label'   => esc_html__( 'Description', 'fortis' ),
                'type'    => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam',
                'condition' => [
                    'layout' => ['1','2','3','4','5']
                ]
            ]
        );
        $widget->add_control(
            'description2',
            [
                'label'   => esc_html__( 'Description #2', 'fortis' ),
                'type'    => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam',
                'condition' => [
                    'layout' => ['4']
                ]
            ]
        );
        // Features
        $repeater = new Repeater();
        $repeater->add_control(
            'icon',
            [
                'label'       => esc_html__( 'Icon', 'fortis' ),
                'default'     => [
                    'library'   => 'cmsi',
                    'value'     => 'cmsi-check-circle'
                ],
                'type'        => Controls_Manager::ICONS,
                'skin'        => 'inline',
                'label_block' => false,
            ]
        );
        $repeater->add_control(
            'title',
            [
                'label'       => esc_html__( 'Title', 'fortis' ),
                'default'     => esc_html__( 'Title', 'fortis' ),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );
        $widget->add_control(
            'cms_feature',
            [
                'label'   => esc_html__('Features List #1', 'fortis'),
                'type'    => Controls_Manager::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => [
                    [
                        'icon'  => [
                            'library'   => 'cmsi',
                            'value'     => 'cmsi-check-circle'
                        ],
                        'title' => 'Environmental Sensitivity',
                    ],
                    [
                        'icon'  => [
                            'library'   => 'cmsi',
                            'value'     => 'cmsi-check-circle'
                        ],
                        'title' => 'Performance Measures',
                    ]
                ],
                'title_field' => '{{{ title }}}',
                'condition' => [
                    'layout' => ['3']
                ]
            ]
        );
        $widget->add_control(
            'cms_feature2',
            [
                'label'   => esc_html__('Features List #2', 'fortis'),
                'type'    => Controls_Manager::REPEATER,
                'fields'  => $repeater->get_controls(),
                'default' => [
                    [
                        'icon'  => [
                            'library'   => 'cmsi',
                            'value'     => 'cmsi-check-circle'
                        ],
                        'title' => 'Personalised Solutions',
                    ],
                    [
                        'icon'  => [
                            'library'   => 'cmsi',
                            'value'     => 'cmsi-check-circle'
                        ],
                        'title' => 'Employees Security ',
                    ]
                ],
                'title_field' => '{{{ title }}}',
                'condition' => [
                    'layout' => ['3']
                ]
            ]
        );
        // Link Button 
        $widget->add_control(
            'btn_text',
            [
                'label'       => esc_html__( 'Button Text', 'fortis' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__( 'Click here', 'fortis' ),
                'placeholder' => esc_html__( 'Click here', 'fortis' ),
                'separator'   => 'before',
                'condition' => [
                    'layout' => ['2']
                ]
            ]
        );
        $widget->add_control(
            'btn_type',
            [
                'label'   => esc_html__('Button Type', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'custom' => esc_html__('Custom', 'fortis'),
                    'page'   => esc_html__('Page', 'fortis'),
                ],
                'default'   => 'custom',
                'condition' => [
                    'layout'    => ['2'],
                    'btn_text!' => ''
                ]
            ]
        );
        $widget->add_control(
            'btn_page',
            [
                'label'   => esc_html__('Select Page', 'fortis'),
                'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                'post_type' => [
                    'page'
                ],
                'multiple'  => false,
                'condition' => [
                    'layout'    => ['2'],
                    'btn_type'  => 'page',
                    'btn_text!' => ''
                ]
            ]
        );
        $widget->add_control(
            'btn_custom',
            [
                'label'       => esc_html__( 'Custom Link', 'fortis' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                'default'     => [
                    'url' => '#',
                ],
                'condition' => [
                    'layout'    => ['2'],
                    'btn_type'  => 'custom',
                    'btn_text!' => ''
                ]
            ]
        );
        // Link Text
        $widget->add_control(
            'link_text',
            [
                'label'       => esc_html__( 'Link Text', 'fortis' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__( 'Click here', 'fortis' ),
                'placeholder' => esc_html__( 'Click here', 'fortis' ),
                'separator'   => 'before',
                'condition'   => [
                    'layout' => ['1','2']
                ]
            ]
        );
        $widget->add_control(
            'link_type',
            [
                'label'   => esc_html__('Link Type', 'fortis'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'custom' => esc_html__('Custom', 'fortis'),
                    'page'   => esc_html__('Page', 'fortis'),
                ],
                'default' => 'custom',
                'condition'   => [
                    'layout' => ['1','2'],
                    'link_text!' => ''
                ]
            ]
        );
        $widget->add_control(
            'link_page',
            [
                'label'   => esc_html__('Select Page', 'fortis'),
                'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                'post_type' => [
                    'page'
                ],
                'multiple'  => false,
                'condition' => [
                    'link_type' => 'page',
                    'layout' => ['1','2'],
                    'link_text!' => ''
                ]
            ]
        );
        $widget->add_control(
            'link_custom',
            [
                'label'       => esc_html__( 'Custom Link', 'fortis' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'fortis' ),
                'default'     => [
                    'url' => '#',
                ],
                'condition' => [
                    'link_type'  => 'custom',
                    'layout'     => ['1','2'],
                    'link_text!' => ''
                ]
            ]
        );
        $widget->end_controls_section(); 
        // Content Tab End
        // Style Tab
        $widget->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style Settings','fortis'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
            $widget->add_control(
                'title_color',
                [
                    'label'     => esc_html__( 'Title Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .video-title' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'layout' => ['1']
                    ]
                ]
            );
            $widget->add_control(
                'description_color',
                [
                    'label'     => esc_html__( 'Description Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .video-desc' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'layout' => ['1','2','3','4','5']
                    ]
                ]
            );
            $widget->add_control(
                'feature_color',
                [
                    'label'     => esc_html__( 'Features Color', 'fortis' ),
                    'type'      => \Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .video-features' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'layout' => ['3']
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
