( function( $ ) {
    /**
     * @param $scope The Widget wrapper element as a jQuery element
     * @param $ The jQuery alias
     */
    var WidgetCMSChartHandler = function( $scope, $ ) {
        var charts = $scope.find(".cms-charts"),
            data = charts.data(), 
            settings = data.settings;
        // Doughnut chart
        chart_settings = { 
            type: settings['type'],
            data: {
                labels: settings['labels'],
                datasets: [{
                    data: settings['value'],
                    backgroundColor: settings['colors'],
                    borderWidth: 0,
                    borderColor: '#ffffff',
                    //fill: false,
                    //borderColor: 'rgb(75, 192, 192)',
                    //tension: 0.1
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    title: {
                        display:  settings['title_display'],
                        text:  settings['title_text'],
                        position: settings['title_position'],
                        fontSize: 16,
                        fontColor: '#111',
                        padding: 20
                    },
                    legend: {
                        display: settings['legend_display'],
                        position: settings['legend_position'],
                        labels: {
                            boxWidth: 10,
                            fontColor: '#9b9b9b',
                            padding: 15
                        }
                    },
                    tooltips: {
                        enabled: true
                    },
                    datalabels: {
                        color: '#111',
                        textAlign: 'center',
                        font: {
                            lineHeight: 1.6
                        },
                        formatter: function(value, ctx) {
                            return ctx.chart.data.labels[ctx.dataIndex] + 'n'+ 'n'+ 'n'+ 'n'+ 'n'+ 'n' + value + '%';
                        }
                    }
                }
            }
        };
        charts.each(function(index, element) {
            var ctx = charts.attr('id');
            var myChart = new Chart(ctx, chart_settings);
        });  
        
    };

    // Make sure you run this code under Elementor.
    $( window ).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/cms_chart.default', WidgetCMSChartHandler );
    } );
} )( jQuery );