<?php
$html_id            = etc_get_element_id( $settings );
$active_section     = $widget->get_settings('active_section', 1);
$accordions         = $widget->get_settings('cms_accordion');
?>
<div class="cms-accordion-wrap cms-accordion-<?php echo esc_attr($widget->get_setting('layout','1')); ?>">
	<?php
	foreach ( $accordions as $key => $value ):
		$is_active = ( $key + 1 ) == $active_section;
		$_id        = isset( $value['_id'] ) ? $value['_id'] : '';
		$ac_title   = isset( $value['ac_title'] ) ? $value['ac_title'] : '';
		$ac_content = isset( $value['ac_content'] ) ? $value['ac_content'] : '';

		$title_key = $widget->get_repeater_setting_key( 'ac_title', 'cms_accordion', $key );
		$widget->add_render_attribute( $title_key, [
			'class' => [ 'cms-accordion-title-text' ],
		] );
		$widget->add_inline_editing_attributes($title_key);

		$content_key = $widget->get_repeater_setting_key( 'ac_content', 'cms_accordion', $key );
		$widget->add_render_attribute( $content_key, [
			'id'    => $_id . $html_id,
			'class' => [ 'cms-accordion-content' ],
		] );
		if ( $is_active ) {
			$widget->add_render_attribute( $content_key, 'style', 'display:block;' );
		}
		else{
			$widget->add_render_attribute( $content_key, 'style', 'display:none;' );
		}
		$widget->add_inline_editing_attributes($content_key);
		?>
		<div class="cms-accordion-item <?php echo esc_attr( $is_active ? 'active' : '' ); ?>">
		    <div class="cms-accordion-title <?php echo esc_attr( $is_active ? 'active' : '' ); ?>" data-target="<?php echo esc_attr( '#' . $_id . $html_id ); ?>">
		    	<span <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php echo esc_html( $ac_title ); ?></span>
		    </div>
		    <div <?php etc_print_html( $widget->get_render_attribute_string( $content_key ) ); ?>>
				<?php echo wp_kses_post( nl2br( $ac_content ) ); ?>
			</div>
		</div>
	<?php
	endforeach;
	?>
</div>
