<?php
$page_link = $widget->get_setting('btn_page_link','');
//Button
switch ($settings['btn_link_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('btn_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'button', [
	'class' => [
		'empty-none',
		'pt-25',
		'text-white text-hover-secondary',
		'd-flex gap-10 align-items-center'
	],
	'href'	=> $url
]);

ob_start();
?>
	<div class="cms-contents bg-primary text-white cms-radius-4 relative z-top ml-auto cms-radius-4">
		<?php 
			\Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true','class' => 'text-64 mb-25' ] );
		?>
		<div class="cms-banner-title cms-heading empty-none text-white text-17 pb-15"><?php etc_print_html($settings['title']); ?></div>
		<div class="cms-banner-desc empty-none text-white text-15"><?php etc_print_html($settings['description']); ?></div>
		<a <?php etc_print_html($widget->get_render_attribute_string('button')) ?>><?php
			//icon
			\Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true','class' => 'text-22' ] );
		?></a>
	</div>
<?php
	$content = ob_get_clean();
	fortis_elementor_image_render($settings,[
		'name'        => 'banner',
		'img_class'   => 'img-cover cms-radius-4',	
		'custom_size' => ['width' => 620, 'height' => 510],
		'before'      => '<div class="pr-40 cms-overlay">',
		'after'       => '</div>'.$content
	]);
?>