<?php
$page_link = $widget->get_setting('btn_page_link','');

//Button
switch ($settings['btn_link_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('btn_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'button', [
	'class' => [
		'btn btn-lg',
		'btn-secondary btn-hover-primary',
		'empty-none',
		'mt-30'
	],
	'href'	=> $url
]);
?>
<div class="d-flex gutter gutter-grid justify-content-center">
	<?php  
	// Render HTML
	fortis_elementor_image_render($settings,[
		'name'        => 'banner',
		'img_class'   => 'cms-sticky',	
		'custom_size' => ['width' => 400, 'height' => 400],
		'before'      => '<div class="cms-banner-img flex-auto">',
		'after'       => '</div>'
	]);
	?>
	<div class="cms-banner-content flex-basic mt-n10">
		<div class="cms-banner-desc empty-none"><?php echo nl2br($settings['description']); ?></div>
		<a <?php etc_print_html( $widget->get_render_attribute_string( 'button' ) ); ?>><?php echo esc_html( $settings['btn_text'] );?> <i class="cms-icon cmsi-arrow-right rtl-flip text-10"></i></a>
	</div>
</div>