<?php
// CTA
$widget->add_inline_editing_attributes( 'cta_text' );
$widget->add_inline_editing_attributes( 'cta_text_link' );
$page_link = $widget->get_setting('cta_page_link','');
$widget->add_render_attribute('cta_text', [
	'class' => ['cms-banner-cta cms-cta-text text-15 font-700 mt-n5 pr-90 pr-tablet-extra-20 pt-mobile-extra-40']
]);
//CTA Button
$cta_page_link = $widget->get_setting('cta_page_link','');
switch ($settings['cta_link_type']) {
	case 'page':
		$page = !empty($cta_page_link) ? get_page_by_path($cta_page_link, OBJECT) : [];
		$cta_url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$cta_url = $widget->get_setting('cta_custom_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'cta_link_text', [
	'class' => ['cta-link text-underline text-primary'],
	'href'	=> $cta_url
]);

//Button
$page_link = $widget->get_setting('btn_page_link','');
switch ($settings['btn_link_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('btn_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'button', [
	'class' => [
		'btn btn-lg',
		'btn-secondary btn-hover-primary'
	],
	'href'	=> $url
]);
// Button #2
$page2_link = $widget->get_setting('btn2_page_link','');
switch ($settings['btn2_link_type']) {
	case 'page':
		$page = !empty($page2_link) ? get_page_by_path($page2_link, OBJECT) : [];
		$url2  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url2 = $widget->get_setting('btn2_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'btn2_text', [
	'class' => [
		'cms-link',
		'text-primary',
		'text-hover-secondary'
	],
	'href'	=> $url2
]);
?>
<div class="cms-banner d-flex">
	<div class="cms-banner-content col-5 col-mobile-extra-12 z-top d-flex align-content-between">
		<div <?php etc_print_html($widget->get_render_attribute_string('cta_text')) ?>>
			<?php etc_print_html($settings['cta_text']) ?>
			<a <?php etc_print_html( $widget->get_render_attribute_string( 'cta_link_text' ) ); ?>>
				<?php 
					// text
					echo esc_html( $settings['cta_link_text'] );
				?>
			</a>
		</div>
		<div class="cms-banner--content bg-white mr-n70 mr-mobile-extra-n0 ml-n20 pl-20 pt-70 pt-tablet-extra-20 pr-110 pr-tablet-extra-20 cms-radius-tr-3">
			<div class="cms-banner-desc text-16 empty-none"><?php echo nl2br($settings['description']); ?></div>
			<div class="cms-banner-buttons d-flex gap pt-35" style="--cms-gap:30px;">
				<a <?php etc_print_html( $widget->get_render_attribute_string( 'button' ) ); ?>><?php echo esc_html( $settings['btn_text'] );?> <i class="cms-icon cmsi-arrow-right rtl-flip text-10"></i></a>
				<a <?php etc_print_html( $widget->get_render_attribute_string( 'btn2_text' ) ); ?>><?php echo esc_html( $settings['btn2_text'] );?> <i class="cms-icon cmsi-arrow-alt-circle-right rtl-flip text-32"></i></a>
			</div>
		</div>
	</div>
	<?php  
	// Render HTML
	fortis_elementor_image_render($settings,[
		'name'        => 'banner',
		'img_class'   => 'cms-sticky cms-radius-3 img-cover',
		'max_height'  => true,	
		'custom_size' => ['width' => 730, 'height' => 452],
		'before'      => '<div class="cms-banner-img col-7 col-mobile-extra-12 order-mobile-extra-first">',
		'after'       => '</div>'
	]);
	?>
</div>