<?php
// Feature
$features = $widget->get_setting('cms_feature', []);
//Button
$page_link = $widget->get_setting('btn_page_link','');
switch ($settings['btn_link_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('btn_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'button', [
	'class' => [
		'btn btn-lg'
	],
	'href'	=> $url
]);
// Button #2
$page2_link = $widget->get_setting('btn2_page_link','');
switch ($settings['btn2_link_type']) {
	case 'page':
		$page = !empty($page2_link) ? get_page_by_path($page2_link, OBJECT) : [];
		$url2  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url2 = $widget->get_setting('btn2_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'btn2_text', [
	'class' => [
		'btn btn-lg btn-outline btn-1'
	],
	'href'	=> $url2
]);

// Banner content 
ob_start();
?>
	<div class="cms-contents bg-primary cms-triangle-bt primary relative z-top cms-radius-trb-10">
		<?php 
			\Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true','class' => 'text-64 text-white mb-25' ] );
		?>
		<div class="cms-banner-title cms-heading empty-none text-white text-17"><?php etc_print_html($settings['title']); ?></div>
	</div>
<?php
	$banner_content = ob_get_clean();
?>
<div class="cms-banner d-flex align-items-end">
	<?php  
	// Render HTML
	fortis_elementor_image_render($settings,[
		'name'        => 'banner',
		'img_class'   => 'cms-overlay cms-radius-10 img-cover',
		'max_height'  => true,	
		'custom_size' => ['width' => 840, 'height' => 667],
		'before'      => '<div class="cms-banner-img col-8 col-mobile-extra-12"><div class="cms-banner--img relative">',
		'after'       => $banner_content.'</div></div>'
	]);
	?>
	<div class="cms-banner-content col-4 col-mobile-extra-12 z-top d-flex align-content-between">
		<div class="cms-banner--content bg-white ml-n180 ml-mobile-extra-n0 pt-60 pt-tablet-extra-20 pl-70 pl-tablet-extra-20 pl-mobile-0 cms-radius-tl-10">
			<div class="cms-banner-heading h2 font-600 empty-none pb-15"><?php echo nl2br($settings['heading']); ?></div>
			<div class="cms-banner-desc text-17 empty-none"><?php echo nl2br($settings['description']); ?></div>
			<div class="cms-banner-features cms-efeatures cms-lists-1 pt-30">
			<?php 
				foreach ( $features as $key => $cms_feature ):
					$title_key = $widget->get_repeater_setting_key( 'title', 'cms_list', $key );
					$widget->add_render_attribute($title_key, 'class', 'flex-basic');
					$widget->add_inline_editing_attributes( $title_key );
				?>
			        <div class="cms-list d-flex">
			            <?php 
			            	\Elementor\Icons_Manager::render_icon( $cms_feature['icon'], [ 'aria-hidden' => 'true', 'class' => 'cms-icon flex-auto' ] ); 
			            ?>
			            <span <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php echo esc_html( $cms_feature['title'] ) ?></span>
			        </div>
				<?php endforeach;
			?>
			</div>
			<div class="cms-banner-buttons d-flex gap pt-40" style="--cms-gap:30px;">
				<a <?php etc_print_html( $widget->get_render_attribute_string( 'button' ) ); ?>><?php echo esc_html( $settings['btn_text'] );?><i class="cms-icon cmsi-arrow-right rtl-flip text-10"></i></a>
				<a <?php etc_print_html( $widget->get_render_attribute_string( 'btn2_text' ) ); ?>><?php echo esc_html( $settings['btn2_text'] );?></a>
			</div>
		</div>
	</div>
</div>