<?php
$widget->add_inline_editing_attributes( 'text', 'none' );
$page_link = $widget->get_setting('page_link','');

//Button
switch ($settings['link_type']) {
	case 'page':
		$page = !empty($page_link) ? get_page_by_path($page_link, OBJECT) : [];
		$url  = !empty($page) ? get_permalink($page->ID) : '#';
		break;
	
	default:
		$url = $widget->get_setting('link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'button', [
	'class' => [
		'btn',
		$settings['size'],
		$settings['style'],
		'icon-' . $widget->get_setting('icon_align','last')
	],
	'href'	=> $url
]);
// Icon
$icon = array_merge( ['library' => 'cmsi', 'value' => 'cmsi-arrow-right'], $widget->get_setting('btn_icon') );
$icon_class = 'cms-btn-icon text-10 rtl-flip';
?>
<a <?php etc_print_html( $widget->get_render_attribute_string( 'button' ) ); ?>>
	<?php 
		// icon
		\Elementor\Icons_Manager::render_icon( $icon, [ 'aria-hidden' => 'true', 'class' => $icon_class ] ); 
	?>
	<span <?php etc_print_html( $widget->get_render_attribute_string( 'text' ) ); ?>><?php 
		// text
		echo esc_html( $settings['text'] );
	?></span>
</a>