<?php
// Sources
$source    = $widget->get_setting('source',[]);
$orderby   = $widget->get_setting('orderby','date');
$order     = $widget->get_setting('order','desc');
$limit     = $widget->get_setting('limit','5');

$tax = [];
foreach ($source as $category){
    $category_arr = explode('|', $category);
    $tax[] = $category_arr[0];
}
// Main Post
$main_posts = etc_get_posts_of_grid('cms-case', [
    'post_type'                  => 'cms-case',   
    'source'                     => $source,
    'orderby'                    => $orderby,
    'order'                      => $order,
    'limit'                      => '1',
    'tax'                        => $tax
]);

// Second Post
$second_posts = etc_get_posts_of_grid('cms-case', 
    [
        'post_type' => 'cms-case',   
        'source'    => $source,
        'orderby'   => $orderby,
        'order'     => $order,
        'limit'     => $limit - 1,
        'tax'       => $tax
    ], 
    [] , 
    [
        'offset'    => 1
    ]
);
?>
<div class="d-flex gutter" style="--gutter:40px;--gutter-tablet:40px;">
    <div class="cms-main-posts col-6 col-tablet-8 col-mobile-extra-12">
        <?php // Content
            foreach ($main_posts['posts'] as $post):
                ?>
                <div class="cms-item-content cms-sticky">
                    <?php
                        fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => ['width' => 620, 'height' => 351],
                            'img_class'   => 'img-cover',
                            'max_height'  => true
                        ]);
                    ?>
                    <div class="pl-60 pl-mobile-20 mt-n100 relative">
                        <?php // post category
                        the_terms($post->ID, 'category', '<div class="cms-post-meta bg-primary">', ', ','</div>'); ?>
                        <div class="cms--content bg-white cms-shadow-3">
                            <h3 class="cms-heading"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h3>
                            <div class="cms-excerpt text-line-3"><?php 
                                echo wp_trim_words($post->post_excerpt, 28, '&hellip;');
                                // Read More
                            ?></div>
                            <div class="cms-meta d-flex justify-content-between align-items-center">
                                <div class="meta">
                                    <div class="author"><?php fortis_the_author_posts_link([
                                        'text'       => esc_html__('By:', 'fortis').'&nbsp;',
                                        'link_class' => 'text-primary text-hover-secondary',
                                        'object'     => $post   
                                    ]); ?></div>
                                    <div class="date"><?php echo get_the_date('', $post->ID); ?></div>
                                </div>
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="cms-readmore font-700 align-items-center">
                                    <i class="cmsi-arrow-right rtl-flip"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
        <?php endforeach; ?>
    </div>
    <div class="cms-second-posts col-6 col-tablet-4 col-mobile-extra-12">
        <div class="pl-40 pl-tablet-0">
            <?php // Content
                foreach ($second_posts['posts'] as $post):
                    ?>
                    <div class="cms-item-content d-flex gutter align-items-center" style="--gutter:40px;--gutter-tablet:20px;">
                        <?php
                            fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => ['width' => 180, 'height' => 120],
                            'before'      => '<div class="flex-auto">',
                            'after'       => '</div>'
                        ]);
                        ?>
                        <div class="cms-item-content-inner flex-basic flex-tablet-full flex-mobile-extra-basic flex-smobile-full">
                            <div class="d-flex gap text-14 pb-7" style="--cms-gap:20px;--cms-gap-tablet:20px;--cms-gap-mobile:20px;">
                                <div class="author"><?php fortis_the_author_posts_link([
                                    'text'       => esc_html__('By:', 'fortis').'&nbsp;',
                                    'link_class' => 'text-primary text-hover-secondary',
                                    'object'     => $post   
                                ]); ?></div>
                                <div class="date"><?php echo get_the_date('', $post->ID); ?></div>
                            </div>
                            <h4 class="cms-item-content-title cms-heading font-500 mb-0 text-line-3">
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a>
                            </h4>
                        </div>
                    </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>