<?php
// Sources
$source    = $widget->get_setting('source',[]);
$orderby   = $widget->get_setting('orderby','date');
$order     = $widget->get_setting('order','desc');
$limit     = $widget->get_setting('limit','5');

$tax = [];
foreach ($source as $category){
    $category_arr = explode('|', $category);
    $tax[] = $category_arr[0];
}
// Main Post
$main_posts = etc_get_posts_of_grid('cms-case', [
    'post_type'                  => 'cms-case',   
    'source'                     => $source,
    'orderby'                    => $orderby,
    'order'                      => $order,
    'limit'                      => '1',
    'tax'                        => $tax
]);

// Second Post
$second_posts = etc_get_posts_of_grid('cms-case', 
    [
        'post_type' => 'cms-case',   
        'source'    => $source,
        'orderby'   => $orderby,
        'order'     => $order,
        'limit'     => 1,
        'tax'       => $tax
    ], 
    [] , 
    [
        'offset'    => 1
    ]
);
// Third Post
$third_posts = etc_get_posts_of_grid('cms-case', 
    [
        'post_type' => 'cms-case',   
        'source'    => $source,
        'orderby'   => $orderby,
        'order'     => $order,
        'limit'     => $limit - 2,
        'tax'       => $tax
    ], 
    [] , 
    [
        'offset'    => 2
    ]
);
?>
<div class="d-flex gutter gutter-grid" style="--gutter:40px;">
    <div class="cms-main-posts col-6 col-mobile-extra-12">
        <?php // Content
            foreach ($main_posts['posts'] as $post):
                ob_start();
                ?>
                    <div class="cms-content bg-white absolute bottom-left-40 cms-transition">
                        <?php // post category
                    the_terms($post->ID, 'case-category', '<div class="cms-post--meta text-14">', ', ','</div>'); ?>
                        <h4 class="cms-heading text-line-2"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="case-readmore d-flex align-items-center justify-content-center text-10">
                            <i class="cmsi-arrow-right rtl-flip"></i>
                        </a>
                    </div>
                <?php
                    $content = ob_get_clean();

                fortis_elementor_post_thumbnail_render($settings, [
                    'post_id'     => $post->ID,
                    'custom_size' => ['width' => 730, 'height' => 730],
                    'img_class'   => 'img-cover',
                    'max_height'  => true,  
                    'before'      => '<div class="cms-content-wrap relative cms-sticky">',
                    'after'       => $content.'</div>'
                ]);
        ?>
        <?php endforeach; ?>
    </div>
    <div class="cms-second-posts col-6 col-mobile-extra-12">
        <?php // Content
            foreach ($second_posts['posts'] as $post):
                ob_start();
            ?>
                <div class="cms-content bg-white absolute bottom-left-40 cms-transition">
                    <?php // post category
                the_terms($post->ID, 'case-category', '<div class="cms-post--meta text-14">', ', ','</div>'); ?>
                    <h4 class="cms-heading text-line-2"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="case-readmore d-flex align-items-center justify-content-center text-10">
                        <i class="cmsi-arrow-right rtl-flip"></i>
                    </a>
                </div>
            <?php
                $content = ob_get_clean();

                fortis_elementor_post_thumbnail_render($settings, [
                'post_id'     => $post->ID,
                'custom_size' => ['width' => 730, 'height' => 345],
                'img_class'   => 'img-cover',
                'max_height'  => true,
                'before'      => '<div class="cms-content-wrap relative mb-40">',
                'after'       => $content.'</div>'
            ]);
        endforeach; ?>
        <div class="third-posts d-flex gutter gutter-grid" style="--gutter:40px;">
            <?php // Content
                foreach ($third_posts['posts'] as $post):
                     ob_start();
                ?>
                    <div class="cms-content bg-white absolute bottom-left-40 cms-transition">
                        <?php // post category
                    the_terms($post->ID, 'case-category', '<div class="cms-post--meta text-14">', ', ','</div>'); ?>
                        <h4 class="cms-heading text-line-2"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a></h4>
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="case-readmore d-flex align-items-center justify-content-center text-10">
                            <i class="cmsi-arrow-right rtl-flip"></i>
                        </a>
                    </div>
                <?php
                    $content = ob_get_clean();
                    ?>
                    <div class="col-6 col-tablet-extra-12">
                        <?php
                            fortis_elementor_post_thumbnail_render($settings, [
                            'post_id'     => $post->ID,
                            'custom_size' => ['width' => 345, 'height' => 345],
                            'max_height'  => true,
                            'img_class'   => 'img-cover',
                            'before'      => '<div class="cms-content-wrap relative">',
                            'after'       => $content.'</div>'
                        ]);
                        ?>
                    </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>