<?php
use Elementor\Group_Control_Image_Size;
use Elementor\Control_Media;
use Elementor\Icons_Manager;

$clients = $widget->get_setting('clients', []);
if(empty($clients)) return;

$arrows = $widget->get_setting('arrows', '');
$dots = $widget->get_setting('dots', '');
//
$thumbnail_custom_dimension = [
    'width'  => !empty($settings['image_custom_dimension']['width']) ? $settings['image_custom_dimension']['width'] : '150',
    'height' => !empty($settings['image_custom_dimension']['height']) ? $settings['image_custom_dimension']['height'] : '60'
];
?>
<div class="cms-carousel swiper">
    <div class="swiper-wrapper">
        <?php
        foreach ($clients as $key => $client) {
            $client['image_size'] = $settings['image_size'];
            $client['image_custom_dimension'] = $thumbnail_custom_dimension;
            $client['link']['custom_attributes'] .= ',class|client-item swiper-slide';
            $client['link']['custom_attributes'] .= ',title|'.$client['name'];

            $link_key = $widget->get_repeater_setting_key( 'link', 'cms_client_link', $key );
            $widget->add_link_attributes( $link_key, $client['link'] );
            ?>
            <a <?php etc_print_html($widget->get_render_attribute_string( $link_key )); ?>><?php
                fortis_elementor_image_render($client,[
                    'name'           => 'image',
                    'image_size_key' => 'image',
                    'img_class'      => 'p-lr-10',
                    'custom_size'    => $thumbnail_custom_dimension,
                    'before'         => '',
                    'after'          => ''
                ]);
                //echo esc_html($client['name']);
            ?></a>
        <?php } ?>
    </div>
    <?php if ($arrows == 'yes') : ?>
        <div class="cms-carousel-button-in-vert prev cms-carousel-button-prev">
            <?php
            $icon_settings = $widget->get_settings_for_display('arrow_prev_icon');
            if (empty($icon_settings['value'])) {
                $icon_settings = [
                    'library' => 'eicons',
                    'value'   => 'eicon-chevron-left',
                ];
            }
            Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
            ?>
        </div>
        <div class="cms-carousel-button-in-vert next cms-carousel-button-next">
            <?php
            $icon_settings = $widget->get_settings_for_display('arrow_next_icon');
            if (empty($icon_settings['value'])) {
                $icon_settings = [
                    'library' => 'eicons',
                    'value'   => 'eicon-chevron-right',
                ];
            }
            Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
            ?>
        </div>
    <?php endif ?>
    <?php if ($dots == 'yes') : ?>
        <div class="cms-carousel-dots cms-carousel-dots-out"></div>
    <?php endif ?>
</div>