<?php
$default_settings = [
	'date' => '2030/10/10',
];
$settings         = array_merge( $default_settings, $settings );
extract( $settings );
$month   = esc_html__( 'Month', 'fortis' );
$months  = esc_html__( 'Months', 'fortis' );
$day     = esc_html__( 'Day', 'fortis' );
$days    = esc_html__( 'Days', 'fortis' );
$hour    = esc_html__( 'Hour', 'fortis' );
$hours   = esc_html__( 'Hours', 'fortis' );
$minute  = esc_html__( 'Minute', 'fortis' );
$minutes = esc_html__( 'Minutes', 'fortis' );
$second  = esc_html__( 'Second', 'fortis' );
$seconds = esc_html__( 'Seconds', 'fortis' );
wp_enqueue_script( 'cms-countdown-config', get_template_directory_uri() . '/elementor/js/cms-countdown.js', array( 'jquery' ), 'all', true );
?>
<div class="cms-countdown-wrap">
    <div class="cms-countdown"
         data-month="<?php echo esc_attr( $month ) ?>"
         data-months="<?php echo esc_attr( $months ) ?>"
         data-day="<?php echo esc_attr( $day ) ?>"
         data-days="<?php echo esc_attr( $days ) ?>"
         data-hour="<?php echo esc_attr( $hour ) ?>"
         data-hours="<?php echo esc_attr( $hours ) ?>"
         data-minute="<?php echo esc_attr( $minute ) ?>"
         data-minutes="<?php echo esc_attr( $minutes ) ?>"
         data-second="<?php echo esc_attr( $second ) ?>"
         data-seconds="<?php echo esc_attr( $seconds ) ?>">
        <div class="cms-countdown-inner" data-count-down="<?php echo esc_attr( $date ); ?>"></div>
    </div>
</div>