<?php
$counters = $widget->get_setting('counters', []);
if(empty($counters)) return;

use Elementor\Icons_Manager;
// Items
$widget->add_render_attribute( 'counter-item',[
	'class' => [
		'counter-item',
		'relative',
		($settings['layout_mode'] === 'carousel') ? 'swiper-slide' : ''
	]
]);
// Title
$widget->add_inline_editing_attributes( 'title');
$widget->add_render_attribute('title', 'class', 'cms-counter-title cms-heading text-17 empty-none text-heading pb-15' );
// Description
$widget->add_inline_editing_attributes( 'description');
$widget->add_render_attribute('description', 'class', 'cms-counter-desc text-15 mb-n7 empty-none' );
// Layout mode setting
$widget->add_render_attribute('grid-settings',[
    'class' => [
        'cms-counter-grid',
        'd-grid',
        'grid-'.$widget->get_setting('col','1'),
        'grid-tablet-'.$widget->get_setting('col_tablet','1'),
        'grid-mobile-'.$widget->get_setting('col_mobile','1'),
        'gap'
    ],
    'style' => '--cms-gap:40px;--cms-gap-tablet:30px;--cms-gap-mobile:20px;'
]);

// Start Content
// Banner 
fortis_elementor_image_render($settings, [
	'name'        => 'banner',
	'custom_size' => ['width' => '510','height' => '538'],
	'img_class'   => 'img-cover',
	'max_height'  => false,		
	'before'      => '<div class="cms-counter-banner cms-overlay clip-path-2">',		
	'after'       => '</div>'	
]);
?>
<div class="cms-contents bg-white cms-triangle-bt relative z-top">
	<?php
	switch ($settings['layout_mode']) {
		case 'carousel':
	?>
	<div class="cms-carousel swiper">
		<div class="swiper-wrapper">
	<?php
		break;
		default:
	?>
	<div <?php etc_print_html($widget->get_render_attribute_string('grid-settings')); ?>>
	<?php
		break;
	}
	// Start item
	foreach ($counters as $key => $counter) {
	$counter['icon_image_size'] = $settings['icon_image_size']; // fix image size
	$counter['icon_image_custom_dimension'] = $settings['icon_image_custom_dimension']; // fix image size
	$data_counter     = $widget->get_repeater_setting_key( 'counter-number', 'cms_counter', $key );
    $widget->add_render_attribute( $data_counter, [
        'class'          => 'cms-counter-number heading elementor-counter-number text-75',
        'data-duration'  => $counter['duration'],
        'data-to-value'  => $counter['ending_number'],
        'data-delimiter' => !empty($counter['thousand_separator_char']) ? $counter['thousand_separator_char'] : ',',
    ] );
   	?>
   	<div <?php etc_print_html($widget->get_render_attribute_string('counter-item')); ?>>
	   	<?php if($counter['show_icon'] === 'yes'){ ?>
		    <div class="cms-counter-icon empty-none text-primary pb-25"><?php
			    // Counter Icon
				switch ($counter['icon_type']) {
					case 'image':
						fortis_elementor_image_render($counter, [
							'name'           => 'icon_image',
							'image_size_key' => '',
							'custom_size'    => ['width' => 64, 'height' => 64]
						]);
						break;
					
					default:
						\Elementor\Icons_Manager::render_icon( $counter['counter_icon'], [ 'aria-hidden' => 'true'] );
						break;
				}
			?></div>
		<?php } ?>
		<div class="cms-counter-numbers text-secondary pb-15">
		    <span class="cms-counter-number-prefix empty-none"><?php echo esc_html( $counter['prefix'] ); ?></span>
		    <span <?php etc_print_html( $widget->get_render_attribute_string( $data_counter ) ); ?>><?php echo esc_html( $counter['starting_number'] ); ?></span>
		    <span class="cms-counter-number-suffix empty-none"><?php echo esc_html( $counter['suffix'] ); ?></span>
		</div>
		<div <?php etc_print_html($widget->get_render_attribute_string( 'title')); ?>><?php echo nl2br( $counter['title'] ); ?></div>
		<div <?php etc_print_html($widget->get_render_attribute_string( 'description')); ?>><?php echo nl2br( $counter['description'] ); ?></div>
	</div>
<?php
	} // end foreach

	switch ($settings['layout_mode']) {
		case 'carousel':
	?>
		</div>
		<?php if ($settings['arrows'] == 'yes') : ?>
            <div class="cms-carousel-button-in-vert prev cms-carousel-button-prev">
                <?php
                $icon_settings = $widget->get_settings_for_display('arrow_prev_icon');
                if (empty($icon_settings['value'])) {
                    $icon_settings = [
						'library' => 'eicons',
						'value'   => 'eicon-chevron-left',
                    ];
                }
                Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
                ?>
            </div>
            <div class="cms-carousel-button-in-vert next cms-carousel-button-next">
                <?php
                $icon_settings = $widget->get_settings_for_display('arrow_next_icon');
                if (empty($icon_settings['value'])) {
                    $icon_settings = [
						'library' => 'eicons',
						'value'   => 'eicon-chevron-right',
                    ];
                }
                Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
                ?>
            </div>
        <?php endif ?>
        <?php if ($settings['dots'] == 'yes') : ?>
            <div class="cms-carousel-dots cms-carousel-dots-in style-2"></div>
        <?php endif ?>
	</div>
	<?php
		break;
		default:
	?>
	</div>
	<?php
		break;
	}
?>
</div>