<?php
$counters = $widget->get_setting('counters', []);
if(empty($counters)) return;

use Elementor\Icons_Manager;

// Title
$widget->add_inline_editing_attributes( 'title');
$widget->add_render_attribute('title', 'class', 'cms-counter-title cms-heading text-body text-19' );
// Description
$widget->add_inline_editing_attributes( 'description');
$widget->add_render_attribute('description', 'class', 'cms-counter-desc text-15' );
// Layout mode setting
$widget->add_render_attribute('grid-settings',[
    'class' => [
        'cms-counter-grid',
        'd-grid',
        'grid-'.$widget->get_setting('col','1'),
        'grid-tablet-'.$widget->get_setting('col_tablet','1'),
        'grid-mobile-'.$widget->get_setting('col_mobile','1'),
        'gap'
    ],
    'style' => '--cms-gap:32px;--cms-gap-tablet:32px;--cms-gap-mobile:32px;'
]);
// Start layout 
	switch ($settings['layout_mode']) {
		case 'carousel':
	?>
	<div class="cms-carousel swiper">
		<div class="swiper-wrapper">
	<?php
		break;
		default:
	?>
	<div <?php etc_print_html($widget->get_render_attribute_string('grid-settings')); ?>>
	<?php
		break;
	}
	// Start Item
	$count = 0;
	foreach ($counters as $key => $counter) {
		$count ++;
		$counter['icon_image_size'] = $settings['icon_image_size']; // fix image size
		$counter['icon_image_custom_dimension'] = $settings['icon_image_custom_dimension']; // fix image size
		// item
		$counter_item = $widget->get_repeater_setting_key( 'counter-item', 'cms_counter', $key );
		// Items
		$widget->add_render_attribute( $counter_item, [
			'class' => [
				'counter-item',
				'relative',
				($settings['layout_mode'] === 'carousel') ? 'swiper-slide' : ''
			]
		]);
		if($count === 1){
			$widget->add_render_attribute($counter_item, 'class', 'active');
		}
		// data counter
		$data_counter     = $widget->get_repeater_setting_key( 'counter-number', 'cms_counter', $key );
	    $widget->add_render_attribute( $data_counter, [
	        'class'          => 'cms-counter-number heading elementor-counter-number text-75',
	        'data-duration'  => $counter['duration'],
	        'data-to-value'  => $counter['ending_number'],
	        'data-delimiter' => !empty($counter['thousand_separator_char']) ? $counter['thousand_separator_char'] : ',',
	    ] );
	?>
	<div <?php etc_print_html($widget->get_render_attribute_string($counter_item)); ?>>
		<div class="counter--item d-flex justify-content-between align-items-center gutter cms-transition">
			<div class="cms-counter-numbers text-heading-lighten">
			    <span class="cms-counter-number-prefix"><?php echo esc_html( $counter['prefix'] ); ?></span>
			    <span <?php etc_print_html( $widget->get_render_attribute_string( $data_counter ) ); ?>><?php echo esc_html( $counter['starting_number'] ); ?></span>
			    <span class="cms-counter-number-suffix"><?php echo esc_html( $counter['suffix'] ); ?></span>
			</div>
			<div class="cms-ounter-content text-end text-mobile-start">
				<?php
			    if($counter['show_icon'] === 'yes'){
			    ?>
				    <div class="cms-counter-icon text-primary pb-15 empty-none"><?php
					    // Counter Icon
						switch ($counter['icon_type']) {
							case 'image':
								fortis_elementor_image_render($counter, [
									'name'           => 'icon_image',
									'image_size_key' => 'icon_image',
									'custom_size'    => ['width' => 64, 'height' => 64]
								]);
								break;
							
							default:
								\Elementor\Icons_Manager::render_icon( $counter['counter_icon'], [ 'aria-hidden' => 'true' ] );
								break;
						}
					?></div>
				<?php } ?>
				<?php if ( $counter['title'] ) : ?>
				    <div <?php etc_print_html($widget->get_render_attribute_string( 'title')); ?>><?php echo nl2br( $counter['title'] ); ?></div>
				<?php endif;
				// Description
				if ( $counter['description'] ) : ?>
				    <div <?php etc_print_html($widget->get_render_attribute_string( 'description')); ?>><?php echo nl2br( $counter['description'] ); ?></div>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<?php
	} // end foreach

	switch ($settings['layout_mode']) {
		case 'carousel':
	?>
		</div>
		<?php if ($settings['arrows'] == 'yes') : ?>
            <div class="cms-carousel-button-in-vert prev cms-carousel-button-prev">
                <?php
                $icon_settings = $widget->get_settings_for_display('arrow_prev_icon');
                if (empty($icon_settings['value'])) {
                    $icon_settings = [
						'library' => 'eicons',
						'value'   => 'eicon-chevron-left',
                    ];
                }
                Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
                ?>
            </div>
            <div class="cms-carousel-button-in-vert next cms-carousel-button-next">
                <?php
                $icon_settings = $widget->get_settings_for_display('arrow_next_icon');
                if (empty($icon_settings['value'])) {
                    $icon_settings = [
						'library' => 'eicons',
						'value'   => 'eicon-chevron-right',
                    ];
                }
                Icons_Manager::render_icon($icon_settings, ['aria-hidden' => 'true']);
                ?>
            </div>
        <?php endif ?>
        <?php if ($settings['dots'] == 'yes') : ?>
            <div class="cms-carousel-dots cms-carousel-dots-out"></div>
        <?php endif ?>
	</div>
	<?php
		break;
		default:
	?>
	</div>
	<?php
		break;
	}
?>

